/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tws.TwsGlobals;

public class TwsJobAttributes {
    private String name;
    private IAttrHolder jobAttributes;
    private IAttrHolder scheduleJob;
    private AttrHolderList scheduleJobParms;

    TwsJobAttributes(IAttrHolder schedJob) {
        this.scheduleJob = schedJob;
        this.name = TwsGlobals.createAliasFromFullId(schedJob.getAttr("ID"));
    }

    public void addtoscheduleJobParms(IAttrHolder scheduleJobParams) {
        if (this.scheduleJobParms == null) {
            this.scheduleJobParms = new AttrHolderList();
        }
        this.scheduleJobParms.add((Object)scheduleJobParams);
    }

    public AttrHolderList getscheduleJobParms() {
        return this.scheduleJobParms;
    }

    public IAttrHolder getJobAttributes() {
        return this.jobAttributes;
    }

    public IAttrHolder getscheduleJob() {
        return this.scheduleJob;
    }

    public String getName() {
        return this.name;
    }

    public void setJobAttributes(IAttrHolder jobAttr) {
        this.jobAttributes = jobAttr;
    }

    public String getJobNameWithoutCpu() {
        String jobName = this.scheduleJob.getAttr("job");
        String[] jobNamePartsbySpace = jobName.split("[ \t]+");
        if (jobNamePartsbySpace.length == 3) {
            return jobNamePartsbySpace[2];
        }
        String[] jobNameParts = jobName.split("#");
        String jobNameWithoutCpu = jobNameParts.length > 1 ? jobNameParts[1] : jobName;
        return jobNameWithoutCpu;
    }

    public String getCpuOfJob() {
        String jobName = this.scheduleJob.getAttr("job");
        String cpu = "";
        String[] jobNameParts = jobName.split("#");
        if (jobNameParts.length > 1) {
            cpu = jobNameParts[0];
        }
        return cpu;
    }
}

