/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class TwsCalendars {
    private final List<CtmCalendar> convertedCalendars;
    private final HashMap<String, ArrayList<String[]>> messages;
    private final Path sourceFile;
    private final String datacenter;
    private HashSet<String> convertedCalendarNames;

    public TwsCalendars(Path source, String dcName) {
        this.sourceFile = source;
        this.datacenter = dcName;
        this.messages = new HashMap();
        this.convertedCalendars = new ArrayList<CtmCalendar>();
    }

    public void convert() throws IOException {
        try (BufferedReader inputStream = Files.newBufferedReader(this.sourceFile);){
            String currLine;
            String name = null;
            CtmCalendar ctmCal = null;
            while ((currLine = inputStream.readLine()) != null) {
                String[] dates;
                if ((currLine = currLine.trim()).equalsIgnoreCase("$CALENDAR") || currLine.isEmpty()) continue;
                if (this.isCalendarDefinitionStart(currLine)) {
                    String[] lineArr = currLine.split("[ \t]+", 2);
                    name = lineArr[0];
                    ctmCal = new CtmCalendar(name, this.datacenter);
                    this.convertedCalendars.add(ctmCal);
                    if (lineArr.length > 1) {
                        ctmCal.setDescription(lineArr[1].replaceAll("^\"", "").replaceAll("\"$", ""));
                    }
                }
                if (currLine.matches("^\".+\"$")) {
                    ctmCal.setDescription(currLine.replaceAll("^\"", "").replaceAll("\"$", ""));
                }
                if (!Date.isDateLine(currLine) || ctmCal == null) continue;
                for (String dateLine : dates = currLine.split("[ \t]+")) {
                    Date date = new Date(dateLine);
                    if (date.isValidDate()) {
                        ctmCal.addDay(Integer.parseInt(date.getYear()), Integer.parseInt(date.getMonth()), Integer.parseInt(date.getDay()));
                        continue;
                    }
                    this.messages.putIfAbsent(name, new ArrayList());
                    String[] msg = new String[]{name, dateLine};
                    this.messages.get(name).add(msg);
                }
            }
        }
    }

    public void writeCalendars() throws IOException {
        if (!this.convertedCalendars.isEmpty()) {
            try (DefCalFile defcal = DefCalFile.createDefCalFile();){
                for (CtmCalendar currCal : this.convertedCalendars) {
                    defcal.write(currCal, false);
                    defcal.write(currCal, true);
                }
            }
        }
    }

    public boolean isConverted(String name) {
        if (this.convertedCalendarNames == null) {
            if (!this.convertedCalendars.isEmpty()) {
                this.convertedCalendarNames = new HashSet();
                for (CtmCalendar cal : this.convertedCalendars) {
                    this.convertedCalendarNames.add(cal.getName());
                }
            } else {
                return false;
            }
        }
        return this.convertedCalendarNames.contains(name);
    }

    boolean isCalendarDefinitionStart(String inputString) {
        return inputString != null && inputString.matches("([A-Za-z][A-Za-z0-9_-]{0,7})([\\t ]+\".*\")?");
    }

    public List<CtmCalendar> getConvertedCalendars() {
        return this.convertedCalendars;
    }

    private static class Date {
        private static final String MONTH = "\\d{2}";
        private static final String DAY = "\\d{2}";
        private static final String YEAR = "(\\d{4}|\\d{2})";
        private static final Pattern MM_DD_YYYY_PATTERN = Pattern.compile("^\\d{2}/\\d{2}/(\\d{4}|\\d{2})([ \t]+\\d{2}/\\d{2}/(\\d{4}|\\d{2}))*$");
        private static final Pattern YYYY_MM_DD_PATTERN = Pattern.compile("^(\\d{4}|\\d{2})/\\d{2}/\\d{2}([ \t]+(\\d{4}|\\d{2})/\\d{2}/\\d{2})*$");
        private final String[] dateData;
        private final boolean isMonthDayYearFormat;

        public Date(String dateData) {
            this.dateData = dateData.split("/");
            this.isMonthDayYearFormat = Date.isMonthDayYearFormat(dateData);
        }

        public String getDay() {
            if (this.isMonthDayYearFormat) {
                return this.dateData[1];
            }
            return this.dateData[2];
        }

        public String getYear() {
            String year;
            String string = year = this.isMonthDayYearFormat ? this.dateData[2] : this.dateData[0];
            if (year.length() == 2) {
                return "20" + year;
            }
            return year;
        }

        public String getMonth() {
            if (this.isMonthDayYearFormat) {
                return this.dateData[0];
            }
            return this.dateData[1];
        }

        public static boolean isYearMonthDayFormat(String dates) {
            return YYYY_MM_DD_PATTERN.matcher(dates).matches();
        }

        public static boolean isMonthDayYearFormat(String dates) {
            return MM_DD_YYYY_PATTERN.matcher(dates).matches();
        }

        public static boolean isDateLine(String dates) {
            return Date.isMonthDayYearFormat(dates) || Date.isYearMonthDayFormat(dates);
        }

        public boolean isValidDate() {
            return GlobalFunctions.isValidDate((String)String.format("%s%s%s", this.getYear(), this.getMonth(), this.getDay()), (String)"yyyyMMdd");
        }

        public String toString() {
            return String.join((CharSequence)"/", this.getYear(), this.getMonth(), this.getDay());
        }
    }
}

