/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.tws.TwsAssessmentJobTypeData;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsJobTypeRecognizer;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TwsAssessmentDataCalculator {
    private int tableCount = 0;
    private int jobCount = 0;
    private final List<TwsAssessmentJobTypeData> jobTypesDataList = new ArrayList<TwsAssessmentJobTypeData>();
    private final TwsJobTypeRecognizer recognizer = new TwsJobTypeRecognizer();
    private int notFoundJobsCount = 0;

    public void calculateEntityTypes(Map<String, TwsScheduleAttributes> schedules) {
        for (TwsScheduleAttributes twsSchedule : schedules.values()) {
            if (twsSchedule == null) continue;
            ++this.tableCount;
            HashMap<String, TwsJobAttributes> jobs = twsSchedule.getJobs();
            this.calculateJobTypes(jobs);
            this.jobCount += jobs.size();
        }
        this.jobCount -= this.notFoundJobsCount;
    }

    private void calculateJobTypes(HashMap<String, TwsJobAttributes> jobs) {
        for (TwsJobAttributes jobAttr : jobs.values()) {
            TwsAssessmentJobTypeData jobTypeData = this.recognizer.recognizeJobType(jobAttr);
            if (jobTypeData != null) {
                if (this.jobTypesDataList.contains(jobTypeData)) {
                    int indexOf = this.jobTypesDataList.indexOf(jobTypeData);
                    ++this.jobTypesDataList.get((int)indexOf).amount;
                    continue;
                }
                ++jobTypeData.amount;
                this.jobTypesDataList.add(jobTypeData);
                continue;
            }
            ++this.notFoundJobsCount;
        }
    }

    public int getTableCount() {
        return this.tableCount;
    }

    public int getJobCount() {
        return this.jobCount;
    }

    public List<TwsAssessmentJobTypeData> getJobsTypesData() {
        Comparator comparator = (jobTypeData1, jobTypeData2) -> {
            if (jobTypeData1.isSupported) {
                return -1;
            }
            return 1;
        };
        this.jobTypesDataList.sort(comparator);
        return new ArrayList<TwsAssessmentJobTypeData>(this.jobTypesDataList);
    }
}

