/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.sap.StepArgs;
import com.bmc.ctmconvert.tws.KeyValMAtcher;
import com.bmc.ctmconvert.tws.StepParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TWSSAPArgumentsParser {
    private String command;
    private Map<String, List<String>> generalArgsMap;
    private StepArgs stepArgs;
    private Map<Integer, Map<Optional<String>, Optional<String>>> stepToArgsMap = new HashMap<Integer, Map<Optional<String>, Optional<String>>>();

    public TWSSAPArgumentsParser(String command) {
        this.command = command;
        this.stepArgs = new StepArgs();
        this.generalArgsMap = this.getArgumentsMap(this.command);
    }

    private Map<String, List<String>> getArgumentsMap(String command) {
        String[] args;
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        command = Truncator.truncate('-', command);
        for (String arg : args = command.split("^-|\\s-")) {
            KeyValMAtcher matcher = KeyValMAtcher.to(arg);
            if (!matcher.find()) continue;
            String key = matcher.getKey().trim();
            String value = matcher.getValue().trim();
            if (StepParser.isStepArg(key)) {
                StepParser parser = StepParser.from(key, value);
                Integer stepNumber = parser.getStepNumber();
                Optional<String> stepKey = parser.getKey();
                Optional<String> stepValue = parser.getValue();
                if (stepNumber > 0 && stepKey.isPresent()) {
                    this.stepArgs.put(stepNumber.intValue(), stepKey.get(), stepValue);
                }
                if (this.stepToArgsMap.containsKey(stepNumber)) {
                    this.stepToArgsMap.get(stepNumber).put(stepKey, stepValue);
                    continue;
                }
                HashMap<Optional<String>, Optional<String>> valueHM = new HashMap<Optional<String>, Optional<String>>();
                valueHM.put(stepKey, stepValue);
                this.stepToArgsMap.put(stepNumber, valueHM);
                continue;
            }
            if (!ret.containsKey(key)) {
                ArrayList valueList = new ArrayList();
                ret.put(key, valueList);
            }
            ((List)ret.get(key)).add(value);
        }
        return ret;
    }

    public Optional<String> getGeneralArg(String key) {
        if (!this.generalArgsMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.generalArgsMap.get(key).get(0));
    }

    public Optional<List<String>> getGeneralArgList(String key) {
        if (!this.generalArgsMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.generalArgsMap.get(key));
    }

    public Optional<String> getStepArgs(int step, String stepArgkey) {
        return this.stepArgs.get(step, stepArgkey);
    }

    public Map<Integer, Map<Optional<String>, Optional<String>>> getStepsArgsMap() {
        HashMap<Integer, Map<Optional<String>, Optional<String>>> retVal = new HashMap<Integer, Map<Optional<String>, Optional<String>>>();
        retVal.putAll(this.stepToArgsMap);
        return retVal;
    }

    public List<Integer> getStepsNumber() {
        return this.stepArgs.getNumbers();
    }

    public static class Truncator {
        public static String truncate(char beginChar, String command) {
            int indexOfDash = command.indexOf(beginChar);
            if (indexOfDash == -1) {
                return command;
            }
            return command.substring(indexOfDash);
        }
    }
}

