/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.tws.Cpu2csv;
import com.bmc.ctmconvert.tws.Jobs;
import com.bmc.ctmconvert.tws.Resources;
import com.bmc.ctmconvert.tws.Schedule;
import com.bmc.ctmconvert.tws.Vars2csv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class TWSDataCapture {
    private String dataSourcePath = null;
    private HashMap<SOURCE_INPUT_TYPE, File> fileMap = null;
    private BaseProgressBar m_progressBar = null;
    private boolean varsCreated;

    public TWSDataCapture(String dataSourcePath, HashMap<SOURCE_INPUT_TYPE, File> fileMap, BaseProgressBar pb) {
        this.dataSourcePath = dataSourcePath;
        this.fileMap = fileMap;
        this.m_progressBar = pb;
    }

    public File createDataSource() throws ConvertorCancelClickException {
        if (this.m_progressBar != null) {
            this.m_progressBar.setProgressMax(this.fileMap.keySet().size() * 2);
        }
        int i = 0;
        try {
            for (SOURCE_INPUT_TYPE source : this.fileMap.keySet()) {
                if (this.fileMap.get((Object)source) == null) continue;
                if (this.m_progressBar != null && this.m_progressBar.getTask().isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                if (this.m_progressBar != null) {
                    this.m_progressBar.setProgressValue(++i);
                }
                this.copyToWorkArea(source);
                if (this.m_progressBar != null && this.m_progressBar.getTask().isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                if (this.m_progressBar != null) {
                    this.m_progressBar.setProgressValue(++i);
                }
                this.createCsv(source);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return null;
        }
        return new File(this.dataSourcePath + Globs.DIRSEP + "schedule.csv");
    }

    private void createCsv(SOURCE_INPUT_TYPE source) throws IOException {
        switch (source.ordinal()) {
            case 2: 
            case 6: 
            case 7: {
                if (this.varsCreated) break;
                this.varsCreated = true;
                Vars2csv vars = new Vars2csv(this.fileMap.get((Object)SOURCE_INPUT_TYPE.VARIABLE_TABLE_FILE), this.fileMap.get((Object)SOURCE_INPUT_TYPE.VARIABLES_FILE), this.fileMap.get((Object)SOURCE_INPUT_TYPE.AGENT_PARMS_DIR), new File(this.dataSourcePath + Globs.DIRSEP + "variables.csv"));
                vars.createCsv();
                break;
            }
            case 3: {
                Cpu2csv cpus = new Cpu2csv(this.fileMap.get((Object)SOURCE_INPUT_TYPE.CPU_FILE), new File(this.dataSourcePath + Globs.DIRSEP + "cpus.csv"));
                cpus.writeToCSV();
                break;
            }
            case 1: {
                File jobsInputFile = this.fileMap.get((Object)SOURCE_INPUT_TYPE.JOBS_FILE).getAbsoluteFile();
                File jobsCsvfile = new File(this.dataSourcePath + "jobs.csv");
                if (!jobsInputFile.exists()) break;
                Jobs jobs = new Jobs(new FileInputStream(jobsInputFile), new FileOutputStream(jobsCsvfile));
                jobs.writeToCSV();
                break;
            }
            case 4: {
                Resources res = new Resources(this.fileMap.get((Object)SOURCE_INPUT_TYPE.RESOURCE_FILE).getAbsoluteFile(), this.dataSourcePath);
                res.writeToCSV();
                break;
            }
            case 0: {
                File scheduleInputFile = this.fileMap.get((Object)SOURCE_INPUT_TYPE.SCHEDULE_FILE).getAbsoluteFile();
                if (!scheduleInputFile.exists()) break;
                File scheduleCsvfile = new File(this.dataSourcePath + "schedule.csv");
                File scheduleParamsCsvFile = new File(this.dataSourcePath + "scheduleParams.csv");
                File jobsStatementsCsvFile = new File(this.dataSourcePath + "scheduleJobs.csv");
                File jobsStatementsParamsCsvFile = new File(this.dataSourcePath + "scheduleJobsParams.csv");
                Schedule sched = new Schedule(new FileInputStream(scheduleInputFile), new FileOutputStream(scheduleCsvfile), new FileOutputStream(scheduleParamsCsvFile), new FileOutputStream(jobsStatementsCsvFile), new FileOutputStream(jobsStatementsParamsCsvFile));
                sched.writeToCSV();
                break;
            }
        }
    }

    private void copyToWorkArea(SOURCE_INPUT_TYPE source) throws IOException {
        File target = null;
        switch (source.ordinal()) {
            case 6: {
                target = new File(this.dataSourcePath + "ag_parm");
                break;
            }
            case 5: {
                target = new File(this.dataSourcePath + "calendars.txt");
                break;
            }
            case 3: {
                target = new File(this.dataSourcePath + "cpus.txt");
                break;
            }
            case 1: {
                target = new File(this.dataSourcePath + "jobs.txt");
                break;
            }
            case 4: {
                target = new File(this.dataSourcePath + "resource.txt");
                break;
            }
            case 0: {
                target = new File(this.dataSourcePath + "schedule.txt");
                break;
            }
            case 7: {
                target = new File(this.dataSourcePath + "var_tables.txt");
                break;
            }
            case 2: {
                target = new File(this.dataSourcePath + "variables.txt");
                break;
            }
        }
        GlobalFunctions.copy((File)this.fileMap.get((Object)source), (File)target);
    }

    public static enum SOURCE_INPUT_TYPE {
        SCHEDULE_FILE,
        JOBS_FILE,
        VARIABLES_FILE,
        CPU_FILE,
        RESOURCE_FILE,
        CALENDARS_FILE,
        AGENT_PARMS_DIR,
        VARIABLE_TABLE_FILE;

    }
}

