/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.tws.KeyValMAtcher;
import java.util.Optional;

public class StepParser {
    private String key;
    private String stepKey;
    private String stepValue;

    public StepParser(String key, String value) {
        this.key = key;
        KeyValMAtcher mathcher = KeyValMAtcher.to(value, "=");
        if (mathcher.find()) {
            this.stepKey = mathcher.getKey();
            this.stepValue = mathcher.getValue();
        } else {
            this.stepKey = value;
            this.stepValue = "";
        }
    }

    public static boolean isStepArg(String key) {
        return key.matches("^s\\d+$");
    }

    public static StepParser from(String key, String value) {
        StepParser ret = new StepParser(key, value);
        return ret;
    }

    public int getStepNumber() {
        String stepNumber = this.removeSChar(this.key);
        Integer ret = 0;
        try {
            ret = Integer.parseInt(stepNumber);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return ret;
    }

    private String removeSChar(String key2) {
        return key2.substring(1);
    }

    public Optional<String> getKey() {
        return this.getValueOrEmpty(this.stepKey);
    }

    private Optional<String> getValueOrEmpty(String stepKey2) {
        if (stepKey2 == null) {
            return Optional.empty();
        }
        return Optional.of(stepKey2);
    }

    public Optional<String> getValue() {
        return this.getValueOrEmpty(this.stepValue);
    }
}

