/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class Schedule {
    static final char MARKSIGN = '#';
    static final char STARSIGN = '*';
    static final char COMMA = ',';
    private List<String> scheduleParameters;
    private List<String> jobParameters;
    private TWSDefinition scheduleDefinition;
    private TWSDefinition jobDefinition;
    private CsvWriter scheduleCsv;
    private CsvWriter scheduleParamsCsv;
    private CsvWriter jobsStatementsCsv;
    private CsvWriter jobsStatementsParamsCsv;
    private List<TWSDefinition> scheduleJobs;
    private boolean inParam = false;
    private String nextParam = "";
    private boolean waitingForNextQuotes = false;
    private StringBuilder nextParamValue = null;
    private boolean inParenthesis;
    private InputStream scheduleInputStream;
    private OutputStream scheduleCsvStream;
    private OutputStream scheduleParamsCsvStream;
    private OutputStream jobsStatementsCsvStream;
    private OutputStream jobsStatementsParamsCsvStream;

    public Schedule(InputStream scheduleInputStream, OutputStream scheduleCsvStream, OutputStream scheduleParamsCsvStream, OutputStream jobsStatementsCsvStream, OutputStream jobsStatementsParamsCsvStream) {
        this.scheduleInputStream = scheduleInputStream;
        this.scheduleCsvStream = scheduleCsvStream;
        this.scheduleParamsCsvStream = scheduleParamsCsvStream;
        this.jobsStatementsCsvStream = jobsStatementsCsvStream;
        this.jobsStatementsParamsCsvStream = jobsStatementsParamsCsvStream;
        this.jobDefinition = new TWSDefinition(this, CaptureType.JOB);
        this.scheduleDefinition = new TWSDefinition(this, CaptureType.SCHEDULE);
        this.scheduleParameters = new LinkedList<String>();
        this.jobParameters = new LinkedList<String>();
        this.scheduleJobs = new LinkedList<TWSDefinition>();
        this.setScheudleAndJobParameters();
    }

    private void setScheudleAndJobParameters() {
        this.setScheduleParam();
        this.setJobParam();
    }

    private void setJobParam() {
        this.jobParameters.add("outcond");
        this.jobParameters.add("outcond".toUpperCase());
        this.jobParameters.add("at");
        this.jobParameters.add("at".toUpperCase());
        this.jobParameters.add("schedtime");
        this.jobParameters.add("schedtime".toUpperCase());
        this.jobParameters.add("until");
        this.jobParameters.add("until".toUpperCase());
        this.jobParameters.add("onuntil");
        this.jobParameters.add("onuntil".toUpperCase());
        this.jobParameters.add("deadline");
        this.jobParameters.add("deadline".toUpperCase());
        this.jobParameters.add("maxdur");
        this.jobParameters.add("maxdur".toUpperCase());
        this.jobParameters.add("onmaxdur");
        this.jobParameters.add("onmaxdur".toUpperCase());
        this.jobParameters.add("mindur");
        this.jobParameters.add("mindur".toUpperCase());
        this.jobParameters.add("every");
        this.jobParameters.add("every".toUpperCase());
        this.jobParameters.add("follows");
        this.jobParameters.add("follows".toUpperCase());
        this.jobParameters.add("confirmed");
        this.jobParameters.add("confirmed".toUpperCase());
        this.jobParameters.add("critical");
        this.jobParameters.add("critical".toUpperCase());
        this.jobParameters.add("keyjob");
        this.jobParameters.add("keyjob".toUpperCase());
        this.jobParameters.add("needs");
        this.jobParameters.add("needs".toUpperCase());
        this.jobParameters.add("opens");
        this.jobParameters.add("opens".toUpperCase());
        this.jobParameters.add("priority");
        this.jobParameters.add("priority".toUpperCase());
        this.jobParameters.add("prompt");
        this.jobParameters.add("prompt".toUpperCase());
        this.jobParameters.add("docommand");
        this.jobParameters.add("docommand".toUpperCase());
        this.jobParameters.add("scriptname");
        this.jobParameters.add("scriptname".toUpperCase());
        this.jobParameters.add("recovery");
        this.jobParameters.add("recovery".toUpperCase());
        this.jobParameters.add("streamlogon");
        this.jobParameters.add("streamlogon".toUpperCase());
        this.jobParameters.add("after");
        this.jobParameters.add("after".toUpperCase());
        this.jobParameters.add("description");
        this.jobParameters.add("description".toUpperCase());
        this.jobParameters.add("nop");
        this.jobParameters.add("nop".toUpperCase());
        this.jobParameters.add("rccondsucc");
        this.jobParameters.add("rccondsucc".toUpperCase());
        this.jobParameters.add("statisticstype");
        this.jobParameters.add("statisticstype".toUpperCase());
        this.jobParameters.add("tasktype");
        this.jobParameters.add("tasktype".toUpperCase());
        this.jobParameters.add("join");
        this.jobParameters.add("join".toUpperCase());
        this.jobParameters.add("recovery");
        this.jobParameters.add("recovery".toUpperCase());
        this.jobParameters.add("abendprompt");
        this.jobParameters.add("abendprompt".toUpperCase());
    }

    private void setScheduleParam() {
        this.scheduleParameters.add("schedule");
        this.scheduleParameters.add("validfrom");
        this.scheduleParameters.add("validfrom".toUpperCase());
        this.scheduleParameters.add("timezone");
        this.scheduleParameters.add("timezone".toUpperCase());
        this.scheduleParameters.add("tz");
        this.scheduleParameters.add("tz".toUpperCase());
        this.scheduleParameters.add("description");
        this.scheduleParameters.add("description".toUpperCase());
        this.scheduleParameters.add("draft");
        this.scheduleParameters.add("draft".toUpperCase());
        this.scheduleParameters.add("vartable");
        this.scheduleParameters.add("vartable".toUpperCase());
        this.scheduleParameters.add("freedays");
        this.scheduleParameters.add("freedays".toUpperCase());
        this.scheduleParameters.add("on");
        this.scheduleParameters.add("on".toUpperCase());
        this.scheduleParameters.add("except");
        this.scheduleParameters.add("except".toUpperCase());
        this.scheduleParameters.add("at");
        this.scheduleParameters.add("at".toUpperCase());
        this.scheduleParameters.add("schedtime");
        this.scheduleParameters.add("schedtime".toUpperCase());
        this.scheduleParameters.add("until");
        this.scheduleParameters.add("until".toUpperCase());
        this.scheduleParameters.add("onuntil");
        this.scheduleParameters.add("onuntil".toUpperCase());
        this.scheduleParameters.add("deadline");
        this.scheduleParameters.add("deadline".toUpperCase());
        this.scheduleParameters.add("carryforward");
        this.scheduleParameters.add("carryforward".toUpperCase());
        this.scheduleParameters.add("matching");
        this.scheduleParameters.add("matching".toUpperCase());
        this.scheduleParameters.add("follows");
        this.scheduleParameters.add("follows".toUpperCase());
        this.scheduleParameters.add("keysched");
        this.scheduleParameters.add("keysched".toUpperCase());
        this.scheduleParameters.add("limit");
        this.scheduleParameters.add("limit".toUpperCase());
        this.scheduleParameters.add("needs");
        this.scheduleParameters.add("needs".toUpperCase());
        this.scheduleParameters.add("opens");
        this.scheduleParameters.add("opens".toUpperCase());
        this.scheduleParameters.add("priority");
        this.scheduleParameters.add("priority".toUpperCase());
        this.scheduleParameters.add("prompt");
        this.scheduleParameters.add("prompt".toUpperCase());
        this.scheduleParameters.add(":");
        this.scheduleParameters.add(":".toUpperCase());
        this.scheduleParameters.add("join");
        this.scheduleParameters.add("join".toUpperCase());
        this.scheduleParameters.add("endjoin");
        this.scheduleParameters.add("endjoin".toUpperCase());
        this.scheduleParameters.add("jsuntil");
        this.scheduleParameters.add("jsuntil".toUpperCase());
        this.scheduleParameters.add("maxdur");
        this.scheduleParameters.add("maxdur".toUpperCase());
        this.scheduleParameters.add("mindur");
        this.scheduleParameters.add("mindur".toUpperCase());
        this.scheduleParameters.add("nop");
        this.scheduleParameters.add("nop".toUpperCase());
        this.scheduleParameters.add("onoverlap");
        this.scheduleParameters.add("onoverlap".toUpperCase());
        this.scheduleParameters.add("outcond");
        this.scheduleParameters.add("outcond".toUpperCase());
        this.scheduleParameters.add("startcond");
        this.scheduleParameters.add("startcond".toUpperCase());
        this.scheduleParameters.add("statisticstype");
        this.scheduleParameters.add("statisticstype".toUpperCase());
    }

    public String toString() {
        Object tmp = "";
        List<String> keys = this.scheduleDefinition.getKeys();
        for (String key : keys) {
            String value = this.scheduleDefinition.get(key);
            tmp = (String)tmp + key + "=" + value + "\n";
        }
        return tmp;
    }

    public String getValue(String attr) {
        return this.scheduleDefinition.get(attr);
    }

    public String getValue(int indx) {
        return this.scheduleDefinition.get(indx);
    }

    public List<String> getDefinitionParameters() {
        return this.scheduleDefinition.getKeys();
    }

    private boolean isItAparam(String inParam, CaptureType capture) {
        if (capture.equals((Object)CaptureType.SCHEDULE)) {
            if (this.inParam && !this.inParenthesis && this.withinField() && (inParam.equalsIgnoreCase("at") || inParam.equalsIgnoreCase("until"))) {
                return true;
            }
            if (this.inParam && this.nextParam.equalsIgnoreCase("on") ? inParam.equalsIgnoreCase("validfrom") || inParam.equalsIgnoreCase("description") || inParam.equalsIgnoreCase("vartable") || inParam.equalsIgnoreCase("at") || inParam.equalsIgnoreCase("schedtime") || inParam.equalsIgnoreCase("until") || inParam.equalsIgnoreCase("deadline") : this.inParam && this.nextParam.equalsIgnoreCase("except") && (inParam.equalsIgnoreCase("validfrom") || inParam.equalsIgnoreCase("description") || inParam.equalsIgnoreCase("at") || inParam.equalsIgnoreCase("schedtime"))) {
                return false;
            }
            if (this.scheduleParameters.contains(inParam)) {
                return true;
            }
        } else if (this.jobParameters.contains(inParam)) {
            return true;
        }
        return false;
    }

    private void updateCurrentParameter(TWSDefinition def) {
        if (this.inParam) {
            def.put(this.nextParam, this.nextParamValue.toString());
            this.inParam = false;
            this.nextParamValue.delete(0, this.nextParamValue.length());
        }
    }

    private String handleDescription(String line) {
        int index = this.nextParam.equals("description") ? line.indexOf("description") : line.indexOf("description".toUpperCase());
        int firstQuotes = line.indexOf(34, index);
        if (firstQuotes >= 0) {
            int secondQuotes = line.indexOf(34, firstQuotes + 1);
            if (secondQuotes > 0) {
                this.nextParamValue.append(line.substring(firstQuotes, secondQuotes + 1));
                return line.substring(secondQuotes + 1);
            }
            this.nextParamValue.append(line.substring(firstQuotes));
            this.waitingForNextQuotes = true;
            return "";
        }
        return "";
    }

    private boolean withinField() {
        return this.nextParam.equalsIgnoreCase("on") || this.nextParam.equalsIgnoreCase("except");
    }

    private void appendValue(String val) {
        if (this.nextParamValue.length() > 0) {
            this.nextParamValue.append(" ");
        }
        this.nextParamValue.append(val);
    }

    private int handleDoubleQuoteField(String[] params, int fromIndex) {
        boolean firstQuote = true;
        for (int nextIndex = fromIndex; nextIndex < params.length; ++nextIndex) {
            this.appendValue(params[nextIndex]);
            int fromChar = params[nextIndex].indexOf(34);
            if (fromChar >= 0 && firstQuote) {
                if (params[nextIndex].indexOf(34, fromChar + 1) >= 0) {
                    return nextIndex + 1;
                }
                firstQuote = false;
                continue;
            }
            if (fromChar < 0 || firstQuote) continue;
            return nextIndex + 1;
        }
        return -1;
    }

    private int runcycleName(String[] params, int index) {
        if (params.length > index && params[index + 1].equalsIgnoreCase("runcycle")) {
            this.appendValue(params[index + 1]);
            if (params.length > index + 1) {
                this.appendValue(params[index + 2]);
            }
            return index + 2;
        }
        return index;
    }

    public void lineParameters(String line, CaptureType capture) {
        int paramArrayIndex = 0;
        boolean asJob = false;
        boolean multiLineValue = false;
        if (this.waitingForNextQuotes) {
            int index = line.indexOf("\"");
            this.nextParamValue.append('\n');
            if (index >= 0) {
                this.nextParamValue.append(line.substring(0, index + 1));
                line = line.substring(index + 2);
                this.waitingForNextQuotes = false;
                if (line.isEmpty()) {
                    return;
                }
            } else {
                this.nextParamValue.append(line.substring(0));
                return;
            }
        }
        if (capture == CaptureType.SCHEDULE) {
            for (String tmp : this.scheduleParameters) {
                line = line.replaceAll(tmp + ":\\s*$", tmp + " :");
            }
        }
        String[] params = line.split("[\\t ]+");
        if (capture.equals((Object)CaptureType.JOB)) {
            boolean bl = this.nextParamValue.length() > 0 ? this.nextParamValue.charAt(this.nextParamValue.length() - 1) == ',' : (multiLineValue = false);
            if (!multiLineValue && params[0].startsWith(",")) {
                multiLineValue = true;
                if (params[0].equals(",") && params.length > 1) {
                    ++paramArrayIndex;
                    params[1] = "," + params[1];
                }
            }
            if (params.length > 1 && params[1].equalsIgnoreCase("as")) {
                asJob = true;
                params[0] = line;
            }
        }
        if (capture.equals((Object)CaptureType.JOB) && (!this.isItAparam(params[0].toLowerCase(), capture) && !multiLineValue || asJob)) {
            this.updateCurrentParameter(this.jobDefinition);
            if (!this.jobDefinition.isEmpty()) {
                this.scheduleJobs.add(this.jobDefinition);
                this.jobDefinition = new TWSDefinition(this, CaptureType.JOB);
            }
            if (!params[0].contains("#")) {
                StringBuilder sb = new StringBuilder();
                String cpuName = this.scheduleDefinition.get("ID").substring(0, this.scheduleDefinition.get("ID").indexOf("#"));
                sb.append(cpuName);
                sb.append("#");
                String jobname = params[0];
                sb.append(jobname);
                params[0] = sb.toString();
            }
            this.jobDefinition.put("ID", this.scheduleDefinition.get("ID") + " " + params[0]);
            this.jobDefinition.put("job", params[0]);
            ++paramArrayIndex;
        }
        while (paramArrayIndex < params.length) {
            if (!params[paramArrayIndex].trim().isEmpty() && !this.inParam) {
                if (!this.isItAparam(params[paramArrayIndex].toLowerCase(), capture)) {
                    return;
                }
                this.inParam = true;
                this.nextParam = params[paramArrayIndex];
                if (this.nextParam.equalsIgnoreCase("description")) {
                    if ((line = this.handleDescription(line)).isEmpty()) {
                        return;
                    }
                    paramArrayIndex = 0;
                    params = line.split("[\\t ]");
                    continue;
                }
                if (this.nextParam.equalsIgnoreCase("on") || this.nextParam.equalsIgnoreCase("except")) {
                    paramArrayIndex = this.runcycleName(params, paramArrayIndex);
                }
                ++paramArrayIndex;
                continue;
            }
            if (this.inParam && this.isItAparam(params[paramArrayIndex].toLowerCase(), capture)) {
                if (capture.equals((Object)CaptureType.SCHEDULE)) {
                    this.scheduleDefinition.put(this.nextParam, this.nextParamValue.toString());
                } else {
                    if (this.nextParam.equalsIgnoreCase("docommand") || this.nextParam.equals("scriptname")) {
                        this.nextParam = "scriptname/docommand";
                    }
                    this.jobDefinition.put(this.nextParam, this.nextParamValue.toString());
                }
                this.nextParamValue.delete(0, this.nextParamValue.length());
                this.nextParam = params[paramArrayIndex];
                if (this.nextParam.equalsIgnoreCase("on") || this.nextParam.equalsIgnoreCase("except")) {
                    paramArrayIndex = this.runcycleName(params, paramArrayIndex);
                } else if (this.nextParam.equalsIgnoreCase("description")) {
                    if ((paramArrayIndex = this.handleDoubleQuoteField(params, paramArrayIndex + 1)) >= 0) continue;
                    this.waitingForNextQuotes = true;
                    return;
                }
            } else {
                if (this.inParam && params[paramArrayIndex].equalsIgnoreCase("description") && this.withinField()) {
                    if ((paramArrayIndex = this.handleDoubleQuoteField(params, paramArrayIndex)) >= 0) continue;
                    this.waitingForNextQuotes = true;
                    return;
                }
                if (this.withinField() && params[paramArrayIndex].equalsIgnoreCase("(")) {
                    this.inParenthesis = true;
                }
                if (this.withinField() && params[paramArrayIndex].equalsIgnoreCase(")")) {
                    this.inParenthesis = false;
                }
                this.appendValue(params[paramArrayIndex]);
            }
            ++paramArrayIndex;
        }
    }

    private void endJobStream() throws IOException {
        this.inParam = false;
        this.nextParamValue.delete(0, this.nextParamValue.length());
        this.scheduleCsv.writeRecord(this.scheduleDefinition.getFixedParametersValues());
        String[][] variableParams = this.scheduleDefinition.getVariableParametersValues();
        if (variableParams != null) {
            for (int i = 0; i < variableParams.length; ++i) {
                this.scheduleParamsCsv.writeRecord(variableParams[i]);
            }
        }
        int numberJobs = this.scheduleJobs.size();
        for (int i = 0; i < numberJobs; ++i) {
            TWSDefinition nextJob = this.scheduleJobs.get(i);
            this.jobsStatementsCsv.writeRecord(nextJob.getFixedParametersValues());
            variableParams = nextJob.getVariableParametersValues();
            if (variableParams == null) continue;
            for (int j = 0; j < variableParams.length; ++j) {
                this.jobsStatementsParamsCsv.writeRecord(variableParams[j]);
            }
        }
        this.scheduleJobs.clear();
        this.scheduleDefinition.clean();
        this.jobDefinition.clean();
    }

    private void getJobsStatements(BufferedReader in) {
        try {
            String line;
            String nextLine = null;
            while ((line = nextLine) != null || (line = in.readLine()) != null) {
                nextLine = null;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '*') continue;
                if (line.toUpperCase().matches(".*\\s+END$")) {
                    line = line.substring(0, line.toUpperCase().lastIndexOf("END"));
                    nextLine = "END";
                }
                if (line.equalsIgnoreCase("end")) {
                    this.updateCurrentParameter(this.jobDefinition);
                    if (!this.jobDefinition.isEmpty()) {
                        this.scheduleJobs.add(this.jobDefinition);
                        this.jobDefinition = new TWSDefinition(this, CaptureType.JOB);
                    }
                    this.endJobStream();
                    break;
                }
                if (line.startsWith("join".toUpperCase())) {
                    StringBuilder contentBlock = this.handleJoinBlock(line, in);
                    this.jobDefinition.put("join", contentBlock.toString());
                    continue;
                }
                this.lineParameters(line, CaptureType.JOB);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private StringBuilder handleJoinBlock(String joinStatement, BufferedReader in) throws IOException {
        String line = null;
        StringBuilder contentBlock = new StringBuilder();
        contentBlock.append(joinStatement);
        while ((line = in.readLine()) != null && !line.equalsIgnoreCase("endjoin")) {
            contentBlock.append(line);
        }
        return contentBlock;
    }

    void getRestScheduleParams(BufferedReader in, String inLine) {
        String line = null;
        String[] params = inLine.split("[\\t ]");
        this.nextParamValue.delete(0, this.nextParamValue.length());
        this.scheduleDefinition.put("ID", params[1]);
        this.scheduleDefinition.put("schedule", params[1]);
        if (params.length > 2) {
            line = inLine.substring(inLine.indexOf(params[1]) + params[1].length()).trim();
            this.lineParameters(line, CaptureType.SCHEDULE);
        }
        if (inLine.trim().endsWith(":")) {
            if (this.nextParamValue.length() > 0 && this.nextParamValue.charAt(this.nextParamValue.length() - 1) == ':') {
                this.nextParamValue.deleteCharAt(this.nextParamValue.length() - 1);
            }
            this.updateCurrentParameter(this.scheduleDefinition);
            this.getJobsStatements(in);
        } else {
            try {
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '*') continue;
                    if (line.equalsIgnoreCase("end")) {
                        this.updateCurrentParameter(this.scheduleDefinition);
                        this.endJobStream();
                        break;
                    }
                    if (line.endsWith(":")) {
                        if (line.length() > 1) {
                            line = line.replaceAll(":$", "");
                        }
                        this.lineParameters(line, CaptureType.SCHEDULE);
                        this.updateCurrentParameter(this.scheduleDefinition);
                        this.getJobsStatements(in);
                        break;
                    }
                    if (line.startsWith("join".toUpperCase())) {
                        StringBuilder contentBlock = this.handleJoinBlock(line, in);
                        this.scheduleDefinition.put("join", contentBlock.toString());
                        continue;
                    }
                    this.lineParameters(line, CaptureType.SCHEDULE);
                }
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }

    public void writeToCSV() {
        this.nextParamValue = new StringBuilder();
        this.scheduleCsv = new CsvWriter((Writer)new OutputStreamWriter(this.scheduleCsvStream), ',');
        this.scheduleParamsCsv = new CsvWriter((Writer)new OutputStreamWriter(this.scheduleParamsCsvStream), ',');
        this.jobsStatementsCsv = new CsvWriter((Writer)new OutputStreamWriter(this.jobsStatementsCsvStream), ',');
        this.jobsStatementsParamsCsv = new CsvWriter((Writer)new OutputStreamWriter(this.jobsStatementsParamsCsvStream), ',');
        try {
            String line;
            this.scheduleCsv.writeRecord(parameters.scheduleCsvHeader);
            this.scheduleParamsCsv.writeRecord(parameters.scheduleParamsCsvHeader);
            this.jobsStatementsCsv.writeRecord(parameters.jobCsvHeader);
            this.jobsStatementsParamsCsv.writeRecord(parameters.scheduleParamsCsvHeader);
            BufferedReader input = new BufferedReader(new InputStreamReader(this.scheduleInputStream));
            while ((line = input.readLine()) != null) {
                String[] params;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '*' || !(params = line.split("[ \\t]+", 3))[0].equalsIgnoreCase("schedule") || params.length < 2) continue;
                this.getRestScheduleParams(input, line);
            }
            input.close();
            this.scheduleCsv.close();
            this.scheduleParamsCsv.close();
            this.jobsStatementsCsv.close();
            this.jobsStatementsParamsCsv.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public class TWSDefinition {
        private List<String> parameters;
        private List<String> values = new LinkedList<String>();
        private String[] fixedParameters;
        private String[] variableParameters;
        private String[] constantParameters;

        public TWSDefinition(Schedule this$0, CaptureType capture) {
            this.parameters = new LinkedList<String>();
            if (capture.equals((Object)CaptureType.SCHEDULE)) {
                this.fixedParameters = com.bmc.ctmconvert.tws.Schedule$parameters.scheduleFixedParams;
                this.variableParameters = com.bmc.ctmconvert.tws.Schedule$parameters.scheduleVariableParams;
                this.constantParameters = com.bmc.ctmconvert.tws.Schedule$parameters.scheduleContsantParams;
            } else {
                this.fixedParameters = com.bmc.ctmconvert.tws.Schedule$parameters.jobFixedParams;
                this.variableParameters = com.bmc.ctmconvert.tws.Schedule$parameters.jobVariableParams;
                this.constantParameters = com.bmc.ctmconvert.tws.Schedule$parameters.jobContsantsParams;
            }
        }

        private boolean isConstantParameter(String param) {
            for (int i = 0; i < this.constantParameters.length; ++i) {
                if (!param.equalsIgnoreCase(this.constantParameters[i])) continue;
                return true;
            }
            return false;
        }

        public void put(String name, String value) {
            this.parameters.add(name);
            if (this.isConstantParameter(name)) {
                this.values.add("Y");
            } else {
                this.values.add(value);
            }
        }

        public String get(String name) {
            if (this.parameters.isEmpty()) {
                return null;
            }
            int length = this.parameters.size();
            for (int i = 0; i < length; ++i) {
                if (!this.parameters.get(i).equals(name)) continue;
                return this.values.get(i);
            }
            return null;
        }

        public String get(int index) {
            if (this.parameters.isEmpty()) {
                return null;
            }
            if (index < 0 || index >= this.parameters.size()) {
                return null;
            }
            return this.values.get(index);
        }

        public void clean() {
            this.values.clear();
            this.parameters.clear();
        }

        public List<String> getKeys() {
            return this.parameters;
        }

        public List<String> getValues() {
            return this.values;
        }

        private String paramValue(String param) {
            int numberParameters = this.parameters.size();
            for (int i = 0; i < numberParameters; ++i) {
                if (!param.equalsIgnoreCase(this.parameters.get(i))) continue;
                return this.values.get(i);
            }
            return null;
        }

        public String[] getFixedParametersValues() {
            int j = 0;
            String[] retRecord = new String[this.fixedParameters.length];
            for (int i = 0; i < this.fixedParameters.length; ++i) {
                String value = this.paramValue(this.fixedParameters[i]);
                if (this.fixedParameters[i].equals("tz")) {
                    if (value == null) continue;
                    --j;
                }
                if (value != null) {
                    if (j <= 1) {
                        value = value.toUpperCase();
                    }
                    retRecord[j++] = value;
                    continue;
                }
                retRecord[j++] = "";
            }
            return retRecord;
        }

        private boolean isVariableParameter(String param) {
            for (int i = 0; i < this.variableParameters.length; ++i) {
                if (!param.equalsIgnoreCase(this.variableParameters[i])) continue;
                return true;
            }
            return false;
        }

        public String[][] getVariableParametersValues() {
            int numOccurences = 0;
            int numberParameters = this.parameters.size();
            for (int i = 0; i < this.variableParameters.length; ++i) {
                for (int j = 0; j < numberParameters; ++j) {
                    if (!this.variableParameters[i].equalsIgnoreCase(this.parameters.get(j))) continue;
                    ++numOccurences;
                }
            }
            if (numOccurences > 0) {
                int j = 0;
                String[][] retRecord = new String[numOccurences][3];
                for (int i = 0; i < numberParameters; ++i) {
                    if (!this.isVariableParameter(this.parameters.get(i))) continue;
                    retRecord[j][0] = this.values.get(0).toUpperCase();
                    retRecord[j][1] = this.parameters.get(i);
                    retRecord[j][2] = this.getFixedValueForFollowsField(this.values.get(i), this.parameters.get(i));
                    ++j;
                }
                return retRecord;
            }
            return null;
        }

        private String getFixedValueForFollowsField(String value, String parameter) {
            String retVal = value;
            if (parameter != null && parameter.equalsIgnoreCase("FOLLOWS") && value != null) {
                retVal = value.toUpperCase();
            }
            return retVal;
        }

        public boolean isEmpty() {
            return this.parameters.isEmpty();
        }
    }

    private static enum CaptureType {
        SCHEDULE,
        JOB;

    }

    static class parameters {
        static final String SCHEDULE = "schedule";
        static final String VALIDFROM = "validfrom";
        static final String TIMEZONE = "timezone";
        static final String TZ = "tz";
        static final String DESCRIPTION = "description";
        static final String DRAFT = "draft";
        static final String VARTABLE = "vartable";
        static final String FREEDAYS = "freedays";
        static final String ON = "on";
        static final String EXCEPT = "except";
        static final String AT = "at";
        static final String SCHEDTIME = "schedtime";
        static final String UNTIL = "until";
        static final String ONUNTIL = "onuntil";
        static final String DEADLINE = "deadline";
        static final String CARRYFORWARD = "carryforward";
        static final String MATCHING = "matching";
        static final String FOLLOWS = "follows";
        static final String KEYSCHED = "keysched";
        static final String LIMIT = "limit";
        static final String NEEDS = "needs";
        static final String OPENS = "opens";
        static final String PRIORITY = "priority";
        static final String PROMPT = "prompt";
        static final String JOBSSTARTS = ":";
        static final String END = "end";
        static final String EVERY = "every";
        static final String CONFIRMED = "confirmed";
        static final String CRITICAL = "critical";
        static final String KEYJOB = "keyjob";
        static final String JOB = "job";
        static final String SCRIPTNAME = "scriptname";
        static final String DOCOMMAND = "docommand";
        static final String STREAMLOGON = "streamlogon";
        static final String RECOVERY = "recovery";
        static final String AFTER = "after";
        static final String ID = "ID";
        static final String JOIN = "join";
        static final String ENDJOIN = "endjoin";
        static final String JSUNTIL = "jsuntil";
        static final String MAXDUR = "maxdur";
        static final String ONMAXDUR = "onmaxdur";
        static final String MINDUR = "mindur";
        static final String NOP = "nop";
        static final String ONOVERLAP = "onoverlap";
        static final String OUTCOND = "outcond";
        static final String STARTCOND = "startcond";
        static final String STATISTICSTYPE = "statisticstype";
        static final String TASK_TYPE = "tasktype";
        static final String RCCONDSUCC = "rccondsucc";
        static final String ABENDPROMPT = "abendprompt";
        static final String[] scheduleCsvHeader = new String[]{"ID", "schedule", "validfrom", "timezone", "description", "draft", "vartable", "freedays", "at", "schedtime", "until", "onuntil", "deadline", "carryforward", "keysched", "limit", "priority", "jsuntil", "maxdur", "mindur", "nop", "onoverlap", "outcond", "startcond", "statisticstype", "join"};
        static final String[] scheduleParamsCsvHeader = new String[]{"ID", "PARAMETER", "VALUE"};
        static final String[] scheduleFixedParams = new String[]{"ID", "schedule", "validfrom", "timezone", "tz", "description", "draft", "vartable", "freedays", "at", "schedtime", "until", "onuntil", "deadline", "carryforward", "keysched", "limit", "priority", "jsuntil", "maxdur", "mindur", "nop", "onoverlap", "outcond", "startcond", "statisticstype", "join"};
        static final String[] scheduleVariableParams = new String[]{"on", "except", "matching", "follows", "needs", "opens", "prompt"};
        static final String[] scheduleContsantParams = new String[]{"draft", "carryforward", "keysched"};
        static final String[] jobCsvHeader = new String[]{"ID", "job", "until", "onuntil", "every", "confirmed", "critical", "keyjob", "priority", "join", "outcond", "statisticstype", "maxdur", "onmaxdur", "mindur", "nop", "prompt"};
        static final String[] jobFixedParams = jobCsvHeader;
        static final String[] jobVariableParams = new String[]{"at", "schedtime", "deadline", "follows", "needs", "opens", "prompt", "description", "recovery", "streamlogon", "scriptname/docommand"};
        static final String[] jobContsantsParams = new String[]{"confirmed", "critical", "keyjob", "nop", "statisticstype"};

        parameters() {
        }
    }
}

