/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tws.TwsJob;
import java.util.LinkedHashMap;

public class OS400Handler {
    public static boolean isOS400(IAttrHolder jobAttributes) {
        String taskType = jobAttributes.getAttr("tasktype");
        String command = jobAttributes.getAttr("scriptname/docommand");
        return taskType.equalsIgnoreCase("other") && (command.startsWith("docommand") || command.startsWith("submit"));
    }

    public static String getOS400Owner(String user, String jobStreamLog) {
        if (user == null || user.isEmpty()) {
            user = jobStreamLog;
        }
        if (user.length() > 10) {
            user = user.substring(0, 10);
        }
        return user;
    }

    public static String getOs400JobName(String jobname, String jobOriginalName) {
        if (jobname == null || jobname.isEmpty()) {
            jobname = jobOriginalName;
        }
        if (jobname.length() > 10) {
            jobname = jobname.substring(0, 10);
        }
        return jobname;
    }

    public static void setOS400DefaultAttribute(TwsJob twsJob) {
        twsJob.setOptionalAtrribute("APPL_FORM", "OS/400 Full");
        twsJob.setOptionalAtrribute("APPL_TYPE", "OS400");
        twsJob.setOptionalAtrribute("APPL_VER", "*ALL");
        twsJob.setOptionalAtrribute("CM_VER", "7.0.01");
    }

    public static void setOS400AutoeditVariables(String cmdline, String objtyp, String owner, String jobName, String memName, String memlib, LinkedHashMap<String, String> autoedits) {
        autoedits.put("%%OS400-JOB_OWNER", owner);
        autoedits.put("%%OS400-JOB_NAME", jobName);
        autoedits.put("%%OS400-MEM_LIB", memlib);
        autoedits.put("%%OS400-MEM_NAME", memName);
        autoedits.put("%%OS400-AEV_LEN", "4000");
        autoedits.put("%%OS400-OBJTYP", objtyp);
        if (objtyp.equals("*CMDLINE")) {
            autoedits.put("%%OS400-CMDLINE1", cmdline);
        }
    }

    public static void parseCommandLineWithActionSubmit(String os400Command, StringBuffer jobname, StringBuffer user, StringBuffer cmdline, LinkedHashMap<String, String> autoedits) {
        while (os400Command.length() > 0) {
            String keyword = "";
            String parameter = "";
            for (int index = 0; index < os400Command.length(); ++index) {
                if (!os400Command.substring(index, index + 1).equals("(")) continue;
                keyword = os400Command.substring(0, index).trim();
                if (index + 1 >= os400Command.length()) {
                    os400Command = "";
                    break;
                }
                os400Command = os400Command.substring(index + 1);
                break;
            }
            if (keyword.isEmpty()) break;
            int parCounter = 1;
            for (int index = 0; index < os400Command.length(); ++index) {
                if (os400Command.charAt(index) == '(') {
                    ++parCounter;
                } else if (os400Command.charAt(index) == ')') {
                    --parCounter;
                }
                if (parCounter != 0) continue;
                parameter = os400Command.substring(0, index);
                if (index + 1 >= os400Command.length()) {
                    os400Command = "";
                    break;
                }
                os400Command = os400Command.substring(index + 1).trim();
                break;
            }
            if (parameter.length() <= 0) continue;
            if (keyword.equalsIgnoreCase("JOB")) {
                jobname.replace(0, jobname.length(), parameter);
                continue;
            }
            if (keyword.equalsIgnoreCase("USER")) {
                user.replace(0, user.length(), parameter);
                continue;
            }
            if (keyword.equalsIgnoreCase("CMD")) {
                cmdline.replace(0, cmdline.length(), parameter);
                continue;
            }
            autoedits.put("%%OS400-" + keyword, parameter);
        }
    }

    public static void converstCallCommand(StringBuffer cmdline, StringBuffer objtyp, StringBuffer memlib, StringBuffer memname, LinkedHashMap<String, String> autoedits) {
        if (cmdline.toString().startsWith("CALL ")) {
            String[] s2;
            objtyp.replace(0, objtyp.length(), "*PGM");
            String tempCmd = cmdline.substring("*PGM".length()).trim();
            cmdline.replace(0, cmdline.length(), tempCmd);
            String[] s1 = cmdline.toString().split(" ");
            if (s1.length > 1 && s1[1].equals(")")) {
                s1 = cmdline.toString().split(")");
            }
            Object parameters2 = cmdline.substring(s1[0].length()).trim();
            if (s1[0].toUpperCase().startsWith("PGM(")) {
                s1[0] = s1[0].substring("PGM".length() + 1).trim();
                if (s1[0].endsWith(")")) {
                    s1[0] = s1[0].substring(0, s1[0].length() - 1);
                }
            }
            if ((s2 = s1[0].split("/")).length > 1) {
                memlib.replace(0, memlib.length(), s2[0]);
                memname.replace(0, memname.length(), s2[1]);
            } else {
                memlib.replace(0, memlib.length(), "*LIBL");
                memname.replace(0, memname.length(), s2[0]);
            }
            if (((String)parameters2).length() > 0 && ((String)parameters2).startsWith("PARM(")) {
                parameters2 = ((String)parameters2).substring("PARM".length() + 1, ((String)parameters2).length() - 1).trim();
            }
            if (((String)parameters2).length() > 0) {
                Integer parmIndex = 1;
                while (((String)parameters2).length() > 0) {
                    parameters2 = (String)parameters2 + " ";
                    String parmType = "";
                    int strIndex = 0;
                    int endIndex = 0;
                    if (((String)parameters2).startsWith("X'") || ((String)parameters2).startsWith("x'")) {
                        parmType = "%%HEX";
                        strIndex = 2;
                        endIndex = ((String)parameters2).indexOf("' ");
                    } else if (!((String)parameters2).startsWith("'") && GlobalFunctions.isNumber((String)((String)parameters2).substring(0, ((String)parameters2).indexOf(" ")))) {
                        parmType = "%%DEC";
                        strIndex = 0;
                        endIndex = ((String)parameters2).indexOf(" ");
                    } else {
                        String endChar = " ";
                        if (((String)parameters2).startsWith("'")) {
                            strIndex = 1;
                            endChar = "'";
                        }
                        endIndex = strIndex + 1;
                        while (endIndex > 0 && endIndex < ((String)parameters2).length()) {
                            if ((endIndex = ((String)parameters2).indexOf(endChar, endIndex)) <= 0) continue;
                            if (!endChar.equals("'") || !((String)parameters2).substring(endIndex, endIndex + 2).equals("''")) break;
                            endIndex += 2;
                        }
                        if (endIndex < 0) {
                            endIndex = ((String)parameters2).length();
                        }
                    }
                    if (endIndex < strIndex) break;
                    String parmVal = parmType + ((String)parameters2).substring(strIndex, endIndex);
                    String keyword = "PARM" + parmIndex.toString();
                    autoedits.put("%%OS400-" + keyword, parmVal);
                    Integer n = parmIndex;
                    parmIndex = parmIndex + 1;
                    if (!parmType.equals("%%DEC")) {
                        ++endIndex;
                    }
                    parameters2 = ((String)parameters2).substring(endIndex).trim();
                }
            }
        }
    }
}

