/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.tws.JobNamePredicate;
import com.bmc.ctmconvert.tws.ScheduleTable;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameBuilder {
    private TwsJob twsJob;
    private TwsDefs sourceDefinition;
    private String pred;
    private String predJobName;
    private String predCpuName;
    private String predSchedName;
    private String predODAT = "ODAT";
    private boolean matchingPrevious;
    private String followsNotSupported = "";

    public NameBuilder(TwsJob twsJob, TwsDefs sourceDefinition, String pred) {
        this.twsJob = twsJob;
        this.sourceDefinition = sourceDefinition;
        this.pred = pred;
        this.predJobName = "";
        this.predCpuName = "";
        this.predSchedName = "";
        this.matchingPrevious = this.checkmatchingPrevious();
        this.setNames();
    }

    private boolean checkExistanceOfODAT(Matcher matcher) {
        return matcher.group(7) != null && !matcher.group(7).trim().isEmpty();
    }

    private boolean checkDefaultToBeIgnored(Matcher matcher) {
        return matcher.group(7).trim().equalsIgnoreCase("PREVIOUS") || matcher.group(7).trim().equalsIgnoreCase("SAMEDAY") || matcher.group(7).trim().equalsIgnoreCase("IF SUCC");
    }

    private boolean checkmatchingPrevious() {
        boolean ret = false;
        if (this.twsJob.type() != SchedEntity.TYPE.JOB) {
            AttrHolderList fullAttr = this.twsJob.getSourceSched().getParams();
            if (fullAttr == null) {
                return false;
            }
            ret = this.hasMatchingPrevious(fullAttr);
        }
        return ret;
    }

    private boolean hasMatchingPrevious(AttrHolderList fullAttrs) {
        boolean matchingPrevious = false;
        for (IAttrHolder attrs : fullAttrs) {
            if (!attrs.getAttr("PARAMETER").equalsIgnoreCase("MATCHING") || !attrs.getAttr("VALUE").equalsIgnoreCase("PREVIOUS")) continue;
            matchingPrevious = true;
        }
        return matchingPrevious;
    }

    private void setNames() {
        this.pred = this.pred.replace("\"", "");
        Pattern pattern = Pattern.compile("(.+::)?(([A-Za-z0-9_-]+)#)?(([A-Za-z0-9_-]+)\\.)?([A-Za-z0-9_-]+|@)( .*)?");
        Matcher matcher = pattern.matcher(this.pred);
        if (matcher.matches()) {
            String specifiedPrevDate;
            if (this.checkExistanceOfODAT(matcher) && !this.checkDefaultToBeIgnored(matcher)) {
                this.followsNotSupported = matcher.group(7);
            }
            String matcherJobName = matcher.group(6);
            String scheduleName = matcher.group(5);
            boolean isNumberSignUsed = true;
            if (scheduleName == null && this.twsJob.getParentName() != null && this.twsJob.type() == SchedEntity.TYPE.JOB) {
                String[] schedNameParts = this.twsJob.getParentName().split("#");
                String string = schedNameParts.length > 1 ? schedNameParts[1] : (scheduleName = schedNameParts.length == 1 ? schedNameParts[0] : "");
                if (schedNameParts.length <= 1) {
                    isNumberSignUsed = false;
                }
            }
            String string = specifiedPrevDate = matcher.group(7) != null ? matcher.group(7).trim() : "";
            if (this.matchingPrevious || this.checkExistanceOfODAT(matcher)) {
                this.predODAT = this.resolveODATE(specifiedPrevDate);
            }
            if (this.predIsCpuTableJobFormat(matcher)) {
                if (matcherJobName.equals("@")) {
                    this.predCpuName = matcher.group(3);
                    this.predSchedName = scheduleName;
                    this.predJobName = null;
                } else {
                    String cpu = matcher.group(3);
                    String format = this.sourceDefinition.getConditionFormatRule();
                    if (format.equals("JOB-TO-JOB")) {
                        String predNode;
                        Object scheduleToSearch = "";
                        scheduleToSearch = !isNumberSignUsed ? scheduleName : cpu + "#" + scheduleName;
                        this.predCpuName = predNode = this.cpuOfJobInSchedule((String)scheduleToSearch, matcherJobName);
                    } else {
                        this.predCpuName = cpu;
                    }
                    this.predSchedName = scheduleName;
                    this.predJobName = matcherJobName;
                }
            } else {
                this.predSchedName = this.getPredSchedName(matcherJobName, scheduleName);
                this.predJobName = this.getPredJobName(matcherJobName, scheduleName);
                this.predCpuName = this.getPredNode(matcher, this.predJobName);
            }
        }
    }

    public String getcpuName() {
        return this.predCpuName;
    }

    public String getSchedName() {
        return this.predSchedName;
    }

    public String getPredJobName() {
        return this.predJobName;
    }

    private String cpuOfJobInSchedule(String scheduleToSearch, String matcherJobName) {
        ScheduleTable scheduleTable = this.sourceDefinition.getScheduleTable();
        TwsScheduleAttributes schedule = scheduleTable.getSceduleByID(scheduleToSearch);
        if (schedule == null) {
            this.twsJob.addMessage("WRN6027", this.twsJob.getJobName(), this.twsJob.getOriginalJobName(), "FOLLOWS " + this.pred);
            return "";
        }
        String predNode = this.getNodeOfPredJob(matcherJobName, schedule);
        return predNode;
    }

    private String getPredNode(Matcher matcher, String predJobName) {
        String predNode;
        if (this.twsJob.type() == SchedEntity.TYPE.SMART_TABLE) {
            String cpu = matcher.group(2);
            predNode = cpu == null || cpu.isEmpty() ? this.twsJob.GetOrigNodeid() : matcher.group(3);
        } else {
            String format = this.sourceDefinition.getConditionFormatRule();
            if (format.equals("JOB-TO-JOB")) {
                TwsScheduleAttributes scheduleAttr = this.twsJob.getSourceSched();
                predNode = this.getNodeOfPredJob(predJobName, scheduleAttr);
                if (predNode == null) {
                    predNode = this.twsJob.getParent().GetOrigNodeid();
                }
            } else {
                predNode = this.twsJob.getParent().GetOrigNodeid();
            }
        }
        return predNode;
    }

    private String getNodeOfPredJob(String predJobName, TwsScheduleAttributes scheduleAttr) {
        JobNamePredicate jobPredicate = new JobNamePredicate(predJobName);
        List<TwsJobAttributes> jobList = scheduleAttr.getJobs(jobPredicate);
        if (jobList.size() > 1) {
            System.out.println("multiple Jobs" + predJobName);
            return null;
        }
        if (jobList.size() == 0) {
            return null;
        }
        TwsJobAttributes job = jobList.get(0);
        String node = job.getCpuOfJob();
        return node;
    }

    private String getPredJobName(String matcherJobName, String scheduleName) {
        Object predJobName = this.twsJob.type() == SchedEntity.TYPE.SMART_TABLE ? (matcherJobName == null || matcherJobName.isEmpty() || matcherJobName.equals("@") ? null : matcherJobName) : (matcherJobName != null && !matcherJobName.isEmpty() ? (matcherJobName.equals("@") ? null : matcherJobName) : scheduleName);
        return predJobName;
    }

    private String getPredSchedName(String matcherJobName, String scheduleName) {
        String predSchedName = this.twsJob.type() == SchedEntity.TYPE.SMART_TABLE ? scheduleName : (matcherJobName == null || matcherJobName.isEmpty() ? this.twsJob.getParent().getOriginalJobName(false) : scheduleName);
        return predSchedName;
    }

    private boolean predIsCpuTableJobFormat(Matcher matcher) {
        String jobName = matcher.group(6);
        String cpu = matcher.group(2);
        return cpu != null && !cpu.isEmpty() && jobName != null && !jobName.isEmpty();
    }

    public String getPredODAT() {
        return this.predODAT;
    }

    private String resolveODATE(String odateValue) {
        boolean previous = odateValue.equals("PREVIOUS");
        boolean sameday = odateValue.equals("SAMEDAY");
        odateValue = this.matchingPrevious && !sameday || previous ? "PREV" : "ODAT";
        return odateValue;
    }

    public String getFollowsNotSupported() {
        return this.followsNotSupported;
    }
}

