/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.tws.InavlidJobFileException;
import com.bmc.ctmconvert.tws.JobReader;
import com.bmc.ctmconvert.tws.JobText;
import com.csvreader.CsvWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class Jobs {
    static final char MARKSIGN = '#';
    public static final String COMMANDTYPE = "COMMAND";
    public static final String SCRIPTTYPE = "SCRIPT";
    private static final String SCRIPTNAME = "scriptname";
    public static final String DOCOMMAND = "docommand";
    public static final String SUBMIT = "submit";
    private static final String DESCRIPTION = "description";
    private static final String INTERACTIVE = "interactive";
    private static final String RCCONDSUCC = "rccondsucc";
    private static final String ABENDPROMPT = "abendprompt";
    private static final String SUCCOUTPUTCOND = "SUCCOUTPUTCOND";
    static final String[] doubleQuotesParameters = new String[]{"docommand", "description", "rccondsucc", "scriptname"};
    static final String[] parameters = new String[]{"scriptname", "docommand", "streamlogon", "description", "tasktype", "interactive", "rccondsucc", "recovery", "abendprompt", "TASK", "SUCCOUTPUTCOND", "outputcond", "TWSAFFINITY"};
    static final String[] csvHeader = new String[]{"ID", "commandType", "scriptname/docommand", "streamlogon", "description", "tasktype", "interactive", "rccondsucc", "recovery", "abendprompt", "TASK", "SUCCOUTPUTCOND", "outputcond", "TWSAFFINITY"};
    private CsvWriter jobsCsv;
    private boolean parameterEncountered = false;
    private String currParam = "";
    private boolean waitingForDoubleQuote = false;
    private StringBuilder currentParamValue = null;
    private String[] jobParametersValues;
    private InputStream jobsInputStream;
    private OutputStream csvOutputStream;

    public Jobs(InputStream jobsInputStream, OutputStream csvOutputStream) {
        this.jobsInputStream = jobsInputStream;
        this.csvOutputStream = csvOutputStream;
        this.jobParametersValues = new String[csvHeader.length];
    }

    private int getParameterIndex(String param) {
        if (param.equalsIgnoreCase(SCRIPTNAME) || param.equalsIgnoreCase(DOCOMMAND)) {
            this.jobParametersValues[1] = param.equalsIgnoreCase(SCRIPTNAME) ? SCRIPTTYPE : COMMANDTYPE;
            return 2;
        }
        if (param.equalsIgnoreCase("TASK")) {
            this.jobParametersValues[1] = "TASK";
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!param.equalsIgnoreCase(parameters[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean isParameter(String param) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!param.equalsIgnoreCase(parameters[i])) continue;
            return true;
        }
        return false;
    }

    private void initParametersRecord() {
        for (int i = 0; i < csvHeader.length; ++i) {
            this.jobParametersValues[i] = "";
        }
    }

    private void setParameterValue() {
        if (!this.parameterEncountered) {
            return;
        }
        int parameterIndex = this.getParameterIndex(this.currParam);
        if (parameterIndex >= 0) {
            this.jobParametersValues[parameterIndex] = this.currentParamValue.length() == 0 ? "" : this.currentParamValue.toString();
        }
        this.currentParamValue.delete(0, this.currentParamValue.length());
    }

    private boolean isDoubleQuoteParameter(String param) {
        for (int i = 0; i < doubleQuotesParameters.length; ++i) {
            if (!param.equalsIgnoreCase(doubleQuotesParameters[i])) continue;
            return true;
        }
        return false;
    }

    private int findNextDoubleQuote(int startIndex, String inString) {
        int len = inString.length();
        for (int i = startIndex; i < len; ++i) {
            if (inString.charAt(i) != '\"' || (i <= 0 || inString.charAt(i - 1) == '\\') && i != 0) continue;
            return i;
        }
        if (inString.charAt(inString.length() - 1) == '\"') {
            return inString.length() - 1;
        }
        return -1;
    }

    private String handleDoubleQuoteParameter(String param, char appendChar) {
        int doubleQuoteIndex;
        if (this.waitingForDoubleQuote) {
            this.currentParamValue.append("\\n");
            doubleQuoteIndex = this.findNextDoubleQuote(0, param);
        } else {
            int from = param.indexOf(34);
            if (from > param.length()) {
                return null;
            }
            doubleQuoteIndex = this.findNextDoubleQuote(from + 1, param);
        }
        if (doubleQuoteIndex >= 0) {
            this.currentParamValue.append(param.substring(0, doubleQuoteIndex + 1));
            String restLine = param.substring(doubleQuoteIndex + 1).trim();
            this.waitingForDoubleQuote = false;
            if (restLine.isEmpty()) {
                return null;
            }
            return restLine;
        }
        this.currentParamValue.append(param);
        this.waitingForDoubleQuote = true;
        return null;
    }

    private static boolean isNotUnsupportedParameter(String[] params) {
        List<String> unSupportedParameters = List.of("DOJOB");
        return !unSupportedParameters.contains(params[0]);
    }

    private void getParametersFromReadLine(String line, int rowCounter, int startXml, int endXml) throws IOException {
        block11: {
            char appendChar = '\n';
            String[] params = line.split("[ \\t]+", 2);
            if (!this.parameterEncountered && !this.isParameter(params[0]) && Jobs.isNotUnsupportedParameter(params)) {
                this.jobParametersValues[0] = params[0].toUpperCase();
                this.parameterEncountered = false;
                if (params.length == 1) {
                    return;
                }
                params = params[1].split("[ \\t]+", 2);
                appendChar = ' ';
            }
            while (true) {
                if (this.currParam.equals("TASK") && rowCounter <= endXml && rowCounter >= startXml) {
                    appendChar = this.appendParameterValue(line, appendChar);
                    break block11;
                }
                if (!line.trim().isEmpty() && line.charAt(0) == '#') break block11;
                if (this.isParameter(params[0])) {
                    this.handleParameter(params, appendChar);
                } else if (!this.isParameter(params[0]) && this.parameterEncountered && !this.waitingForDoubleQuote) {
                    appendChar = this.appendParameterValue(params[0], appendChar);
                } else if (!(this.isParameter(params[0]) || this.parameterEncountered || this.waitingForDoubleQuote)) {
                    return;
                }
                if (this.isDoubleQuoteParameter(this.currParam)) {
                    String restLine = this.waitingForDoubleQuote ? this.handleDoubleQuoteParameter(line, appendChar) : (params.length > 1 ? this.handleDoubleQuoteParameter(params[1], appendChar) : null);
                    if (restLine != null && !restLine.isEmpty()) {
                        params = restLine.split("[ \\t]+", 2);
                        continue;
                    }
                    break block11;
                }
                if (params.length <= 1) break;
                params = params[1].split("[ \\t]+", 2);
            }
            if (!params[0].equalsIgnoreCase(INTERACTIVE)) break block11;
            this.currentParamValue.append("Y");
        }
    }

    private char appendParameterValue(String line, char appendChar) {
        if (this.currentParamValue.length() > 0) {
            this.currentParamValue.append(appendChar);
        }
        this.currentParamValue.append(line);
        appendChar = (char)32;
        return appendChar;
    }

    private void handleParameter(String[] params, char appendChar) {
        if (this.parameterEncountered && !this.waitingForDoubleQuote) {
            this.setParameterValue();
            this.currParam = params[0];
            appendChar = (char)32;
        } else if (!this.parameterEncountered && !this.waitingForDoubleQuote) {
            this.parameterEncountered = true;
            this.currParam = params[0];
            appendChar = (char)32;
        }
    }

    private void endJobdefinition() throws IOException {
        this.setParameterValue();
        this.jobsCsv.writeRecord(this.jobParametersValues);
        this.initParametersRecord();
        this.parameterEncountered = false;
        this.waitingForDoubleQuote = false;
    }

    public void writeToCSV() {
        try {
            JobReader jobReader = new JobReader(this.jobsInputStream);
            JobText job = new JobText();
            this.jobsCsv = new CsvWriter((Writer)new OutputStreamWriter(this.csvOutputStream), ',');
            this.jobsCsv.writeRecord(csvHeader);
            this.currentParamValue = new StringBuilder();
            this.initParametersRecord();
            while ((job = jobReader.readNextJob()) != null) {
                int rowCounter = -1;
                int startXml = job.getxmlStartLine();
                int endXml = job.getxmlEndLine();
                for (String line : job.getText()) {
                    if (line.trim().isEmpty() && (++rowCounter > endXml || rowCounter < startXml)) continue;
                    this.getParametersFromReadLine(line, rowCounter, startXml, endXml);
                }
                this.endJobdefinition();
            }
            this.jobsCsv.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (InavlidJobFileException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }
}

