/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.tws.Dependecy;
import com.bmc.ctmconvert.tws.DependencySide;
import com.bmc.ctmconvert.tws.NameBuilder;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.TwsUniqueConditionNameGenerator;

public class InConditionBuilder {
    private TwsJob twsJob;
    private TwsDefs sourceDefinition;
    private NameBuilder nameBuilder;
    private TwsUniqueConditionNameGenerator uniqueConditionGenerator;

    public InConditionBuilder(TwsJob twsJob, TwsDefs sourceDefinition, NameBuilder nameBuilder) {
        this.twsJob = twsJob;
        this.sourceDefinition = sourceDefinition;
        this.nameBuilder = nameBuilder;
        this.uniqueConditionGenerator = sourceDefinition.getuniqueConditionNameGenerator();
    }

    public String buildInConditionName() {
        String predNode = this.nameBuilder.getcpuName();
        String predSchedName = this.nameBuilder.getSchedName();
        String predJobName = this.nameBuilder.getPredJobName();
        String inCondName = this.composeByConditionFormat(predNode, predSchedName, predJobName);
        String followsNotSupported = this.nameBuilder.getFollowsNotSupported();
        if (!followsNotSupported.isEmpty()) {
            this.twsJob.addMessage("WRN6009", this.twsJob.getOriginalJobName(), this.twsJob.getJobName(), followsNotSupported, inCondName);
        }
        return inCondName;
    }

    private String composeByConditionFormat(String predNode, String predFolder, String predJobName) {
        String format = this.sourceDefinition.getConditionFormatRule();
        if (format.equals("JOB-TO-JOB")) {
            SchedEntity.TYPE predType = predJobName != null ? SchedEntity.TYPE.JOB : SchedEntity.TYPE.SMART_TABLE;
            return this.fromJobToJobConditionFormat(predType, predNode, predFolder, predJobName);
        }
        return this.endedOkConditionFormat(predNode, predFolder, predJobName);
    }

    private String endedOkConditionFormat(String node, String folder, String jobName) {
        Object object = jobName = jobName == null ? "" : "." + (String)jobName;
        if (node != null && ((String)node).length() > 0) {
            node = (String)node + "#";
        }
        return String.format("%s%s%s_OK", node, folder, jobName);
    }

    private String fromJobToJobConditionFormat(SchedEntity.TYPE predType, String predNode, String predFolder, String predJobName) {
        DependencySide getterSide = this.getGetterSideDependency();
        String scheduleWithFollows = this.getFollowStatementSchedule();
        DependencySide senderSide = predType == SchedEntity.TYPE.JOB ? new DependencySide(predNode, predFolder, predJobName) : new DependencySide(predNode, predFolder);
        Dependecy dependency = new Dependecy(senderSide, getterSide, scheduleWithFollows, "INCOND");
        return this.uniqueConditionGenerator.getUniqueConditionName(dependency);
    }

    private String getFollowStatementSchedule() {
        String followLocation = this.twsJob.type() == SchedEntity.TYPE.JOB ? this.twsJob.getParent().getOriginalJobName() : this.twsJob.getOriginalJobName();
        return followLocation;
    }

    public String getInConditionODAT() {
        return this.nameBuilder.getPredODAT();
    }

    private DependencySide getGetterSideDependency() {
        DependencySide inSide = this.twsJob.type() == SchedEntity.TYPE.JOB ? new DependencySide(this.twsJob.GetOrigNodeid(), this.twsJob.getOriginalParentName(false), this.twsJob.getOriginalJobName(false)) : new DependencySide(this.twsJob.GetOrigNodeid(), this.twsJob.getOriginalJobName(false));
        return inSide;
    }
}

