/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tws.NameBuilderByFiedsEditor;

public class DependencySide {
    private SchedEntity.TYPE type;
    private String cpuName;
    private String folderName;
    private String jobName;

    public DependencySide(String cpuName, String folderName, String jobName) {
        this.type = SchedEntity.TYPE.JOB;
        this.cpuName = cpuName;
        this.folderName = folderName;
        this.jobName = jobName;
    }

    public DependencySide(String cpuName, String folderName) {
        this.type = SchedEntity.TYPE.SMART_TABLE;
        this.cpuName = cpuName;
        this.folderName = folderName;
        this.jobName = null;
    }

    public String getJobNameAccordingUserRules(RulesDataSet rules) {
        NameBuilderByFiedsEditor nameBuilder = new NameBuilderByFiedsEditor(rules);
        String fieldName = this.type == SchedEntity.TYPE.JOB ? "JOBNAME" : "FOLDER_NAME";
        String jobId = this.type == SchedEntity.TYPE.JOB ? this.jobName : this.folderName;
        return nameBuilder.buildNameAccordingFieldsEditor(fieldName, this.cpuName, jobId);
    }

    public SchedEntity.TYPE getType() {
        return this.type;
    }

    public void setType(SchedEntity.TYPE type) {
        this.type = type;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public void setCpuName(String cpuName) {
        this.cpuName = cpuName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cpuName == null ? 0 : this.cpuName.hashCode());
        result = 31 * result + (this.folderName == null ? 0 : this.folderName.hashCode());
        result = 31 * result + (this.jobName == null ? 0 : this.jobName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencySide other = (DependencySide)obj;
        if (this.cpuName == null ? other.cpuName != null : !this.cpuName.equals(other.cpuName)) {
            return false;
        }
        if (this.folderName == null ? other.folderName != null : !this.folderName.equals(other.folderName)) {
            return false;
        }
        if (this.jobName == null ? other.jobName != null : !this.jobName.equals(other.jobName)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        Object ret = "";
        if (this.type == SchedEntity.TYPE.JOB) {
            ret = "Type: Job\n";
            ret = (String)ret + "Folder Name: " + this.folderName + "\n";
            ret = (String)ret + "Job Name : " + this.cpuName + "#" + this.jobName;
        } else {
            ret = "Type: Folder\n";
            ret = (String)ret + "Job Name : " + this.cpuName + "#" + this.folderName;
        }
        return ret;
    }
}

