/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.tws.TWSDataCapture;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;

public class DataImportTWS
extends DataImportVendor {
    private BaseBrowseTextField jobsDefinitions;
    private BaseBrowseTextField CPUDefinitions;
    private BaseBrowseTextField parameterDefinitions;
    private BaseBrowseTextField scheduleDefinitions;
    private BaseBrowseTextField resourcesDefinitions;
    private BaseBrowseTextField calendarsDefinitions;
    private BaseBrowseTextField variableTablesDefinitions;
    private BaseBrowseTextField workstationParametersDirectory;

    public DataImportTWS() {
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_TWS")), new BaseFooterPanel(""));
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        String[] extentions = new String[]{"TXT"};
        this.jobsDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        String str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "JOB", "Composer create <jobs file> from JOBS \nOr if the command creates an empty file: \nComposer create <jobs file> from jobs=@#@\n", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.jobsDefinitions, TextManager.instance().get("FIELD_TWS_JOB_DEFINITIONS"), true, str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "CPU", "Composer create <cpu file> from CPU\nOr if the command creates an empty file: \nComposer create <cpu file> from cpu=@\n", Params.instance().getVendorName());
        this.CPUDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        section.addField(new BaseField((BaseComponent)this.CPUDefinitions, TextManager.instance().get("FIELD_TWS_CPU_DEFINITIONS"), true, str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "Parameters", "\nComposer create <parms file> from PARMS\n", Params.instance().getVendorName());
        this.parameterDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        section.addField(new BaseField((BaseComponent)this.parameterDefinitions, TextManager.instance().get("FIELD_TWS_PARAMETER_DEFINITIONS"), true, str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "Schedule", "\nComposer create <schedule file> from SCHED \nOr if the command creates an empty file: \nComposer create <schedule file> from sched=@#@\n", Params.instance().getVendorName());
        this.scheduleDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        section.addField(new BaseField((BaseComponent)this.scheduleDefinitions, TextManager.instance().get("FIELD_TWS_SCHEDULE_DEFINITIONS"), true, str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "Resource", "\ncomposer create <resource file> from RESOURCES\n", Params.instance().getVendorName());
        this.resourcesDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.resourcesDefinitions, TextManager.instance().get("FIELD_TWS_RESOURCES_DEFINITIONS"), str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "calendars", "\ncomposer create <calendars file> from CALENDARS\n", Params.instance().getVendorName());
        this.calendarsDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.calendarsDefinitions, TextManager.instance().get("FIELD_TWS_CALENDARS_DEFINITIONS"), str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "Variable", "\ncomposer create <variables file> from VARIABLES\n", Params.instance().getVendorName());
        this.variableTablesDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.variableTablesDefinitions, TextManager.instance().get("FIELD_TWS_VARIABLE_TABLES_JOB_DEFINITIONS"), str));
        str = String.format(TextManager.instance().get("TWS_DESCRIPTION"), "Workstation", "directory that contains files <Workstation_name>_parms.txt\n", Params.instance().getVendorName());
        this.workstationParametersDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.workstationParametersDirectory, TextManager.instance().get("FIELD_TWS_WORKSTATION_DEFINITIONS"), str));
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    public Component getDefaultFocusedComponent() {
        return this.jobsDefinitions.getComponent();
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        return DataImportTWS.staticDataImport(destinationFolderPath, this.jobsDefinitions.getText(), this.CPUDefinitions.getText(), this.parameterDefinitions.getText(), this.scheduleDefinitions.getText(), this.resourcesDefinitions.getText(), this.calendarsDefinitions.getText(), this.variableTablesDefinitions.getText(), this.workstationParametersDirectory.getText(), progressBar);
    }

    public static FlowGlobals.COMPLETION_MODE staticDataImport(String destinationFolderPath, String jobsDefinitions, String CPUDefinitions, String parameterDefinitions, String scheduleDefinitions, String resourcesDefinitions, String calendarsDefinitions, String variableTablesDefinitions, String workstationParametersDirectory, BaseProgressBar progressBar) {
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("TWS_PROGRESS_BAR_PROCESSING_FILE"));
        }
        HashMap<TWSDataCapture.SOURCE_INPUT_TYPE, File> sourceTypeToFile = new HashMap<TWSDataCapture.SOURCE_INPUT_TYPE, File>();
        sourceTypeToFile.clear();
        sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.JOBS_FILE, new File(jobsDefinitions));
        sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.CPU_FILE, new File(CPUDefinitions));
        sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.VARIABLES_FILE, new File(parameterDefinitions));
        sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.SCHEDULE_FILE, new File(scheduleDefinitions));
        String fileName = resourcesDefinitions;
        if (fileName != null && !fileName.isEmpty()) {
            sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.RESOURCE_FILE, new File(fileName));
        }
        if ((fileName = calendarsDefinitions) != null && !fileName.isEmpty()) {
            sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.CALENDARS_FILE, new File(fileName));
        }
        if ((fileName = variableTablesDefinitions) != null && !fileName.isEmpty()) {
            sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.VARIABLE_TABLE_FILE, new File(fileName));
        }
        if ((fileName = workstationParametersDirectory) != null && !fileName.isEmpty()) {
            sourceTypeToFile.put(TWSDataCapture.SOURCE_INPUT_TYPE.AGENT_PARMS_DIR, new File(fileName));
        }
        File csvFile = null;
        TWSDataCapture twsDataCapture = new TWSDataCapture(destinationFolderPath, sourceTypeToFile, progressBar);
        try {
            csvFile = twsDataCapture.createDataSource();
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        return csvFile != null ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    public String getHelpTitle() {
        return "LOAD_DATA_TWS";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.jobsDefinitions.getComponent().getName() + "=" + this.jobsDefinitions.getText() + "\n");
        stringBuilder.append(this.CPUDefinitions.getComponent().getName() + "=" + this.CPUDefinitions.getText() + "\n");
        stringBuilder.append(this.parameterDefinitions.getComponent().getName() + "=" + this.parameterDefinitions.getText() + "\n");
        stringBuilder.append(this.scheduleDefinitions.getComponent().getName() + "=" + this.scheduleDefinitions.getText() + "\n");
        stringBuilder.append(this.resourcesDefinitions.getComponent().getName() + "=" + this.resourcesDefinitions.getText() + "\n");
        stringBuilder.append(this.calendarsDefinitions.getComponent().getName() + "=" + this.calendarsDefinitions.getText() + "\n");
        stringBuilder.append(this.variableTablesDefinitions.getComponent().getName() + "=" + this.variableTablesDefinitions.getText() + "\n");
        stringBuilder.append(this.workstationParametersDirectory.getComponent().getName() + "=" + this.workstationParametersDirectory.getText() + "\n");
        return stringBuilder.toString();
    }
}

