/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class CpuTable
extends CsvFile {
    private HashMap<String, IAttrHolder> cpuMap = new HashMap();
    private String masterDomainTz;

    protected void handleRecord(IAttrHolder cpuAttributes, int record_number) {
        this.cpuMap.put(cpuAttributes.getAttr("NAME"), cpuAttributes);
    }

    public boolean isWindowsNode(String node) {
        return this.cpuMap.containsKey(node) && this.cpuMap.get(node).getAttr("OS").equalsIgnoreCase("WNT");
    }

    public String getTable(String cpuName) {
        IAttrHolder attr = this.cpuMap.get(cpuName);
        if (attr != null) {
            return attr.getAttr("VARTABLE");
        }
        return null;
    }

    public boolean isCpuClass(String cpuName) {
        String _class;
        IAttrHolder attr = this.cpuMap.get(cpuName);
        return attr != null && (_class = attr.getAttr("CLASS")).equalsIgnoreCase("CPUCLASS");
    }

    public String getTimeZone(String cpu) {
        if (this.cpuMap.get(cpu) != null) {
            return this.cpuMap.get(cpu).getAttr("TIMEZONE");
        }
        return null;
    }

    public String getPhysName(String cpu) {
        return Optional.ofNullable(this.cpuMap.get(cpu)).map(node -> node.getAttr("NODE")).filter(nodeName -> !nodeName.isEmpty()).orElse(cpu);
    }

    public String getMasterTz() {
        if (this.masterDomainTz == null) {
            this.masterDomainTz = "";
            String masterName = "";
            for (String currCpu : this.cpuMap.keySet()) {
                if (!this.cpuMap.get(currCpu).getAttr("PARENT").equalsIgnoreCase("ISMASTER")) continue;
                masterName = this.cpuMap.get(currCpu).getAttr("*MANAGER");
                break;
            }
            if (!masterName.equals("") && this.cpuMap.containsKey(masterName)) {
                this.masterDomainTz = this.cpuMap.get(masterName).getAttr("TIMEZONE");
            }
        }
        return this.masterDomainTz;
    }

    public Set<String> getMembers(String cpu) {
        TreeSet<String> members = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.cpuMap.containsKey(cpu)) {
            String rawMembers = this.cpuMap.get(cpu).getAttr("MEMBERS").trim();
            members.addAll(Arrays.asList(rawMembers.split("\\s+")));
        }
        return members;
    }
}

