/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.tws.Cpu2csv;
import com.bmc.ctmconvert.tws.Jobs;
import com.bmc.ctmconvert.tws.Resources;
import com.bmc.ctmconvert.tws.Schedule;
import com.bmc.ctmconvert.tws.Vars2csv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TwsImporter
extends Importer {
    private ImportEntryList entries;

    public TwsImporter(ImportEntryList entries) {
        this.entries = entries;
    }

    public Progressable.ProgressStatus performImport() {
        String dataSourcePath = ConversionEntitiesService.getCurrentProjectDataDirectory();
        this.setProgressMax(this.entries.size());
        int count = 0;
        for (ImportEntry entry : this.entries) {
            this.setCurrentProgress(++count);
            if (this.isStopped()) break;
            try {
                switch (entry.getID()) {
                    case "JOB": {
                        this.writeJobToCsv(dataSourcePath);
                        break;
                    }
                    case "CPU": {
                        this.writeCpuToCsv(dataSourcePath);
                        break;
                    }
                    case "RESOURCE": {
                        this.writeJResourceToCsv(dataSourcePath);
                        break;
                    }
                    case "SCHEDULE": {
                        this.writeScheduleToCsv(dataSourcePath);
                        break;
                    }
                    case "PARAMETER": {
                        this.writeParameterToCsv(dataSourcePath);
                        break;
                    }
                }
            }
            catch (IOException e) {
                if (entry.isMandatory()) {
                    this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
                }
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
        return this.getStatus();
    }

    private void writeJResourceToCsv(String dataSourcePath) {
        Resources res = new Resources(new File(dataSourcePath + "resource.txt").getAbsoluteFile(), dataSourcePath);
        res.writeToCSV();
    }

    private void writeCpuToCsv(String dataSourcePath) throws IOException {
        Cpu2csv cpus = new Cpu2csv(new File(dataSourcePath + "cpus.txt"), new File(dataSourcePath + Globs.DIRSEP + "cpus.csv"));
        cpus.writeToCSV();
    }

    private void writeJobToCsv(String dataSourcePath) throws FileNotFoundException {
        File jobsCsvfile = new File(dataSourcePath + "jobs.csv");
        File jobsInputFile = new File(dataSourcePath + "jobs.txt").getAbsoluteFile();
        if (!jobsInputFile.exists()) {
            return;
        }
        Jobs jobs = new Jobs(new FileInputStream(jobsInputFile), new FileOutputStream(jobsCsvfile));
        jobs.writeToCSV();
    }

    private void writeScheduleToCsv(String dataSourcePath) throws FileNotFoundException {
        File scheduleInputFile = new File(dataSourcePath + "schedule.txt").getAbsoluteFile();
        if (!scheduleInputFile.exists()) {
            return;
        }
        File scheduleCsvfile = new File(dataSourcePath + "schedule.csv");
        File scheduleParamsCsvFile = new File(dataSourcePath + "scheduleParams.csv");
        File jobsStatementsCsvFile = new File(dataSourcePath + "scheduleJobs.csv");
        File jobsStatementsParamsCsvFile = new File(dataSourcePath + "scheduleJobsParams.csv");
        Schedule sched = new Schedule(new FileInputStream(scheduleInputFile), new FileOutputStream(scheduleCsvfile), new FileOutputStream(scheduleParamsCsvFile), new FileOutputStream(jobsStatementsCsvFile), new FileOutputStream(jobsStatementsParamsCsvFile));
        sched.writeToCSV();
    }

    private void writeParameterToCsv(String dataSourcePath) throws IOException {
        File varTableInputFile = new File(dataSourcePath + "var_tables.txt");
        File variablesInputFile = new File(dataSourcePath + "variables.txt");
        File parmsDir = new File(dataSourcePath + "ag_parm");
        File targetCsv = new File(dataSourcePath + Globs.DIRSEP + "variables.csv");
        Vars2csv vars = new Vars2csv(varTableInputFile, variablesInputFile, parmsDir, targetCsv);
        vars.createCsv();
    }
}

