/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import com.bmc.ctmconvert.io.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class TwsEntryDetector
implements DetectFileForEntry {
    public List<String> getFilesForEntry(ImportEntry entry, List<Path> files) {
        List<String> filesFound = this.detectByBeginningOfFile(entry, files);
        return filesFound;
    }

    private List<String> detectByBeginningOfFile(ImportEntry entry, List<Path> files) {
        ArrayList<String> filesFound = new ArrayList<String>();
        String entryCommand = entry.getCommmand();
        for (Path file : files) {
            if (!this.isFileContainsCommand(file, entryCommand)) continue;
            filesFound.add(file.toAbsolutePath().toString());
        }
        return filesFound;
    }

    private boolean isFileContainsCommand(Path file, String entryCommand) {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            String fileFirstWord = this.getOpeningWord(file);
            return fileFirstWord.equals(entryCommand);
        }
        return false;
    }

    private String getOpeningWord(Path file) {
        String firstWord = "";
        try (BufferedReader bufferedReader = FileUtils.createBufferedReader((Path)file, (CodingErrorAction)CodingErrorAction.REPLACE);){
            firstWord = this.getFirstLineIgnoreCommentAndEmptyLine(bufferedReader);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return this.normlizeOpeningWord(firstWord);
    }

    private String normlizeOpeningWord(String firstWord) {
        String asUpper = firstWord.trim().toUpperCase();
        String emptyCharRemoved = this.removeEmptyCharBegining(asUpper);
        String[] words = emptyCharRemoved.split(" ");
        return words[0];
    }

    private String removeEmptyCharBegining(String s) {
        if (s.startsWith("\ufeff")) {
            s = s.substring(1);
        }
        return s;
    }

    private String getFirstLineIgnoreCommentAndEmptyLine(BufferedReader bufferedReader) throws IOException {
        int maxLine = 20;
        for (int i = 0; i < maxLine; ++i) {
            String line = bufferedReader.readLine();
            if (line == null || line.startsWith("#") || line.equals("") || line.startsWith("*")) continue;
            return line;
        }
        return "";
    }
}

