/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CsvFileInputStreamFolder;
import com.bmc.ctmconvert.TwsEntryDetector;
import com.bmc.ctmconvert.TwsImporter;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DefaultDataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.FirstDayOfTheWeekRule;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.tws.CliImporterTWS;
import com.bmc.ctmconvert.tws.TWSAssessmentReport;
import com.bmc.ctmconvert.tws.TimeZoneGetter;
import com.bmc.ctmconvert.tws.TwsDefs;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AppData
implements VendorData {
    public String getName() {
        return "TWS";
    }

    public String getDisplayName() {
        return "IBM\u00ae Tivoli\u00ae Workload Scheduler";
    }

    public ImportEntryList getImportEntries() {
        ImportEntryList entries = super.getImportEntries();
        entries.sort();
        return entries;
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public Importer getVendorImporter() {
        return new TwsImporter(this.getImportEntries());
    }

    public DataImportVendor getDataImport() {
        return null;
    }

    public DataForImportDetector getDataForImportDetector() {
        return new DefaultDataForImportDetector((DetectFileForEntry)new TwsEntryDetector());
    }

    public BasePanel getAssessmentReport(String path) {
        return new TWSAssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, null);
    }

    public CliImporter getCLIImporter() {
        return new CliImporterTWS();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) {
        CsvFileInputStreamFolder streamFolder = new CsvFileInputStreamFolder();
        try {
            streamFolder.setFileInputStreamByPath(Files.newInputStream(Paths.get(Params.instance().getDatasourcePath() + "schedule.csv", new String[0]), new OpenOption[0]), "schedule");
            streamFolder.setFileInputStreamByPath(Files.newInputStream(Paths.get(Params.instance().getDatasourcePath() + "scheduleParams.csv", new String[0]), new OpenOption[0]), "scheduleParams");
            streamFolder.setFileInputStreamByPath(Files.newInputStream(Paths.get(Params.instance().getDatasourcePath() + "scheduleJobs.csv", new String[0]), new OpenOption[0]), "scheduleJobs");
            streamFolder.setFileInputStreamByPath(Files.newInputStream(Paths.get(Params.instance().getDatasourcePath() + "scheduleJobsParams.csv", new String[0]), new OpenOption[0]), "scheduleJobsParams");
            streamFolder.setFileInputStreamByPath(Files.newInputStream(Paths.get(Params.instance().getDatasourcePath() + "jobs.csv", new String[0]), new OpenOption[0]), "jobs");
            this.insertTimeZone(streamFolder);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new RuntimeException(e);
        }
        TwsDefs twsDefs = new TwsDefs(RuleManager.instance().getCurrentRules());
        twsDefs.loadFiles(streamFolder);
        return twsDefs;
    }

    private void insertTimeZone(CsvFileInputStreamFolder streamFolder) {
        String path = Globs.MODULES_DATA_DIR + Globs.DIRSEP;
        Path tWSTimeZoneFile = new File(path + Params.instance().getVendorName() + Globs.DIRSEP + "TimeZones.dat").toPath();
        Path ctmTimeZoneFile = new File(path + "ctmTimeZones.dat").toPath();
        TimeZoneGetter timeZoneGetter = new TimeZoneGetter();
        InputStream tWSTimeZoneInputStream = timeZoneGetter.getTimeZoneInput(tWSTimeZoneFile);
        InputStream ctmTimeZoneInputStream = timeZoneGetter.getInputStream(ctmTimeZoneFile);
        streamFolder.setFileInputStream(tWSTimeZoneInputStream, "TimeZones.dat");
        streamFolder.setFileInputStream(ctmTimeZoneInputStream, "ctmTimeZones.dat");
    }

    public InputStream getRulesResourceFile() {
        InputStream fileStream = AppData.class.getResourceAsStream("/rules.xml");
        return fileStream;
    }

    public boolean isZOS() {
        return false;
    }

    public Dimension getSize() {
        return new Dimension(670, 600);
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return FirstDayOfTheWeekRule.getFirstDayOfTheWeek((String)"TWS rules", (String)"FIRST_DAY_OF_WEEK");
    }
}

