/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.report;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.draftwriter.JobMessage;
import com.bmc.ctmconvert.gui.report.CustomRenderer;
import com.bmc.ctmconvert.gui.report.FullReportPanel;
import com.bmc.ctmconvert.gui.report.GlobalVariablesReportGenerator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class TopPanelModel
extends DefaultTableModel {
    private FullReportPanel fullReportPanelReference;
    protected String[] columnNames;
    protected String[][] TopPanelRow;
    private static final long serialVersionUID = 1L;
    private Integer selectedRow = -1;
    protected static final int COLUMN_ID = 0;
    protected static final int COLUMN_MSG = 1;
    protected static final int COLUMN_QTY = 2;
    protected static final int COLUMN_COUNT = 3;

    public TopPanelModel(Integer view_mode, String parent_id, String node_id, FullReportPanel report) {
        this.fullReportPanelReference = report;
        if (view_mode == FullReportPanel.VIEW_MODE_BY_RESULT) {
            this.columnNames = new String[3];
            this.columnNames[0] = FullReportPanel.COL_HEADING_SEQ;
            this.columnNames[1] = FullReportPanel.COL_HEADING_MSGID;
            this.columnNames[2] = FullReportPanel.COL_HEADING_DESC;
        }
        if (view_mode == FullReportPanel.VIEW_MODE_BY_JOB) {
            this.columnNames = new String[3];
            this.columnNames[0] = FullReportPanel.COL_HEADING_SEQ;
            this.columnNames[1] = FullReportPanel.COL_HEADING_MSGID;
            this.columnNames[2] = FullReportPanel.COL_HEADING_DESC;
        }
        if (view_mode == FullReportPanel.VIEW_MODE_BY_ACTION) {
            this.columnNames = new String[4];
            this.columnNames[0] = FullReportPanel.COL_HEADING_SEQ;
            this.columnNames[1] = FullReportPanel.COL_HEADING_ENTTYPE;
            this.columnNames[2] = FullReportPanel.COL_HEADING_ENTNAME + " " + TextManager.instance().get("CONVERSION_REPORT_COLUMN_OR_ACTION") + " " + FullReportPanel.COL_HEADING_DESC;
            this.columnNames[3] = FullReportPanel.COL_HEADING_QTY;
        }
        this.selectedRow = this.populateTable(view_mode, parent_id, node_id);
    }

    public TopPanelModel(Integer view_mode, DefaultMutableTreeNode node, FullReportPanel report) {
        this.fullReportPanelReference = report;
        Integer node_level = node.getLevel();
        boolean fill_message_text = false;
        boolean fill_qty_stats = false;
        boolean fillVariableValue = false;
        boolean fillAFTData = false;
        boolean fillDBData = false;
        String count_col_hdg = FullReportPanel.COL_HEADING_COUNT;
        if (view_mode == FullReportPanel.VIEW_MODE_BY_RESULT) {
            this.columnNames = new String[4];
            if (node_level == 0) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_MSGTYPE;
            }
            if (node_level == 1) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_MSGID;
            }
            if (node_level > 1) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_JOBID;
            }
            if (node_level <= 1) {
                count_col_hdg = FullReportPanel.COL_HEADING_AFFECT_JOBS;
            }
        } else if (view_mode == FullReportPanel.VIEW_MODE_BY_JOB) {
            this.columnNames = new String[4];
            if (node_level == 0) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_JOBID;
            }
            if (node_level == 1) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_MSGID;
            }
        } else if (view_mode == FullReportPanel.VIEW_MODE_BY_ACTION) {
            if (node.toString().equalsIgnoreCase(Globs.ACTENTTYPE_QR_DESC)) {
                this.columnNames = new String[5];
                this.columnNames[3] = FullReportPanel.COL_HEADING_MAX_QTY;
                this.columnNames[4] = FullReportPanel.COL_HEADING_TOTAL_QTY;
                fill_qty_stats = true;
            } else {
                this.columnNames = new String[4];
            }
            if (node.toString().equalsIgnoreCase("MFT Account")) {
                this.columnNames[3] = "Parameters";
                fillAFTData = true;
            }
            if (node.toString().equalsIgnoreCase("Database Connection Profile")) {
                this.columnNames[3] = "Parameters";
                fillDBData = true;
            }
            if (node.toString().equalsIgnoreCase(Globs.ACTENTTYPE_GLOBAL_AUTOEDIT_DESC)) {
                this.columnNames[3] = "Value";
                fillVariableValue = true;
            }
            if (node_level == 0) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_ENTTYPE;
            }
            if (node_level == 1) {
                this.columnNames[1] = node.toString() + " " + TextManager.instance().get("CONVERSION_REPORT_COLUMN_NAME");
                count_col_hdg = FullReportPanel.COL_HEADING_AFFECT_JOBS;
            }
            if (node_level > 1) {
                this.columnNames[1] = FullReportPanel.COL_HEADING_JOBID;
            }
        }
        this.columnNames[0] = FullReportPanel.COL_HEADING_SEQ;
        this.columnNames[2] = count_col_hdg;
        if (this.columnNames[1].toString().equals(FullReportPanel.COL_HEADING_MSGID)) {
            this.columnNames[3] = FullReportPanel.COL_HEADING_MSGTXT;
            fill_message_text = true;
        }
        this.populateStats(view_mode, node, fill_message_text, fill_qty_stats, fillVariableValue, fillAFTData, fillDBData);
    }

    public Integer getSelectedRow() {
        if (this.selectedRow < 0) {
            return 0;
        }
        return this.selectedRow;
    }

    @Override
    public int getRowCount() {
        if (this.TopPanelRow == null) {
            return 0;
        }
        return this.TopPanelRow.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.TopPanelRow[row][column];
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int vColIndex) {
        return false;
    }

    private Integer populateTable(Integer view_mode, String parent_id, String node_id) {
        Integer selectedParentRow = -1;
        Integer selectedParentRow_CheckColumn = 0;
        if (view_mode == FullReportPanel.VIEW_MODE_BY_ACTION) {
            selectedParentRow_CheckColumn = 1;
        }
        String[][] msgResultSet = this.fullReportPanelReference.getJobIdMessageList(node_id, view_mode);
        this.TopPanelRow = new String[msgResultSet.length][this.getColumnCount()];
        Integer i = 0;
        while (i < msgResultSet.length) {
            this.TopPanelRow[i.intValue()][0] = Integer.toString(i + 1);
            Integer j = 1;
            while (j < this.getColumnCount()) {
                this.TopPanelRow[i.intValue()][j.intValue()] = msgResultSet[i][j - 1].toString();
                Integer n = j;
                j = j + 1;
            }
            if (selectedParentRow < 0 && msgResultSet[i][selectedParentRow_CheckColumn].toString().equals(parent_id.toString())) {
                selectedParentRow = i;
            }
            Integer n = i;
            i = i + 1;
        }
        return selectedParentRow;
    }

    private void populateStats(Integer view_mode, DefaultMutableTreeNode node, boolean fill_message_text, boolean fill_qty_stats, boolean fillVariableValue, boolean fillAFT_Data, boolean fillDB_Data) {
        TreeNode childNode = null;
        Integer count = 0;
        Integer i = 0;
        Integer total = 0;
        String[] messageVars = new String[JobMessage.MAX_REPORT_RESNUMVAR.intValue()];
        Map<String, String> globalVariablesMap = this.getGlobalVariableMap();
        Integer messageVarsIndex = 0;
        while (messageVarsIndex < messageVars.length) {
            messageVars[messageVarsIndex.intValue()] = "<value>";
            Integer n = messageVarsIndex;
            messageVarsIndex = messageVarsIndex + 1;
        }
        this.TopPanelRow = new String[node.getChildCount() + 1][this.getColumnCount()];
        try {
            childNode = node.getFirstChild();
        }
        catch (NoSuchElementException e) {
            childNode = null;
        }
        while (childNode != null) {
            String params;
            count = childNode.isLeaf() ? (node.getLevel() == CustomRenderer.leafLevel[view_mode] - 1 ? (view_mode == FullReportPanel.VIEW_MODE_BY_JOB ? this.fullReportPanelReference.getChildNodeCount(view_mode, childNode.toString()) : (view_mode == FullReportPanel.VIEW_MODE_BY_RESULT ? this.fullReportPanelReference.getChildNodeCount(view_mode, childNode.toString(), node.toString()) : Integer.valueOf(1))) : Integer.valueOf(0)) : Integer.valueOf(((DefaultMutableTreeNode)childNode).getLeafCount());
            total = total + count;
            this.TopPanelRow[i.intValue()][0] = Integer.toString(i + 1);
            this.TopPanelRow[i.intValue()][1] = childNode.toString();
            this.TopPanelRow[i.intValue()][2] = count.toString();
            if (fill_message_text) {
                JobMessage job_message = new JobMessage(childNode.toString());
                this.TopPanelRow[i.intValue()][3] = job_message.getMessageText(childNode.toString(), messageVars);
            }
            if (fill_qty_stats) {
                Integer[] actionStats = this.fullReportPanelReference.getActionStats("QR", childNode.toString());
                this.TopPanelRow[i.intValue()][3] = actionStats[1].toString();
                this.TopPanelRow[i.intValue()][4] = actionStats[2].toString();
            }
            if (fillVariableValue) {
                String varValue = globalVariablesMap.get(childNode.toString());
                String string = this.TopPanelRow[i.intValue()][3] = varValue != null ? varValue.trim() : "";
            }
            if (fillAFT_Data) {
                this.TopPanelRow[i.intValue()][3] = params = this.fullReportPanelReference.getActionPARAMS("AFTACC", childNode.toString());
            }
            if (fillDB_Data) {
                this.TopPanelRow[i.intValue()][3] = params = this.fullReportPanelReference.getActionPARAMS("DATABASEACC", childNode.toString());
            }
            Integer n = i;
            i = i + 1;
            childNode = node.getChildAfter(childNode);
        }
        this.TopPanelRow[i.intValue()][0] = FullReportPanel.ROW_HEADING_TOTAL;
        this.TopPanelRow[i.intValue()][1] = "";
        this.TopPanelRow[i.intValue()][2] = total.toString();
    }

    private Map<String, String> getGlobalVariableMap() {
        return new GlobalVariablesReportGenerator().generate(this.fullReportPanelReference.getActionMessages().values());
    }
}

