/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.ConversionExecuter;
import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentSection;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDropDown;
import com.bmc.ctmconvert.base.BaseExpander;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseLabel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.list.BaseItem;
import com.bmc.ctmconvert.common.ExtensionFileFilter;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.draftwriter.VersionControl;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ConversionSettingPanel
extends FlowPanel {
    private static final String IMPORT_LIST_ITEM_TITLE = "Import From File...";
    private static final String IMPORT_LIST_ITEM_NAME = "import";
    private static final String EXPORT_LIST_ITEM_TITLE = "Export to File...";
    private static final String EXPORT_LIST_ITEM_NAME = "Export";
    private static final String MORE_EXPENDER_TEXT = "More";
    private static final String LESS_EXPENDER_TEXT = "Less";
    private static final String CONTROL_M_FOR_DS_LABLE_TEXT = "Control-M Server";
    private static final String CONTROL_M_FOR_ZOS_LABLE_TEXT = "Control-M z/OS Server";
    private static final String SAVE_BUTTON_TEXT = "Save";
    private static final String SAVE_AS_COPY_OF_FILE_NAME = "Copy of ";
    private static final String BUTTON_TEXT_SAVE_AS = "Save as..";
    private static final String MAKE_DEFAULT_BUTTON_NAME = "Make Default";
    private static final String DEFAULT_BUTTON_NAME = "Default";
    private static ConversionSettingPanel instance;
    private static String dataSourceName;
    private static String previousSelectedVersion;
    private final BaseTextField DSControlM;
    private final BaseTextField ZOSControlM;
    private final BaseButton saveButton;
    private final BaseButton saveAsButton;
    private final BaseDropDown rulesDrop;
    private final BaseExpander rulesExpander;
    private final BaseComponent rulesEditor;
    private final BaseComboBox versionsDrop;
    private String lastSelectedRule = null;
    private final BaseTitlePanel titlePanel;
    private final VersionControl versionControl = new VersionControl();

    public static ConversionSettingPanel instance() {
        if (instance == null || !Params.instance().getDatasourceName().equals(dataSourceName)) {
            previousSelectedVersion = VersionControl.getVersionGuiText((String)Params.instance().getGUIVersion());
            dataSourceName = Params.instance().getDatasourceName();
            instance = new ConversionSettingPanel();
        } else {
            instance.updateData();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public ConversionSettingPanel() {
        this.titlePanel = new BaseTitlePanel("\"" + ConversionEntitiesService.getCurrentConversionName() + "\" " + TextManager.instance().get("CONVERSION_PANEL_TITLE_CONVERSION_SETTING"));
        this.baseContentPanel = new BaseContentPanel(this.titlePanel){

            public void validityActionPerformed(ConversionEvent e) {
                this.setValid(ConversionSettingPanel.this.rulesEditor != null && ConversionSettingPanel.this.rulesEditor.isValid() && ConversionSettingPanel.this.DSControlM != null && ConversionSettingPanel.this.DSControlM.isValid() && ConversionSettingPanel.this.ZOSControlM != null && ConversionSettingPanel.this.ZOSControlM.isValid());
            }
        };
        this.setImagePanel(new BaseImagePanel(((Object)((Object)this)).getClass().getResource(FlowGlobals.SIDE_IMAGE_4_PATH)));
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.BACK, ButtonFactory.ButtonType.NEXT, ButtonFactory.ButtonType.QUIT}));
        JPanel settingsContent = new JPanel(new BorderLayout());
        settingsContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String DSControlMServerName = SettingsTable.instance().getProperty(SettingsStringKeys.DS_CONTROLM_SERVER_NAME, Params.instance().getDatacenterName());
        String ZOSControlMServerName = SettingsTable.instance().getProperty(SettingsStringKeys.ZOS_CONTROLM_SERVER_NAME, Params.instance().getMFDatacenterName());
        this.DSControlM = new BaseTextField(DSControlMServerName, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.DSControlM.addValidityListener((ValidityListener)this.baseContentPanel);
        this.ZOSControlM = new BaseTextField(ZOSControlMServerName, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.ZOSControlM.addValidityListener((ValidityListener)this.baseContentPanel);
        BaseLabel conversionSettingLable = new BaseLabel(VendorDataManager.instance().getVendorData().getDisplayName() + " Conversion Settings");
        conversionSettingLable.getComponent().setPreferredSize(null);
        this.rulesDrop = new BaseDropDown();
        final HashMap<String, JButton> ruleButtonMap = new HashMap<String, JButton>();
        this.setRulesToDropDown(this.rulesDrop, ruleButtonMap);
        this.addImportToDropDown(this.rulesDrop, ruleButtonMap);
        this.addExportItemToDropDown(this.rulesDrop);
        this.rulesDrop.addValueChangedAction(() -> {
            String newRuleName = this.rulesDrop.getSelectedItemName();
            if (newRuleName != null && !newRuleName.equals(this.lastSelectedRule)) {
                this.handleRuleSelected(this.lastSelectedRule, newRuleName, ruleButtonMap);
                this.lastSelectedRule = this.rulesDrop.getSelectedItemName();
            }
        });
        Object[] versions = this.versionControl.getVersions();
        this.versionsDrop = new BaseComboBox(versions);
        this.versionsDrop.getComponent().setPreferredSize(FlowGlobals.fieldSize);
        this.versionsDrop.addValueChangedAction(new Actionable(){
            String lastSelected = null;

            public void act() {
                String newVersionName = (String)ConversionSettingPanel.this.versionsDrop.getSelectedItem();
                if (newVersionName != null && !newVersionName.equals(this.lastSelected)) {
                    String str = (String)ConversionSettingPanel.this.versionsDrop.getSelectedItem();
                    String selectedVersionValue = ConversionSettingPanel.this.versionControl.getVersionValue(str);
                    ConversionSettingPanel.this.handleVersionChanged(selectedVersionValue, ruleButtonMap);
                    this.lastSelected = (String)ConversionSettingPanel.this.versionsDrop.getSelectedItem();
                    previousSelectedVersion = (String)ConversionSettingPanel.this.versionsDrop.getSelectedItem();
                }
            }
        });
        this.saveAsButton = new BaseButton(BUTTON_TEXT_SAVE_AS);
        this.saveAsButton.addActionListener(e -> this.openSaveAsDialog(ruleButtonMap));
        this.saveButton = new BaseButton(SAVE_BUTTON_TEXT);
        this.saveButton.addActionListener(e -> RuleManager.instance().saveCurrentData());
        RuleManager.instance().setOnChangeAction(new Actionable(){
            boolean firstChange = false;

            public void act() {
                if (RuleManager.instance().isCurrentRuleIsStandard()) {
                    ConversionSettingPanel.this.saveButton.setEnabled(false);
                } else {
                    ConversionSettingPanel.this.saveButton.setEnabled(RuleManager.instance().isRulesChanged());
                }
                if (!this.firstChange && RuleManager.instance().isRulesChanged()) {
                    this.firstChange = true;
                    FlowManager.instance().isConversionSettingPerformed(true);
                }
            }
        });
        this.saveButton.setEnabled(false);
        BaseField DSControlMField = new BaseField((BaseComponent)this.DSControlM, CONTROL_M_FOR_DS_LABLE_TEXT, true);
        BaseField ZOSControlMField = new BaseField((BaseComponent)this.ZOSControlM, CONTROL_M_FOR_ZOS_LABLE_TEXT, true);
        BaseComponentSection componentSection = new BaseComponentSection();
        BaseComponentSection.Grid addHorizontalGap = componentSection.createGrid(5, 2).addCell(componentSection.createCell(0, 0, (BaseComponent)conversionSettingLable).setWidth(5)).addCell(componentSection.createCell(0, 1, (BaseComponent)this.rulesDrop)).addCell(componentSection.createCell(1, 1, (Component)this.saveAsButton)).addCell(componentSection.createCell(2, 1, (Component)this.saveButton)).addHorizontalGap(3, 1, 35);
        BaseComponentSection.Grid addGrid = SettingsBooleanKeys.isSaas() ? VendorDataManager.instance().getVendorData().getServerNameSettings(DSControlMField, ZOSControlMField, componentSection, addHorizontalGap, this.DSControlM, this.ZOSControlM) : VendorDataManager.instance().getVendorData().getVersionGridForConversionSettings(DSControlMField, ZOSControlMField, componentSection, addHorizontalGap, this.versionsDrop, this.DSControlM, this.ZOSControlM);
        componentSection.setGrid(addGrid);
        ZOSControlMField.setVisible(Params.instance().isZOS());
        componentSection.setValid(true);
        settingsContent.add(componentSection.getComponent(), "North");
        this.rulesExpander = new BaseExpander(LESS_EXPENDER_TEXT, MORE_EXPENDER_TEXT);
        this.rulesExpander.toggle();
        this.rulesEditor = RuleManager.instance().getEditorComponent();
        this.rulesExpander.add(this.rulesEditor);
        settingsContent.add(this.rulesExpander.getComponent(), "Center");
        this.rulesEditor.addValidityListener((ValidityListener)this.baseContentPanel);
        this.baseContentPanel.addValidityListener((ValidityListener)this);
        this.baseContentPanel.setScrollable(false);
        this.baseContentPanel.setContentPanel((Component)settingsContent);
        this.setContentPanel(this.baseContentPanel);
        this.updateData();
    }

    private void handleVersionChanged(String newCtmVersion, HashMap<String, JButton> ruleButtonMap) {
        if (RuleManager.instance().isCurrentRuleIsStandard() && RuleManager.instance().isRulesChanged()) {
            String tmpPreviousSelectedValue = previousSelectedVersion;
            previousSelectedVersion = VersionControl.getVersionGuiText((String)newCtmVersion);
            this.versionsDrop.setSelectedItem((Object)tmpPreviousSelectedValue);
            boolean isCanceled = this.openIsToSaveChangedDataDialog(ruleButtonMap);
            if (isCanceled) {
                return;
            }
            this.versionsDrop.setSelectedItem((Object)VersionControl.getVersionGuiText((String)newCtmVersion));
        }
        RuleManager.instance().changeVersion(newCtmVersion);
    }

    private boolean openSaveAsDialog(HashMap<String, JButton> ruleButtonMap) {
        boolean isCanceled;
        String[] saveName = BaseMessageDialog.showSaveWithDescriptionDialog((String)BUTTON_TEXT_SAVE_AS, (String)(SAVE_AS_COPY_OF_FILE_NAME + RuleManager.instance().getCurrentRulesTitle()), (BaseFieldValidator.VALIDATOR_TYPE)BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY);
        if (saveName != null) {
            String savedName = saveName[0];
            String description = saveName[1];
            if (savedName != null && !savedName.isEmpty()) {
                String uniqueNewName = RuleManager.instance().saveAsCurrentData(savedName, description);
                this.addListItemToDropDown(this.rulesDrop, ruleButtonMap, uniqueNewName, savedName, description);
                RuleManager.instance().restoreCurrentDataSet();
                this.setRules(uniqueNewName);
                this.lastSelectedRule = this.rulesDrop.getSelectedItemName();
            }
            isCanceled = false;
        } else {
            isCanceled = true;
        }
        return isCanceled;
    }

    private void setRules(String rulesName) {
        RuleManager.instance().loadDataSet(rulesName);
        this.rulesDrop.setSelectedItem(RuleManager.instance().getCurrentRulesName());
    }

    private void addExportItemToDropDown(final BaseDropDown rulesDrop) {
        rulesDrop.addAssistItem(rulesDrop.createListItem(EXPORT_LIST_ITEM_NAME, EXPORT_LIST_ITEM_TITLE, "").addOnSelectedAction(new Actionable(){

            public void act() {
                this.showExportDialog();
            }

            public void showExportDialog() {
                JFileChooser fileChooser = new JFileChooser(".");
                fileChooser.setDialogTitle(ConversionSettingPanel.EXPORT_LIST_ITEM_NAME);
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setSelectedFile(new File(RuleManager.instance().getCurrentRulesTitle() + ".xml"));
                fileChooser.setFileFilter((FileFilter)new ExtensionFileFilter("xml", "xml"));
                if (fileChooser.showDialog(rulesDrop.getComponent(), ConversionSettingPanel.EXPORT_LIST_ITEM_NAME) == 0) {
                    File sourceFile = fileChooser.getSelectedFile();
                    if (sourceFile.exists() && !BaseMessageDialog.showConfirmDialog((String)ConversionSettingPanel.EXPORT_LIST_ITEM_NAME, (String)"overwrite?")) {
                        return;
                    }
                    if (sourceFile.getParentFile() == null || !sourceFile.getParentFile().exists()) {
                        BaseMessageDialog.showMessageDialog((String)"Error", (String)(String.valueOf(sourceFile) + "\nPath does not exist.\nCheck the path and try again."), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
                        return;
                    }
                    RuleManager.instance().exportDataSetFile(sourceFile.getAbsolutePath());
                }
            }
        }));
    }

    private void addImportToDropDown(final BaseDropDown rulesDrop, final HashMap<String, JButton> ruleButtonMap) {
        rulesDrop.addAssistItem(rulesDrop.createListItem(IMPORT_LIST_ITEM_NAME, IMPORT_LIST_ITEM_TITLE, "").addOnSelectedAction(new Actionable(){

            public void act() {
                this.showExportDialog();
            }

            public void showExportDialog() {
                JFileChooser fileChooser = new JFileChooser(".");
                fileChooser.setDialogTitle(ConversionSettingPanel.IMPORT_LIST_ITEM_NAME);
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setFileFilter((FileFilter)new ExtensionFileFilter("xml", "xml"));
                if (fileChooser.showDialog(rulesDrop.getComponent(), ConversionSettingPanel.IMPORT_LIST_ITEM_NAME) == 0) {
                    String newName;
                    File sourceFile = fileChooser.getSelectedFile();
                    if (!sourceFile.exists()) {
                        BaseMessageDialog.showMessageDialog((String)ConversionSettingPanel.IMPORT_LIST_ITEM_NAME, (String)"File not found.", (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
                        return;
                    }
                    try {
                        newName = RuleManager.instance().importDataSetFile(sourceFile.getAbsolutePath());
                    }
                    catch (RuleManager.InvalidRuleFileException e) {
                        BaseMessageDialog.showMessageDialog((String)"Error", (String)e.getMessage(), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE);
                        return;
                    }
                    if (newName != null) {
                        ConversionSettingPanel.this.addListItemToDropDown(rulesDrop, ruleButtonMap, newName, RuleManager.instance().getRuleSetTitle(newName), "");
                        rulesDrop.setSelectedItem(RuleManager.instance().getCurrentRulesName());
                    }
                }
            }
        }));
    }

    private void setRulesToDropDown(BaseDropDown rulesDrop, HashMap<String, JButton> ruleButtonMap) {
        Map ruleList = RuleManager.instance().getVendorRulesSetList();
        Map ruleDescriptionList = RuleManager.instance().getVendorRulesDescriptionSetList();
        for (Map.Entry ruleNameAndTitle : ruleList.entrySet()) {
            String ruleName = (String)ruleNameAndTitle.getKey();
            String ruleTitle = (String)ruleNameAndTitle.getValue();
            String ruleDescription = ruleDescriptionList.get(ruleName) != null ? (String)ruleDescriptionList.get(ruleName) : "";
            this.addListItemToDropDown(rulesDrop, ruleButtonMap, ruleName, ruleTitle, ruleDescription);
        }
        this.addListItemToDropDown(rulesDrop, ruleButtonMap, RuleManager.instance().getStandartRuleSetName(), RuleManager.instance().getStandartRuleSetTitle(), "", true);
        JButton defaultButton = ruleButtonMap.get(RuleManager.instance().getDefaultRuleSetName());
        if (defaultButton != null) {
            defaultButton.setText(DEFAULT_BUTTON_NAME);
            rulesDrop.setViseableItemComponent((JComponent)defaultButton, BaseItem.Visible.ALLWAYS);
        }
    }

    private void addListItemToDropDown(BaseDropDown rulesDrop, HashMap<String, JButton> ruleButtonMap, String ruleName, String ruleTitle, String ruleDescription) {
        this.addListItemToDropDown(rulesDrop, ruleButtonMap, ruleName, ruleTitle, ruleDescription, false);
    }

    private void addListItemToDropDown(BaseDropDown rulesDrop, HashMap<String, JButton> ruleButtonMap, String ruleName, String ruleTitle, String ruleDescription, boolean isStandardRulesItem) {
        JButton defaultButton = new JButton();
        String tmpRuleName = ruleName;
        ruleButtonMap.put(tmpRuleName, defaultButton);
        Font h = new Font("TimesRoman", 0, 11);
        defaultButton.setFont(h);
        defaultButton.setText(MAKE_DEFAULT_BUTTON_NAME);
        defaultButton.addActionListener(actionEvent -> {
            if (defaultButton.getText().equals(MAKE_DEFAULT_BUTTON_NAME)) {
                this.setDefaultItem(rulesDrop, ruleButtonMap, tmpRuleName);
            } else if (!isStandardRulesItem) {
                defaultButton.setText(MAKE_DEFAULT_BUTTON_NAME);
                RuleManager.instance().setDafaultRuleSet(RuleManager.instance().getStandartRuleSetName());
                this.setDefaultItem(rulesDrop, ruleButtonMap, RuleManager.instance().getDefaultRuleSetName());
            }
        });
        JButton deleteButton = new JButton(FlowGlobals.LIST_ITEM_DELETE_ICON);
        deleteButton.addActionListener(event -> {
            boolean confirm = BaseMessageDialog.showConfirmDialog((String)"Delete", (String)"Are you sure?");
            if (confirm) {
                if (RuleManager.instance().getDefaultRuleSetName() != null && RuleManager.instance().getDefaultRuleSetName().equals(tmpRuleName)) {
                    this.setDefaultItem(rulesDrop, ruleButtonMap, RuleManager.instance().getStandartRuleSetName());
                }
                rulesDrop.removeItem(tmpRuleName);
                ruleButtonMap.remove(tmpRuleName);
                if (RuleManager.instance().getCurrentRulesName().equals(tmpRuleName)) {
                    rulesDrop.setSelectedItem(RuleManager.instance().getStandartRuleSetName());
                }
                RuleManager.instance().deleteDataset(tmpRuleName);
            }
        });
        if (!isStandardRulesItem) {
            rulesDrop.addListItem(rulesDrop.createListItem(ruleName, ruleTitle, ruleDescription).addItemComponent(rulesDrop.createItemComponent(defaultButton)).addItemComponent(rulesDrop.createItemComponent(deleteButton)));
        } else {
            rulesDrop.addListItem(rulesDrop.createListItem(ruleName, ruleTitle, ruleDescription).addItemComponent(rulesDrop.createItemComponent(defaultButton)));
        }
    }

    private void handleRuleSelected(String lastName, String newName, HashMap<String, JButton> ruleButtonMap) {
        if (RuleManager.instance().isRulesChanged()) {
            boolean isCanceled;
            if (lastName != null) {
                this.rulesDrop.setSelectedItem(lastName);
            }
            if (!(isCanceled = this.openIsToSaveChangedDataDialog(ruleButtonMap))) {
                this.setRules(newName);
            }
        } else {
            RuleManager.instance().loadDataSet(newName);
        }
    }

    private boolean openIsToSaveChangedDataDialog(HashMap<String, JButton> ruleButtonMap) {
        int confirm = BaseMessageDialog.showConfirmWithCancelDialog((String)"Save Changes", (String)String.format(TextManager.instance().get("RULES_SAVE_CHNGES_DIALOG_FORMT"), RuleManager.instance().getCurrentRulesTitle()));
        boolean isCanceled = false;
        switch (confirm) {
            case 1: {
                RuleManager.instance().restoreCurrentDataSet();
                break;
            }
            case 2: {
                if (RuleManager.instance().isCurrentRuleIsStandard()) {
                    isCanceled = this.openSaveAsDialog(ruleButtonMap);
                    if (isCanceled) break;
                    this.setRules(RuleManager.instance().getStandartRuleSetName());
                    break;
                }
                RuleManager.instance().saveCurrentData();
                break;
            }
            default: {
                isCanceled = true;
            }
        }
        return isCanceled;
    }

    private void setDefaultItem(BaseDropDown rulesDrop, HashMap<String, JButton> ruleButtonMap, String tmpRuleName) {
        RuleManager.instance().setDafaultRuleSet(tmpRuleName);
        for (Map.Entry<String, JButton> ruleButton : ruleButtonMap.entrySet()) {
            String rule = ruleButton.getKey();
            JButton ruleDefaultButton = ruleButton.getValue();
            if (rule.equals(tmpRuleName)) {
                ruleDefaultButton.setText(DEFAULT_BUTTON_NAME);
                rulesDrop.setViseableItemComponent((JComponent)ruleDefaultButton, BaseItem.Visible.ALLWAYS);
                continue;
            }
            ruleDefaultButton.setText(MAKE_DEFAULT_BUTTON_NAME);
            rulesDrop.setViseableItemComponent((JComponent)ruleDefaultButton, BaseItem.Visible.MOUSEOVER_ONLY);
        }
    }

    @Override
    public boolean performNextOperation() {
        String str = (String)this.versionsDrop.getSelectedItem();
        String version = this.versionControl.getVersionValue(str);
        Params.instance().setGUIVersion(version);
        boolean toRet = true;
        if (Params.instance().isNewConversion()) {
            ConversionExecuter executer;
            Params.instance().setDatacenterName(this.DSControlM.getText());
            if (Params.instance().isZOS()) {
                Params.instance().setMFDatacenterName(this.ZOSControlM.getText());
            }
            if (toRet = (executer = new ConversionExecuter()).execute()) {
                FlowManager.instance().isConversionPerformed(true);
                Params.instance().setIsNewConversion(false);
            }
        }
        return toRet;
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        this.titlePanel.setTitle("\"" + ConversionEntitiesService.getCurrentConversionName() + "\" " + TextManager.instance().get("CONVERSION_PANEL_TITLE_CONVERSION_SETTING"));
        if (Params.instance().isNewConversion()) {
            RuleManager.instance().init();
            this.rulesDrop.setSelectedItem(RuleManager.instance().getCurrentRulesName());
            if (this.rulesExpander.isExpande()) {
                this.rulesExpander.toggle();
            }
            this.versionsDrop.addValueChangedAction();
        } else {
            RuleManager.instance().viewDataSetFromFile(ConversionEntitiesService.getCurrentConversionRulesFile());
            this.rulesDrop.setTextEditor(RuleManager.getRuleSetTitle((File)new File(ConversionEntitiesService.getCurrentConversionRulesFile())));
            this.versionsDrop.removeValueChangedAction();
        }
        this.versionsDrop.setSelectedItem((Object)this.versionControl.getCurrentVersion());
        boolean isEnabled = Params.instance().isNewConversion();
        this.versionsDrop.setEnabled(isEnabled);
        this.rulesDrop.setEnabled(isEnabled);
        this.saveAsButton.setVisible(isEnabled);
        this.saveButton.setVisible(isEnabled);
        this.DSControlM.setText(Params.instance().getDatacenterName());
        this.DSControlM.setEnabled(isEnabled);
        if (Params.instance().isZOS()) {
            this.ZOSControlM.setText(Params.instance().getMFDatacenterName());
            this.ZOSControlM.setEnabled(isEnabled);
        }
        return true;
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.CONVERSION_SETTING;
    }

    @Override
    public String getHelpTitle() {
        if (this.rulesExpander.isExpande()) {
            return RuleManager.instance().getHelpTitle();
        }
        return "CONVERSION_SETTINGS";
    }
}

