/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flow;

import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.draftwriter.VersionControl;

public class EmDetailsExtractor {
    private final String emPath = "HKEY_LOCAL_MACHINE\\SOFTWARE\\BMC Software\\Control-M\\Control-M/Enterprise Manager\\";
    private final String productVersionFilter = "Product Version";
    private final String productInstallDirFilter = "Product Install Dir";
    private final String queryAnswerSep = "REG_SZ";

    public boolean isEmExist() {
        String emPath = this.getEmPath();
        return !emPath.equals("");
    }

    public String getEmPath() {
        String toRet = "";
        String versionFullName = VersionControl.getcurrentFullVersion();
        String versionFolderName = VersionControl.getVersionInWindowsRegistry();
        String cmdStr = String.format("reg QUERY \"%s%s\"", "HKEY_LOCAL_MACHINE\\SOFTWARE\\BMC Software\\Control-M\\Control-M/Enterprise Manager\\", versionFolderName);
        ExternalCommand extCmd = new ExternalCommand.Builder(new String[]{cmdStr}).waitFor(true).isScript(true).build();
        extCmd.start();
        if (extCmd.getExitValue() == 0) {
            String[] subFolders;
            String queryOutput = extCmd.getOutputStdOut().trim();
            for (String folderPath : subFolders = queryOutput.split("\\r?\\n")) {
                String actualVersion = this.extractDataByFilter(folderPath = folderPath.trim(), "Product Version");
                if (actualVersion.contains(versionFullName) && !(toRet = this.extractDataByFilter(folderPath, "Product Install Dir").trim()).equals("")) break;
            }
        }
        return toRet;
    }

    private String extractDataByFilter(String folderPath, String filter) {
        String toRet = "";
        String cmdStr = String.format("reg QUERY \"%s\" /v \"%s\"", folderPath, filter);
        ExternalCommand extCmd = new ExternalCommand.Builder(new String[]{cmdStr}).waitFor(true).isScript(true).build();
        extCmd.start();
        if (extCmd.getExitValue() == 0) {
            toRet = extCmd.getOutputStdOut().split("REG_SZ")[1].trim();
        }
        return toRet;
    }
}

