/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

public class VariableDetails {
    private static final String ID_PATTERN = "\\d+";
    private static final String FORMAT_PATTERN = "\\..*";
    private static final String ID_AND_FORMAT = "\\d+\\..*";
    private static final String DOT_PATTERN = "\\.";
    private String name;
    private String id;
    private String format;
    private final String variableReference;

    public VariableDetails(String variableReference) {
        this.variableReference = variableReference;
        this.parseVariableParts();
    }

    private void parseVariableParts() {
        int DOES_NOT_EXIST = -1;
        if (this.variableReference.indexOf(".") == -1) {
            this.hasOnlyOnePart();
        } else {
            this.hasTwoOrThreeParts();
        }
    }

    private void hasOnlyOnePart() {
        this.init(this.variableReference, "", "");
    }

    private void init(String name, String id, String format) {
        this.name = name;
        this.id = id;
        this.format = format;
    }

    private void hasTwoOrThreeParts() {
        boolean AFTER_FIRST_DOT = true;
        int SPLIT_ON_FIRST_DOT = 2;
        String[] variableReferenceParts = this.variableReference.split(DOT_PATTERN, 2);
        if (variableReferenceParts[1].matches(ID_AND_FORMAT)) {
            this.hasNameAndIdAndFormat();
        } else if (variableReferenceParts[1].matches(ID_PATTERN)) {
            this.hasNameAndId(variableReferenceParts);
        } else {
            this.hasNameAndFormat(variableReferenceParts);
        }
    }

    private void hasNameAndIdAndFormat() {
        int SPLIT_FIRST_TWO_DOTS = 3;
        boolean NAME = false;
        boolean ID = true;
        int FORMAT = 2;
        String[] variableReferenceParts = this.variableReference.split(DOT_PATTERN, 3);
        this.init(variableReferenceParts[0], variableReferenceParts[1], variableReferenceParts[2]);
    }

    private void hasNameAndFormat(String[] variableReferenceParts) {
        boolean NAME = false;
        boolean FORMAT = true;
        this.name = variableReferenceParts[0];
        this.id = "";
        this.format = variableReferenceParts[1];
    }

    private void hasNameAndId(String[] variableReferenceParts) {
        boolean NAME = false;
        boolean ID = true;
        this.name = variableReferenceParts[0];
        this.id = variableReferenceParts[1];
        this.format = "";
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public int getIdAsInt() {
        int id;
        try {
            id = Integer.parseInt(this.getId());
        }
        catch (NumberFormatException e) {
            id = 0;
        }
        return id;
    }

    public String getFormat() {
        return this.format;
    }

    public String getVariableReference() {
        return this.variableReference;
    }
}

