/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.VarMstTable;
import com.bmc.ctmconvert.tidal.variables.FormatHelper;
import com.bmc.ctmconvert.tidal.variables.OffsetHelper;
import com.bmc.ctmconvert.tidal.variables.SystemVariable;
import com.bmc.ctmconvert.tidal.variables.VariableDetails;

public class VariableClassifier {
    private static final String VALID_VARIABLE_REFERENCE = "^(.*?)\\.(?!.*p)(\\d*)?\\.?(.*)$";
    static final String[] supportedVarMstStartTypes = new String[]{"PROD_DATE", "SCH_DATE", ""};
    private String variableReference;
    private VariableDetails variable;
    private IAttrHolder varmst_entry;
    private FormatHelper formatHelper;
    private OffsetHelper offsetHelper;

    public VariableClassifier(String variableReference) {
        this.variableReference = variableReference;
        this.variable = new VariableDetails(variableReference);
        this.formatHelper = new FormatHelper(this.variable.getFormat());
        if (this.hasID()) {
            this.initVarMstEntryOrThrowIfIdNotFound();
            this.offsetHelper = new OffsetHelper(this.varmst_entry.getAttr("VARMST_OFFSETS"));
        }
    }

    boolean hasID() {
        return this.variable.getId().matches("\\d+");
    }

    private void initVarMstEntryOrThrowIfIdNotFound() {
        int variableID = this.variable.getIdAsInt();
        AttrHolderList varMstRow = VarMstTable.instance().getJobResources(variableID);
        if (varMstRow == null) {
            throw new VariableIdNotFoundException(String.format("Variable ID: '%d' was not found in VARMST table (variable reference: '%s')", variableID, this.variableReference));
        }
        this.varmst_entry = (IAttrHolder)varMstRow.get(0);
    }

    public boolean isValidVariable() {
        return this.variableReference.matches(VALID_VARIABLE_REFERENCE);
    }

    public boolean isUnsupportedVariable() {
        return !this.isSupportedVariable();
    }

    public boolean isSupportedVariable() {
        return this.isSupportedSystemVariable() || this.isSupportedDateVariable();
    }

    public boolean isSupportedSystemVariable() {
        boolean isSystemVariable = false;
        for (String systemVariablePrefix : SystemVariable.getSupportedSystemVariables()) {
            if (!this.variable.getName().equalsIgnoreCase(systemVariablePrefix)) continue;
            isSystemVariable = true;
            break;
        }
        return isSystemVariable && this.hasSupportedDateOrTimeFormat();
    }

    private boolean hasSupportedDateOrTimeFormat() {
        return this.getFormatHelper().isSupportedDateOrTimeFormat();
    }

    public boolean isSupportedDateVariable() {
        return this.hasID() && this.hasSupportedDateOrTimeFormat() && this.offsetHelper.isOffsetSupported() && this.isStartTypeSupported() && this.isTidalDateTypeVariable() && (!this.offsetHelper.hasOffset() || !this.formatHelper.hasJulianFormat());
    }

    private boolean isStartTypeSupported() {
        return VariableClassifier.isStartTypeSupported(this.varmst_entry.getAttr("VARMST_STARTTYPE"));
    }

    static boolean isStartTypeSupported(String startType) {
        boolean isStartTypeSupported = false;
        for (String supportedStartType : supportedVarMstStartTypes) {
            if (!startType.equalsIgnoreCase(supportedStartType)) continue;
            isStartTypeSupported = true;
            break;
        }
        return isStartTypeSupported;
    }

    private boolean isTidalDateTypeVariable() {
        return this.varmst_entry.getAttr("VARMST_TYPE").equals("3");
    }

    public IAttrHolder getVarmst_entry() {
        return this.varmst_entry;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }

    public OffsetHelper getOffsetHelper() {
        return this.offsetHelper;
    }

    public String getVariableReference() {
        return this.variableReference;
    }

    public VariableDetails getVariableDetails() {
        return this.variable;
    }

    public static class VariableIdNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 4698111361710428848L;

        public VariableIdNotFoundException(String message) {
            super(message);
        }
    }
}

