/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.tidal.variables.AbstractVariable;
import com.bmc.ctmconvert.tidal.variables.FormatHelper;
import com.bmc.ctmconvert.tidal.variables.VariableClassifier;
import com.bmc.ctmconvert.tidal.variables.VariableNamer;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SystemVariable
extends AbstractVariable {
    private static final Map<String, String> tidalToCtmVariableMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> dateVariables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> timeVariables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    SystemVariable(VariableClassifier variableClassifier, VariableNamer variableNamer) {
        super(variableClassifier, variableNamer);
    }

    private static void addDateVariables() {
        SystemVariable.addDateVariable("SysDate", "%%$DATE");
        SystemVariable.addDateVariable("ProdDate", "%%$DATE");
        SystemVariable.addDateVariable("JobDate", "%%$ODATE");
    }

    private static void addDateVariable(String tidalVariableName, String replacementAutoedit) {
        tidalToCtmVariableMap.put(tidalVariableName, replacementAutoedit);
        dateVariables.add(tidalVariableName);
    }

    private static void addTimeVariables() {
        SystemVariable.addTimeVariable("SysTime", "%%TIME");
        SystemVariable.addTimeVariable("JobStart", "%%TIME");
    }

    private static void addTimeVariable(String tidalVariableName, String replacementAutoedit) {
        tidalToCtmVariableMap.put(tidalVariableName, replacementAutoedit);
        timeVariables.add(tidalVariableName);
    }

    private static void addJobVariables() {
        tidalToCtmVariableMap.put("JobID", "%%ORDERID_%%RUNCOUNT");
    }

    public static String[] getSupportedSystemVariables() {
        return tidalToCtmVariableMap.keySet().toArray(new String[0]);
    }

    @Override
    protected void createAssistingAutoedits() {
        FormatHelper formatHelper = this.variableClassifier.getFormatHelper();
        String systemAutoeditValue = tidalToCtmVariableMap.get(this.variableDetails.getName());
        if (systemAutoeditValue == null) {
            ConversionLogger.getLogger().warning("We should never have got here [SystemVariable.createAssistingAutoedits()]");
            systemAutoeditValue = "";
        }
        this.autoedits.put("%%RESULT", systemAutoeditValue);
        if (this.containsTimeVariable()) {
            this.addTimeFormatAutoedits(formatHelper);
        } else if (this.containsDateVariables()) {
            this.addDateFormatAutoedits(formatHelper);
        }
        this.setReplacementAutoeditValue(formatHelper.getResultDateTimeFormat());
    }

    private boolean containsTimeVariable() {
        return timeVariables.contains(this.variableDetails.getName());
    }

    private void addTimeFormatAutoedits(FormatHelper formatHelper) {
        this.autoedits.putAll(formatHelper.createTimeFormatAutoedits());
    }

    private boolean containsDateVariables() {
        return dateVariables.contains(this.variableDetails.getName());
    }

    private void addDateFormatAutoedits(FormatHelper formatHelper) {
        this.autoedits.putAll(formatHelper.createDateFormatAutoedits());
    }

    @Override
    public String getReplacementAutoeditName() {
        return this.replacementAutoeditName;
    }

    @Override
    public void setReplacementAutoeditName(String name) {
        this.replacementAutoeditName = name;
    }

    static {
        SystemVariable.addDateVariables();
        SystemVariable.addTimeVariables();
        SystemVariable.addJobVariables();
    }
}

