/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import com.bmc.ctmconvert.tidal.variables.AbstractVariable;
import com.bmc.ctmconvert.tidal.variables.FormatHelper;
import com.bmc.ctmconvert.tidal.variables.OffsetHelper;
import com.bmc.ctmconvert.tidal.variables.VariableClassifier;
import com.bmc.ctmconvert.tidal.variables.VariableNamer;

public class DateVariable
extends AbstractVariable {
    private static final String LONG_DATE_AUTOEDIT = "%%$DATE";
    private String variableInitialValue;

    DateVariable(VariableClassifier variableClassifier, VariableNamer variableNamer) {
        super(variableClassifier, variableNamer);
    }

    @Override
    protected void createAssistingAutoedits() {
        String tidalVariableName = this.variableClassifier.getVarmst_entry().getAttr("VARMST_NAME");
        this.handleInitialValue(tidalVariableName);
        this.createAutoedits();
    }

    private void handleInitialValue(String tidalVariableName) {
        this.variableInitialValue = LONG_DATE_AUTOEDIT;
    }

    private void createAutoedits() {
        OffsetHelper offsetHelper = this.variableClassifier.getOffsetHelper();
        FormatHelper formatHelper = this.variableClassifier.getFormatHelper();
        this.autoedits.put("%%INPUT", this.variableInitialValue);
        this.autoedits.put("%%OFFSET_VALUE", String.format("%d", Math.abs(offsetHelper.getOffset())));
        this.autoedits.put("%%RESULT", String.format("%%%%$CALCDATE %%%%INPUT %s%%%%OFFSET_VALUE", offsetHelper.getOperation().toString()));
        this.autoedits.putAll(formatHelper.createDateFormatAutoedits());
        this.setReplacementAutoeditValue(formatHelper.getResultDateTimeFormat());
    }

    @Override
    public String getReplacementAutoeditName() {
        return this.replacementAutoeditName;
    }

    @Override
    public void setReplacementAutoeditName(String name) {
        this.replacementAutoeditName = name;
    }
}

