/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ConstantVariables {
    private static final int HOURS_IN_DAY = 24;
    private static final int DAYS_IN_MONTH = 31;
    public static final String SHORT_MONTH_PREFIX = "MMM";
    public static final String LONG_MONTH_PREFIX = "MMMM";
    public static final String NUMBER_PREFIX = "NUMBER";
    public static final String AM_PM_PREFIX = "AP";
    public static final String SHORT_HOUR_PREFIX = "H";
    public static final String LONG_HOUR_PREFIX = "HL";
    public static final String SHORT_WEEKDAYS_PREFIX = "SHORT_WEEKDAY";
    public static final String LONG_WEEKDAYS_PREFIX = "LONG_WEEKDAY";
    public static final String TWO_DIGIT_JULIAN_PREFIX = "TWO_DIGIT_JULDAY";

    public static Set<Map.Entry<String, String>> getGlobalDateFormatAutoedits() {
        LinkedHashMap<String, String> autoedits = new LinkedHashMap<String, String>();
        ConstantVariables.addShortMonths(autoedits);
        ConstantVariables.addLongMonths(autoedits);
        ConstantVariables.addNumbersForAllDaysInMonth(autoedits);
        ConstantVariables.addAM_PM_Variables(autoedits);
        ConstantVariables.addShortHours(autoedits);
        ConstantVariables.addLongHours(autoedits);
        return autoedits.entrySet();
    }

    private static void addShortWeekdays(Map<String, String> autoedits) {
        autoedits.put("SHORT_WEEKDAY0", "Sun");
        autoedits.put("SHORT_WEEKDAY1", "Mon");
        autoedits.put("SHORT_WEEKDAY2", "Tue");
        autoedits.put("SHORT_WEEKDAY3", "Wed");
        autoedits.put("SHORT_WEEKDAY4", "Thu");
        autoedits.put("SHORT_WEEKDAY5", "Fri");
        autoedits.put("SHORT_WEEKDAY6", "Sat");
    }

    private static void addLongWeekdays(Map<String, String> autoedits) {
        autoedits.put("LONG_WEEKDAY0", "Sunday");
        autoedits.put("LONG_WEEKDAY1", "Monday");
        autoedits.put("LONG_WEEKDAY2", "Tuesday");
        autoedits.put("LONG_WEEKDAY3", "Wednesday");
        autoedits.put("LONG_WEEKDAY4", "Thursday");
        autoedits.put("LONG_WEEKDAY5", "Friday");
        autoedits.put("LONG_WEEKDAY6", "Saturday");
    }

    private static void addLongHours(Map<String, String> variables) {
        variables.put("HL00", "12");
        for (int hour = 1; hour < 24; ++hour) {
            String variableName = String.format("%s%02d", LONG_HOUR_PREFIX, hour);
            if (hour <= 12) {
                variables.put(variableName, String.format("%02d", hour));
                continue;
            }
            variables.put(variableName, String.format("%02d", hour - 12));
        }
    }

    private static void addShortHours(Map<String, String> variables) {
        variables.put("H00", "12");
        for (int hour = 1; hour < 24; ++hour) {
            String variableName = String.format("%s%02d", SHORT_HOUR_PREFIX, hour);
            if (hour <= 12) {
                variables.put(variableName, String.valueOf(hour));
                continue;
            }
            variables.put(variableName, String.valueOf(hour - 12));
        }
    }

    private static void addAM_PM_Variables(Map<String, String> variables) {
        for (int hour = 0; hour < 24; ++hour) {
            String variableName = String.format("%s%02d", AM_PM_PREFIX, hour);
            if (hour < 12) {
                variables.put(variableName, "AM");
                continue;
            }
            variables.put(variableName, "PM");
        }
    }

    private static void addNumbersForAllDaysInMonth(Map<String, String> variables) {
        for (int number = 0; number <= 31; ++number) {
            String variableName = String.format("%s%02d", NUMBER_PREFIX, number);
            variables.put(variableName, String.valueOf(number));
        }
    }

    private static void addLongMonths(Map<String, String> variables) {
        variables.put("MMMM01", "January");
        variables.put("MMMM02", "February");
        variables.put("MMMM03", "March");
        variables.put("MMMM04", "April");
        variables.put("MMMM05", "May");
        variables.put("MMMM06", "June");
        variables.put("MMMM07", "July");
        variables.put("MMMM08", "August");
        variables.put("MMMM09", "September");
        variables.put("MMMM10", "October");
        variables.put("MMMM11", "November");
        variables.put("MMMM12", "December");
    }

    private static void addShortMonths(Map<String, String> variables) {
        variables.put("MMM01", "Jan");
        variables.put("MMM02", "Feb");
        variables.put("MMM03", "Mar");
        variables.put("MMM04", "Apr");
        variables.put("MMM05", "May");
        variables.put("MMM06", "Jun");
        variables.put("MMM07", "Jul");
        variables.put("MMM08", "Aug");
        variables.put("MMM09", "Sep");
        variables.put("MMM10", "Oct");
        variables.put("MMM11", "Nov");
        variables.put("MMM12", "Dec");
    }
}

