/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import com.bmc.ctmconvert.tidal.variables.Variable;
import com.bmc.ctmconvert.tidal.variables.VariableClassifier;
import com.bmc.ctmconvert.tidal.variables.VariableDetails;
import com.bmc.ctmconvert.tidal.variables.VariableNamer;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractVariable
implements Variable {
    private static AtomicLong NEXT_ID = new AtomicLong(0L);
    private final long internalID = NEXT_ID.getAndIncrement();
    VariableClassifier variableClassifier;
    VariableDetails variableDetails;
    LinkedHashMap<String, String> autoedits;
    String replacementAutoeditName;
    private VariableNamer variableNamer;

    protected AbstractVariable(VariableClassifier variableClassifier, VariableNamer variableNamer) {
        this.variableNamer = variableNamer;
        this.variableClassifier = variableClassifier;
        this.variableDetails = variableClassifier.getVariableDetails();
        this.autoedits = new LinkedHashMap();
        this.initReplacementAutoeditName();
        this.createAssistingAutoedits();
        this.concatenateIdToAutoedits();
    }

    private void concatenateIdToAutoedits() {
        LinkedHashMap<String, String> modifiedAutoedits = new LinkedHashMap<String, String>();
        for (String originalAutoeditName : this.autoedits.keySet()) {
            String originalAutoeditValue = this.autoedits.get(originalAutoeditName);
            String modifiedAutoeditName = this.concatenateIdTo(originalAutoeditName);
            String modifiedAutoeditValue = this.concatenateIdTo(originalAutoeditValue);
            if (originalAutoeditName.equals(this.getReplacementAutoeditName())) {
                modifiedAutoedits.put(originalAutoeditName, modifiedAutoeditValue);
                continue;
            }
            modifiedAutoedits.put(modifiedAutoeditName, modifiedAutoeditValue);
        }
        this.autoedits = modifiedAutoedits;
    }

    private String validate(String originalAutoeditName) {
        VariableNamer.Validator validator = originalName -> FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", originalName.trim());
        return this.variableNamer.getNameFor(originalAutoeditName, validator, String.valueOf(this.internalID));
    }

    protected String concatenateIdTo(String autoeditValue) {
        String valueAfterConcatenation = autoeditValue;
        for (String autoeditName : this.autoedits.keySet()) {
            valueAfterConcatenation = this.appendIdToSingleAutoedit(valueAfterConcatenation, autoeditName);
        }
        return valueAfterConcatenation;
    }

    private String appendIdToSingleAutoedit(String originalAutoeditValue, String autoeditToChange) {
        String autoeditEndLookahead = "(?=$| |\\.)";
        String autoeditWithAppendedInternalID = this.validate(this.appendUniqueID(autoeditToChange + "_"));
        Matcher matcher = Pattern.compile(Pattern.quote(autoeditToChange) + autoeditEndLookahead).matcher(originalAutoeditValue);
        return matcher.replaceAll(Matcher.quoteReplacement(autoeditWithAppendedInternalID));
    }

    private String appendUniqueID(String autoeditToChange) {
        StringBuilder builder = new StringBuilder(autoeditToChange);
        builder = this.appendID(builder);
        builder = this.appendFormat(builder);
        builder = this.appendVariableName(builder);
        return builder.toString();
    }

    private StringBuilder appendFormat(StringBuilder builder) {
        if (!this.variableDetails.getFormat().isEmpty()) {
            builder.append(this.variableDetails.getFormat()).append("_");
        }
        return builder;
    }

    private StringBuilder appendVariableName(StringBuilder builder) {
        return builder.append(this.variableDetails.getName());
    }

    private StringBuilder appendID(StringBuilder builder) {
        if (this.variableClassifier.hasID()) {
            this.appendUnderscoreIfStartsWithAnumber(builder);
            builder.append(this.variableDetails.getId()).append("_");
        }
        return builder;
    }

    private void appendUnderscoreIfStartsWithAnumber(StringBuilder builder) {
        int AUTOEDIT_PREFIX_LENGTH = 2;
        if (builder.length() <= AUTOEDIT_PREFIX_LENGTH) {
            builder.append("_");
        }
    }

    private void initReplacementAutoeditName() {
        String autoeditName = this.validate(this.appendUniqueID("%%"));
        this.setReplacementAutoeditName(autoeditName);
    }

    protected abstract void createAssistingAutoedits();

    @Override
    public abstract String getReplacementAutoeditName();

    public abstract void setReplacementAutoeditName(String var1);

    @Override
    public String getReplacementAutoeditValue() {
        return this.autoedits.get(this.getReplacementAutoeditName());
    }

    protected String setReplacementAutoeditValue(String value) {
        return this.autoedits.put(this.getReplacementAutoeditName(), value);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public final LinkedHashMap<String, String> getAssistingAutoedits() {
        return this.autoedits;
    }

    public static void clearInternalID() {
        NEXT_ID = new AtomicLong(0L);
    }
}

