/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.utils;

import com.bmc.ctmconvert.common.DateUtils;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.time.LocalDate;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ConvertDateUtils {
    private static final String TIDAL_DB_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    private static final String TIDAL_SHORT_DB_DATE_FORMAT = "MM/dd/yyyy";

    public static LocalDate tryConvertDate(String date) {
        return ConvertDateUtils.tryConvertDateInEpochFormat(date).or(() -> ConvertDateUtils.tryToConvertTidalShortDateFormat(date)).orElse(ConvertDateUtils.tryToConvertTidalDateFormat(date));
    }

    private static LocalDate tryToConvertTidalDateFormat(String date) {
        return DateUtils.stringToLocalDateTransformer((String)date, (String)TIDAL_DB_DATE_FORMAT);
    }

    private static Optional<LocalDate> tryToConvertTidalShortDateFormat(String date) {
        return Optional.ofNullable(DateUtils.stringToLocalDateTransformer((String)date, (String)TIDAL_SHORT_DB_DATE_FORMAT));
    }

    private static LocalDate getEpochBaseDate() {
        return LocalDate.of(1899, 12, 30);
    }

    private static Optional<LocalDate> tryConvertDateInEpochFormat(String date) {
        Predicate<String> isValidFormat = s -> s.matches("\\d+(\\.\\d*)?");
        UnaryOperator extractDate = s -> s.contains(".") ? s.substring(0, s.indexOf(46)) : s;
        LocalDate baseDate = ConvertDateUtils.getEpochBaseDate();
        return Optional.ofNullable(date).filter(isValidFormat).map(extractDate).flatMap(GlobalFunctions::getNumberFrom).map(baseDate::plusDays);
    }
}

