/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.sap;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.sap.SapR3CreateStepLanguageMapper;
import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TidalSAPR3CreateConvertor
extends TidalXmlCmConvertor {
    private int stepCount = 0;
    private static final Map<String, String> elementPatternToDefaultValue = TidalSAPR3CreateConvertor.generateElementPatternToDefaultValueMap();
    private static final String SAP_STEP_TRG_HOST_FORMAT = "%%%%SAPR3-STEP-S%02d-TARGET_HOST";
    private static final String SAP_STEP_LAYOUT_FORMAT = "%%%%SAPR3-STEP-S%02d-PRINT_LAYOUT";
    private static final String SAP_STEP_RPINT_RECIPIENT_FORMAT = "%%%%SAPR3-STEP-S%02d-PRINT_RECIPIENT";
    private static final String SAP_STEP_PRINT_DEPARTMENT_FORMAT = "%%%%SAPR3-STEP-S%02d-DEPT";
    private static Map<String, String> paramsToAutoeditsMap = new HashMap<String, String>();
    private String convertedJobMessageID = "WRN2323";
    private HashMap<Integer, SAPStepType> stepsTypesMap = new HashMap();
    private static final Set<String> suppressedElements = new HashSet<String>();

    public TidalSAPR3CreateConvertor() {
        this.applForm = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_FORM");
        this.applType = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_TYPE");
        this.applVer = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_VER");
        this.cmVer = (String)Globs.SAP_TYPE_FORM_VERSION.get("CM_VER");
    }

    private static Map<String, String> generateElementPatternToDefaultValueMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("new", "N");
        return result;
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        return new HashSet<String>(suppressedElements);
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        HashMap<String, TidalXmlCmConvertor.NodeHandler> handledElementsMap = new HashMap<String, TidalXmlCmConvertor.NodeHandler>();
        handledElementsMap.put("sstps", this::initStepsTypesMap);
        handledElementsMap.put("stype\\d+", this::handleStepTypeNode);
        handledElementsMap.put("print\\d+", this::handlePrintNode);
        handledElementsMap.put("cop\\d+", this::printCopiesHandler);
        handledElementsMap.put("abap\\d+", this::handleABAPNode);
        handledElementsMap.put("inf\\d+", this::handleInfNode);
        handledElementsMap.put("objn\\d+", this::handleObjnNode);
        handledElementsMap.put("vvals\\d+", this::handleVvalsNode);
        handledElementsMap.put("ovar\\d+", this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-VAR-NAME"));
        handledElementsMap.put("svarm\\d+", this.generateNumberedStepFormatDirectHandler(SAP_STEP_TRG_HOST_FORMAT));
        handledElementsMap.put("lang\\d+", this::handleStepLanguage);
        handledElementsMap.put("des\\d+", this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-PRINT_DEST"));
        handledElementsMap.put("pas\\d+", this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-PRINT_AUTH"));
        handledElementsMap.put("sobj\\d+", this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-ARCHIVE_SAPOBJECT"));
        handledElementsMap.put("pas\\d+", this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-PRINT_AUTH"));
        handledElementsMap.put("runt\\d+", this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-LIST_TEXT"));
        handledElementsMap.put("pi\\d+", this.generateNumberedStepFormatForPrintImmediate("%%%%SAPR3-STEP-S%02d-PRINT_IMMED"));
        handledElementsMap.put("job", this::handleSAPJobnameNode);
        handledElementsMap.put("recipient", this::handleRecipientNode);
        handledElementsMap.put("rectype", this::handleRecipientTypeNode);
        handledElementsMap.put("copy", this::handleRecipientCopyNode);
        return handledElementsMap;
    }

    private void handleRecipientNode(Node node) {
        String textContent = node.getTextContent().trim();
        if (textContent != null && !textContent.isEmpty()) {
            this.autoeditToValue.put("%%SAPR3-RECIPIENT", textContent);
        }
    }

    private void handleStepLanguage(Node node) {
        String textContent = node.getTextContent().trim();
        if (textContent != null && !textContent.isEmpty()) {
            boolean isMappingExists;
            Optional<String> value = SapR3CreateStepLanguageMapper.stepLanguageMap.getOrDefault(textContent, Optional.of(textContent));
            this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-LANGU", this.stepCount), value.get());
            boolean bl = isMappingExists = value.get() != textContent;
            if (!isMappingExists) {
                this.registerMessage("WRN2344", Integer.toString(this.stepCount), textContent);
            }
        }
    }

    private void handleRecipientCopyNode(Node node) {
        String textContent = node.getTextContent().trim();
        if (textContent != null && !textContent.isEmpty()) {
            this.autoeditToValue.put("%%SAPR3-RECIP_COPY", "X");
        }
    }

    private void handleRecipientTypeNode(Node node) {
        String textContent;
        switch (textContent = node.getTextContent() != null ? node.getTextContent().trim().toUpperCase() : "") {
            case "C": {
                this.autoeditToValue.put("%%SAPR3-RECIP_TYPE", "C");
                break;
            }
            case "U": {
                this.autoeditToValue.put("%%SAPR3-RECIP_TYPE", "U");
                break;
            }
            default: {
                this.autoeditToValue.put("%%SAPR3-RECIP_TYPE", "B");
            }
        }
    }

    private void handleInfNode(Node n) {
        switch (this.stepsTypesMap.get(this.stepCount).ordinal()) {
            case 1: {
                this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-ARCHIVE_INFO").handleNode(n);
                break;
            }
            case 0: 
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void handleVvalsNode(Node n) {
        switch (this.stepsTypesMap.get(this.stepCount).ordinal()) {
            case 0: 
            case 2: {
                this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-VAR-NAME").handleNode(n);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void handleObjnNode(Node n) {
        switch (this.stepsTypesMap.get(this.stepCount).ordinal()) {
            case 1: {
                this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-ARCHIVE_OBJECT").handleNode(n);
                break;
            }
            case 0: 
            case 2: {
                this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-OPERSYS").handleNode(n);
                break;
            }
        }
    }

    private void handleABAPNode(Node n) {
        this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-PROGRAM").handleNode(n);
    }

    private void printCopiesHandler(Node node) {
        if (node != null) {
            String textContent = node.getTextContent();
            if (textContent == null || textContent != null && textContent.matches("\\s*")) {
                return;
            }
            if (textContent != null && textContent.equals("0")) {
                this.registerMessage("INF2028", Integer.toString(this.stepCount), textContent);
            } else {
                this.generateNumberedStepFormatDirectHandler("%%%%SAPR3-STEP-S%02d-PRINT_COPIES").handleNode(node);
            }
        }
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        return new HashMap<String, String>(paramsToAutoeditsMap);
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        return new HashSet<Pair<String, String>>();
    }

    @Override
    protected String getJobConvertedSuccessMessageID() {
        return this.convertedJobMessageID;
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.autoeditToValue.put("%%SAPR3-ACCOUNT", "DEFAULT_CONNECTION");
        this.autoeditToValue.put("%%SAPR3-JOBCLASS", "C");
        this.autoeditToValue.put("%%SAPR3-JOB_MODE", "CREATE");
        this.autoeditToValue.put("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        this.autoeditToValue.put("%%SAPR3-DETECT_OPTION", "1");
        this.autoeditToValue.put("%%SAPR3-JOBCOUNT", "FIRST_SCHEDULED");
        this.autoeditToValue.put("%%SAPR3-JOB_COUNT", "FIRST_SCHEDULED");
        this.autoeditToValue.put("%%SAPR3-JOBLOG", "*SYSOUT");
        this.autoeditToValue.put("%%SAPR3-SUBMIT_ASAP", "X");
        if (!this.autoeditToValue.containsKey("%%SAPR3-RECIP_COPY")) {
            this.autoeditToValue.put("%%SAPR3-RECIP_COPY", "N");
        }
        if (!this.autoeditToValue.containsKey("%%SAPR3-RECIP_TYPE")) {
            this.autoeditToValue.put("%%SAPR3-RECIP_TYPE", "B");
        }
        this.autoeditToValue.put("%%SAPR3-RECIP_BLIND_COPY", "N");
        this.autoeditToValue.put("%%SAPR3-RECIP_EXPRESS", "N");
        this.autoeditToValue.put("%%SAPR3-RECIP_NO_FORWARDING", "N");
        this.autoeditToValue.put("%%SAPR3-RERUN_FROM_POF", "N");
        this.autoeditToValue.put("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        this.autoeditToValue.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.autoeditToValue.put("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.autoeditToValue.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.autoeditToValue.put("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.autoeditToValue.put("%%SAPR3-INC_APP_STAT", "no");
        this.autoeditToValue.put("%%SAPR3-RERUN_STEP_NUM", "1");
    }

    private TidalXmlCmConvertor.NodeHandler generateNumberedStepFormatDirectHandler(String autoeditNameFormat) {
        return node -> {
            String textContent = node.getTextContent();
            if (textContent != null && !textContent.isEmpty()) {
                this.autoeditToValue.put(String.format(autoeditNameFormat, this.stepCount), node.getTextContent());
            }
        };
    }

    private TidalXmlCmConvertor.NodeHandler generateNumberedStepFormatForPrintImmediate(String printImmediateFormat) {
        return node -> {
            String textContent = node.getTextContent();
            if (textContent != null && textContent.equalsIgnoreCase("X")) {
                this.autoeditToValue.put(String.format(printImmediateFormat, this.stepCount), node.getTextContent().toUpperCase());
            }
            if (textContent != null && textContent.equals(" ")) {
                this.autoeditToValue.put(String.format(printImmediateFormat, this.stepCount), "N");
            }
        };
    }

    private void setPrintDetails(Node doc) {
        Node printNode = doc.getFirstChild();
        if (printNode.getNodeName().equals("print")) {
            NodeList childNodes = printNode.getChildNodes();
            block26: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node currentChildNode = childNodes.item(i);
                if (currentChildNode == null || currentChildNode.getNodeType() != 1) continue;
                String textContent = currentChildNode.getTextContent();
                String nodeName = currentChildNode.getNodeName().toLowerCase();
                if (textContent == null || textContent.isEmpty()) {
                    if (!elementPatternToDefaultValue.containsKey(nodeName)) continue;
                    textContent = elementPatternToDefaultValue.get(nodeName);
                }
                switch (nodeName) {
                    case "new": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", this.stepCount), this.getMultipleValueFromTidalValue(textContent));
                        continue block26;
                    }
                    case "spoolname": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_NAME", this.stepCount), textContent);
                        continue block26;
                    }
                    case "retain": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", this.stepCount), textContent.trim().equalsIgnoreCase("0") ? "9" : textContent);
                        continue block26;
                    }
                    case "rows": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES", this.stepCount), textContent.trim().equalsIgnoreCase("0") ? "-1" : textContent);
                        continue block26;
                    }
                    case "cols": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS", this.stepCount), textContent.trim().equalsIgnoreCase("0") ? "-1" : textContent);
                        continue block26;
                    }
                    case "format": {
                        this.autoeditToValue.put(String.format(SAP_STEP_LAYOUT_FORMAT, this.stepCount), textContent);
                        continue block26;
                    }
                    case "sapcover": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", this.stepCount), this.getMultipleValueFromTidalValue(textContent));
                        continue block26;
                    }
                    case "oscover": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", this.stepCount), this.getMultipleValueFromTidalValue(textContent));
                        continue block26;
                    }
                    case "selcover": {
                        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", this.stepCount), this.getMultipleValueFromTidalValue(textContent));
                        continue block26;
                    }
                    case "recip": {
                        this.autoeditToValue.put(String.format(SAP_STEP_RPINT_RECIPIENT_FORMAT, this.stepCount), textContent);
                        continue block26;
                    }
                    case "dept": {
                        this.autoeditToValue.put(String.format(SAP_STEP_PRINT_DEPARTMENT_FORMAT, this.stepCount), textContent);
                        continue block26;
                    }
                }
            }
        }
    }

    private String getMultipleValueFromTidalValue(String textContent) {
        String trimedTextContent;
        if (textContent != null && ((trimedTextContent = textContent.trim()).equals("X") || trimedTextContent.equals("D"))) {
            return trimedTextContent;
        }
        return "N";
    }

    private void handlePrintNode(Node node) {
        String textContent = node.getTextContent();
        if (textContent != null && !textContent.isEmpty()) {
            DocumentBuilder db = null;
            try {
                db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(textContent));
                try {
                    Document doc = db.parse(is);
                    this.setPrintDetails(doc);
                }
                catch (IOException | SAXException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            }
            catch (ParserConfigurationException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }

    private void handleSAPJobnameNode(Node sapJobnameNode) {
        String textContent = sapJobnameNode.getTextContent();
        if (textContent != null && !textContent.isEmpty()) {
            this.autoeditToValue.put("%%SAPR3-JOBNAME", textContent);
        }
    }

    private void handleStepTypeNode(Node stepTypeNode) {
        ++this.stepCount;
        SAPStepType currentStepType = this.stepsTypesMap.get(this.stepCount);
        this.setStepTypeAutoedit(currentStepType);
    }

    private void setStepTypeAutoedit(SAPStepType currentStepType) {
        switch (currentStepType.ordinal()) {
            case 0: {
                this.handleExternalProgramStep();
                break;
            }
            case 1: {
                this.handleABAPStepType();
                break;
            }
            case 2: {
                this.handleExternalCommand();
                break;
            }
        }
    }

    private void handleExternalCommand() {
        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", this.stepCount), "C");
    }

    private void handleABAPStepType() {
        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", this.stepCount), "A");
    }

    private void handleExternalProgramStep() {
        this.autoeditToValue.put(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", this.stepCount), "E");
    }

    private void initStepsTypesMap(Node node) {
        this.stepsTypesMap = new HashMap();
        int stepCount = 1;
        if (node != null && node.getNodeType() == 1) {
            NodeList children = ((Element)node).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node currentChild = children.item(i);
                String nodeName = currentChild.getNodeName();
                if (!nodeName.matches("stype\\d+")) continue;
                String stepTypeIntValue = currentChild.getTextContent();
                SAPStepType stepType = SAPStepType.UNKNOWN;
                switch (stepTypeIntValue) {
                    case "1": {
                        stepType = SAPStepType.R3_EXTPRG;
                        break;
                    }
                    case "2": {
                        stepType = SAPStepType.R3_ABAP;
                        break;
                    }
                    case "3": {
                        stepType = SAPStepType.R3_EXTCMD;
                        break;
                    }
                    default: {
                        stepType = SAPStepType.UNKNOWN;
                    }
                }
                this.stepsTypesMap.put(stepCount++, stepType);
            }
        }
    }

    static {
        suppressedElements.add("var.compound");
    }

    public static enum SAPStepType {
        R3_EXTPRG,
        R3_ABAP,
        R3_EXTCMD,
        UNKNOWN;

    }
}

