/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.sap;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class TidalSAPR3CopyConvertor
extends TidalXmlCmConvertor {
    private static Map<String, String> paramsToAutoeditsMap = new HashMap<String, String>();
    private String convertedJobMessageID = "WRN2323";
    private static final Set<String> suppressedElements = new HashSet<String>();

    public TidalSAPR3CopyConvertor() {
        this.applForm = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_FORM");
        this.applType = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_TYPE");
        this.applVer = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_VER");
        this.cmVer = (String)Globs.SAP_TYPE_FORM_VERSION.get("CM_VER");
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        return new HashSet<String>(suppressedElements);
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        HashMap<String, TidalXmlCmConvertor.NodeHandler> handledElementsMap = new HashMap<String, TidalXmlCmConvertor.NodeHandler>();
        handledElementsMap.put("cname", this::handleCNameNode);
        handledElementsMap.put("cjcount", this::handleCJCountNode);
        return handledElementsMap;
    }

    private void handleCNameNode(Node node) {
        String textContent = node.getTextContent();
        if (textContent != null && !textContent.isEmpty()) {
            this.autoeditToValue.put("%%SAPR3-JOBNAME", textContent);
        }
    }

    private void handleCJCountNode(Node n) {
        this.autoeditToValue.put("%%SAPR3-JOB_COUNT", "Specific_Job");
        String jobCount = n.getTextContent();
        if (jobCount.length() < 8) {
            jobCount = this.setJobCountWith8Charlength(jobCount);
        }
        this.autoeditToValue.put("%%SAPR3-JOBCOUNT", jobCount);
    }

    private String setJobCountWith8Charlength(String jobCount) {
        String jobCountFormated = ("00000000" + jobCount).substring(jobCount.length());
        return jobCountFormated;
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        return new HashMap<String, String>(paramsToAutoeditsMap);
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        return new HashSet<Pair<String, String>>();
    }

    @Override
    protected String getJobConvertedSuccessMessageID() {
        return this.convertedJobMessageID;
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.autoeditToValue.put("%%SAPR3-ACCOUNT", "DEFAULT_CONNECTION");
        this.autoeditToValue.put("%%SAPR3-JOBCLASS", "C");
        this.autoeditToValue.put("%%SAPR3-JOB_MODE", "RUN_COPY");
        this.autoeditToValue.put("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        this.autoeditToValue.put("%%SAPR3-DETECT_OPTION", "1");
        this.autoeditToValue.put("%%SAPR3-JOBLOG", "*SYSOUT");
        this.autoeditToValue.put("%%SAPR3-SUBMIT_ASAP", "X");
        this.autoeditToValue.put("%%SAPR3-RECIP_TYPE", "B");
        this.autoeditToValue.put("%%SAPR3-RECIP_BLIND_COPY", "N");
        this.autoeditToValue.put("%%SAPR3-RERUN_FROM_POF", "N");
        this.autoeditToValue.put("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        this.autoeditToValue.put("%%SAPR3-START_STEP", "1");
        this.autoeditToValue.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.autoeditToValue.put("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.autoeditToValue.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.autoeditToValue.put("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.autoeditToValue.put("%%SAPR3-INC_APP_STAT", "no");
        this.autoeditToValue.put("%%SAPR3-RERUN_STEP_NUM", "1");
    }

    static {
        suppressedElements.add("var.compound");
    }
}

