/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.nodegroup;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class NodeGroup {
    private IAttrHolder m_nodlstms = null;
    private RecordsHolder nodlstmstTable;
    private RecordsHolder nodlstdtTable;
    private RecordsHolder nodmstTable;

    public NodeGroup(IAttrHolder nodlstms_record, RecordsHolder nodlstmstTable) {
        this(nodlstms_record, nodlstmstTable, Params.instance().getDatasourcePath() + "NODLSTDT.csv", Params.instance().getDatasourcePath() + "NODMST.csv");
    }

    public NodeGroup(IAttrHolder nodlstms_record, RecordsHolder nodlstmstTable, String nodlstdtPath, String nodmstPath) {
        this(nodlstms_record, nodlstmstTable, new RecordsHolder(nodlstdtPath, "NODLSTDTL_ID"), new RecordsHolder(nodmstPath, "NODMST_ID"));
    }

    public NodeGroup(IAttrHolder nodlstms_record, RecordsHolder nodlstmstTable, RecordsHolder nodlstdtTable, RecordsHolder nodmstTable) {
        this.m_nodlstms = nodlstms_record;
        this.nodlstmstTable = nodlstmstTable;
        this.nodlstdtTable = nodlstdtTable;
        this.nodmstTable = nodmstTable;
    }

    public String name() {
        String origName = this.m_nodlstms.getAttr("NODLSTMST_NAME");
        if (origName == null || origName.isEmpty()) {
            return "";
        }
        return origName;
    }

    public boolean isWindows() {
        return this.m_nodlstms.getAttrAsInt("NODLSTMST_OSTYPE") == 1;
    }

    public Set<String> getMembers() {
        Set<Integer> membersIds = this.getMembersIds();
        return this.convertToNames(membersIds);
    }

    private Set<Integer> getMembersIds() {
        String nodeGroupID = this.getNodeGroupID();
        HashSet<Integer> members = new HashSet<Integer>();
        members.addAll(this.getDirectMembers(nodeGroupID));
        members.addAll(this.getNestedMembers(nodeGroupID));
        return members;
    }

    private String getNodeGroupID() {
        return this.m_nodlstms.getAttr("NODLSTMST_ID");
    }

    private Set<Integer> getDirectMembers(String nodeGroupID) {
        return this.nodlstdtTable.getAllRecords().stream().filter(nodeGroup -> nodeGroup.getAttr("NODLSTMST_ID").equals(nodeGroupID)).map(nodeGroup -> nodeGroup.getAttrAsInt("NODMST_ID")).collect(Collectors.toSet());
    }

    private Set<Integer> getNestedMembers(String nodeGroupID) {
        HashSet<Integer> members = new HashSet<Integer>();
        this.nodlstmstTable.getAllRecords().stream().filter(nodeGroup -> nodeGroup.getAttr("NODLSTMST_PRNTID").equals(nodeGroupID)).forEach(nodeGroup -> members.addAll(new NodeGroup((IAttrHolder)nodeGroup, this.nodlstmstTable, this.nodlstdtTable, this.nodmstTable).getMembersIds()));
        return members;
    }

    private Set<String> convertToNames(Set<Integer> membersIds) {
        return membersIds.stream().map(memberId -> this.nodmstTable.get(memberId.intValue())).filter(memberId -> memberId != null).map(member -> member.getAttr("NODMST_NAME")).map(memberName -> FieldValidation.instance().validateAndReturnFixedValue("NODEID", memberName)).collect(Collectors.toSet());
    }

    public Set<Integer> getMissingMembers() {
        Set<Integer> membersIds = this.getMembersIds();
        return membersIds.stream().filter(memberId -> this.nodmstTable.get(memberId.intValue()) == null).collect(Collectors.toSet());
    }
}

