/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.ftp;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.AbstractTidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import com.bmc.ctmconvert.tidal.ftp.TidalFTPCommand;
import com.bmc.ctmconvert.tidal.ftp.TidalFTPDetails;

public class TidalFTPConvertor
extends AbstractTidalCmConvertor {
    private static final String DEFAULT_FTP_OS = "Unix";
    private TidalFTPDetails ftpDetails;
    private TidalJob job;

    public TidalFTPConvertor(TidalJob job) {
        this.job = job;
        this.applType = "FILE_TRANS";
        this.applVer = "7.0.00.110";
        this.applForm = "AFT";
        this.cmVer = "N/A";
    }

    @Override
    public void convertCmValues(IAttrHolder jobDtlRecord) {
        if (jobDtlRecord != null) {
            this.ftpDetails = new TidalFTPDetails(jobDtlRecord, this.job.getNodeid(), this.job.runningOnWindows());
            this.setAFTDefaultAutoedits();
            this.setAFTTransferAutoedits();
            this.setAFTLeftSideAutoedits();
            this.setAFTRightSideAutoedits();
            TidalFTPCommand ftp_COMMAND = this.ftpDetails.getFtpParams().getFTP_COMMAND();
            if (ftp_COMMAND.equals((Object)TidalFTPCommand.LIST)) {
                this.registerMessage("WRN2329", this.job.getOriginalJobName());
            } else if (ftp_COMMAND.equals((Object)TidalFTPCommand.UNKNOWN)) {
                this.registerMessage("WRN2330", this.job.getOriginalJobName(), Integer.toString(this.ftpDetails.getFtpParams().getCommandInt()));
            }
        }
    }

    private void setAFTLeftSideAutoedits() {
        TidalFTPCommand ftp_COMMAND = this.ftpDetails.getFtpParams().getFTP_COMMAND();
        String leftSidePath = this.ftpDetails.getLeftSidePath();
        this.autoeditToValue.put("%%FTP-CONNTYPE1", "FTP");
        this.autoeditToValue.put("%%FTP-LHOST", this.ftpDetails.getFtpParams().getRemoteHost());
        if (ftp_COMMAND == TidalFTPCommand.GET || ftp_COMMAND == TidalFTPCommand.MGET) {
            leftSidePath = this.ftpDetails.getLeftSideWithFilename();
        }
        this.autoeditToValue.put("%%FTP-LPATH1", leftSidePath);
        this.autoeditToValue.put("%%FTP-LUSER", this.ftpDetails.getRemoteUser());
        this.autoeditToValue.put("%%FTP-LPASSIVE", "0");
        this.autoeditToValue.put("%%FTP-LOSTYPE", DEFAULT_FTP_OS);
    }

    private void setAFTRightSideAutoedits() {
        TidalFTPCommand ftp_COMMAND = this.ftpDetails.getFtpParams().getFTP_COMMAND();
        String rightSidePath = this.ftpDetails.getRightSidePath();
        this.autoeditToValue.put("%%FTP-CONNTYPE2", "LOCAL");
        this.autoeditToValue.put("%%FTP-RHOST", this.ftpDetails.getLocalHost());
        if (ftp_COMMAND == TidalFTPCommand.PUT || ftp_COMMAND == TidalFTPCommand.MPUT) {
            rightSidePath = this.ftpDetails.getRightSideWithFilename();
        }
        this.autoeditToValue.put("%%FTP-RPATH1", rightSidePath);
        this.autoeditToValue.put("%%FTP-RUSER", this.job.getOwner());
        this.autoeditToValue.put("%%FTP-RPASSIVE", "0");
        this.autoeditToValue.put("%%FTP-ROSTYPE", this.ftpDetails.getLocalOS());
    }

    private void setAFTTransferAutoedits() {
        this.autoeditToValue.put("%%FTP-TYPE1", this.ftpDetails.getFtpParams().isAsciiTransferMode() ? "A" : "I");
        this.autoeditToValue.put("%%FTP-IF_EXIST1", this.ftpDetails.getFtpParams().isReplaceFileIfExists() ? "0" : "3");
        this.autoeditToValue.put("%%FTP-UPLOAD1", this.ftpDetails.getTransferDirection());
        if (!this.ftpDetails.getCtmCommandString().isEmpty()) {
            String ctmCommandString = this.ftpDetails.getCtmCommandString();
            this.autoeditToValue.put("%%FTP-PRECOMM11", ctmCommandString);
            this.autoeditToValue.put("%%FTP-PREPARAM111", this.ftpDetails.getLeftSideWithFilename());
            if (ctmCommandString.equals("rename")) {
                this.autoeditToValue.put("%%FTP-PREPARAM121", this.ftpDetails.getLeftSideWithNewFilename());
            }
        }
    }

    private void setAFTDefaultAutoedits() {
        String generatedConnectionProfileName = this.generateConnectionProfileName();
        this.autoeditToValue.put("%%FTP-PATH", "Not in use for application jobs");
        this.autoeditToValue.put("%%FTP-ACCOUNT", generatedConnectionProfileName);
        this.autoeditToValue.put("%%FTP-LPASSIVE", "0");
        this.autoeditToValue.put("%%FTP-RPASSIVE", "0");
        this.autoeditToValue.put("%%FTP-TRANSFER_NUM", "1");
        this.autoeditToValue.put("%%FTP-CONT_EXE_NOTOK", "0");
        this.autoeditToValue.put("%%FTP-RPF", "0");
        this.autoeditToValue.put("%%FTP-USE_DEF_NUMRETRIES", "0");
        this.autoeditToValue.put("%%FTP-NUM_RETRIES", "5");
        this.autoeditToValue.put("%%FTP-Is", "5");
        this.autoeditToValue.put("%%FTP-AUTOREFRESH", "False");
    }

    private String generateConnectionProfileName() {
        String localHost = this.ftpDetails.getLocalHost();
        String remoteHost = this.ftpDetails.getFtpParams().getRemoteHost();
        Object generatedConnectionProfileName = remoteHost + "-" + localHost;
        if (((String)generatedConnectionProfileName).equals("-")) {
            generatedConnectionProfileName = "DEFAULT_CONNECTION";
        }
        return generatedConnectionProfileName;
    }
}

