/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.tidal.AbstractTidalCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class TidalXmlCmConvertor
extends AbstractTidalCmConvertor {
    protected Set<String> suppressMessageForTheseElements;
    protected Map<String, String> paramConversionMap;
    protected Map<String, NodeHandler> handledParametersMap;
    protected Set<String> ignoredElementsStringList = new TreeSet<String>();

    @Override
    public void convertCmValues(IAttrHolder jobDtlRecord) {
        String adapterXml = jobDtlRecord.getAttr("JOBDTL_EXTINFO");
        this.initCmSpecificMaps();
        this.setAutoeditsFromXml(adapterXml);
        this.checkMandatoryParams();
        this.setDefaultAutoeditValues();
    }

    protected abstract Map<String, String> getParamsToAutoeditsMap();

    protected abstract Map<String, NodeHandler> getElementsHandlerMap();

    protected abstract Set<String> getSuppresedElementsSet();

    protected abstract String getJobConvertedSuccessMessageID();

    protected String getDefaultConnectionProfileValue() {
        return "DEFAULT_CONNECTION";
    }

    protected String getMissingMandatoryWarningMessageID() {
        return "WRN2318";
    }

    protected abstract Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList();

    protected abstract void setDefaultAutoeditValues();

    private void initCmSpecificMaps() {
        this.paramConversionMap = this.getParamsToAutoeditsMap();
        this.handledParametersMap = this.getElementsHandlerMap();
        this.suppressMessageForTheseElements = this.getSuppresedElementsSet();
        if (this.paramConversionMap == null) {
            this.paramConversionMap = new HashMap<String, String>();
        }
        if (this.handledParametersMap == null) {
            this.handledParametersMap = new HashMap<String, NodeHandler>();
        }
        if (this.suppressMessageForTheseElements == null) {
            this.suppressMessageForTheseElements = new HashSet<String>();
        }
    }

    private void setAutoeditsFromXml(String adapterXml) {
        DocumentBuilder db = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(adapterXml));
            try {
                Document doc = db.parse(is);
                this.walkAndSetAutoedits(doc);
                String jobConvertedSuccessMessageID = this.getJobConvertedSuccessMessageID();
                if (jobConvertedSuccessMessageID != null && !jobConvertedSuccessMessageID.isEmpty()) {
                    this.registerMessage(jobConvertedSuccessMessageID, this.getDefaultConnectionProfileValue(), this.ignoredElementsStringList.toString());
                }
            }
            catch (IOException | SAXException e) {
                this.logAndReportXmlError(adapterXml, e);
            }
        }
        catch (ParserConfigurationException e) {
            this.logAndReportXmlError(adapterXml, e);
        }
    }

    private void checkMandatoryParams() {
        ArrayList<String> missingParametersList = new ArrayList<String>();
        for (Pair<String, String> mandatoryAutoedit : this.getMandatoryAutoeditsToReportStringsList()) {
            String mandatoryAutoeditValue = (String)this.autoeditToValue.get(mandatoryAutoedit.getKey());
            boolean doesMandatoryAutoeditExist = mandatoryAutoeditValue == null || mandatoryAutoeditValue.isEmpty();
            if (!doesMandatoryAutoeditExist) continue;
            missingParametersList.add((String)mandatoryAutoedit.getValue());
        }
        if (!missingParametersList.isEmpty()) {
            this.registerMessage(this.getMissingMandatoryWarningMessageID(), ((Object)missingParametersList).toString());
        }
    }

    private boolean isSuppressed(String nodeName) {
        return this.suppressMessageForTheseElements.contains(nodeName.trim());
    }

    private void walkAndSetAutoedits(Node node) {
        if (node.getNodeType() == 1) {
            String nodeName = node.getNodeName();
            if (this.isHandled(nodeName)) {
                NodeHandler nodeHandlerToUse = n -> {
                    String lowerCaseElementName = n.getNodeName().toLowerCase();
                    for (String elementRegExString : this.handledParametersMap.keySet()) {
                        if (!lowerCaseElementName.matches(elementRegExString)) continue;
                        String matchingAutoeditName = this.getAutoeditByName(lowerCaseElementName);
                        String elementValue = n.getTextContent();
                        this.autoeditToValue.put(matchingAutoeditName, elementValue);
                    }
                };
                NodeHandler mappedNodeHandler = this.getHandlerByName(nodeName);
                if (mappedNodeHandler != null) {
                    nodeHandlerToUse = mappedNodeHandler;
                }
                nodeHandlerToUse.handleNode(node);
            } else if (!this.isSuppressed(nodeName)) {
                this.ignoredElementsStringList.add(nodeName);
            }
        }
        if (node.hasChildNodes()) {
            Node child = node.getFirstChild();
            do {
                this.walkAndSetAutoedits(child);
            } while ((child = child.getNextSibling()) != null);
        }
    }

    private String getAutoeditByName(String nodeName) {
        return this.getByPattern(this.paramConversionMap, nodeName);
    }

    private NodeHandler getHandlerByName(String nodeName) {
        return this.getByPattern(this.handledParametersMap, nodeName);
    }

    private <T> T getByPattern(Map<String, T> mapToLookIn, String string) {
        for (String regExString : mapToLookIn.keySet()) {
            String lowerCase = string.toLowerCase();
            if (!lowerCase.matches(regExString)) continue;
            return mapToLookIn.get(regExString);
        }
        return null;
    }

    private void logAndReportXmlError(String adapterXml, Exception e) {
        this.registerMessage("WRN2317", adapterXml);
        ConversionLogger.getLogger().warning("Caught " + e.getClass().getName() + " Stack:" + e.getStackTrace().toString());
    }

    private boolean isHandled(String nodeName) {
        String lowerCase = nodeName.toLowerCase();
        for (String elementRegExString : this.handledParametersMap.keySet()) {
            if (!lowerCase.matches(elementRegExString)) continue;
            return true;
        }
        return false;
    }

    public static interface NodeHandler {
        public void handleNode(Node var1);
    }
}

