/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.TidalDefs;
import com.bmc.ctmconvert.tidal.TidalJob;

public class TidalResolveJobOwner {
    private TidalDefs srcDef;
    private IAttrHolder jobDTLRec;
    private IAttrHolder jobOwnerRec;
    private String originalJobName;
    private String jobOwner = "";
    private TidalJob job;
    private IAttrHolder jobMSTRec;
    private boolean isWindowsOS;

    public TidalResolveJobOwner(TidalDefs srcDef, IAttrHolder jobDTLRec, IAttrHolder jobOwnerRec, boolean isWindowsOS, String m_origJobName, IAttrHolder jobMSTRec, TidalJob job) {
        this.srcDef = srcDef;
        this.jobDTLRec = jobDTLRec;
        this.jobOwnerRec = jobOwnerRec;
        this.isWindowsOS = isWindowsOS;
        this.originalJobName = m_origJobName;
        this.jobMSTRec = jobMSTRec;
        this.job = job;
    }

    public void resolveJobOwner() {
        if (this.jobDTLRec != null) {
            int userID = this.jobDTLRec.getAttrAsInt("JOBDTL_PROXY");
            if (userID == 0) {
                boolean isInharitedAgent = this.isJobUseInheritadAgent(this.jobDTLRec);
                if (isInharitedAgent) {
                    this.getJobOwnerFromParentJob(this.jobMSTRec);
                } else {
                    this.handleJobOwner(userID, this.jobOwnerRec);
                }
            } else {
                this.handleJobOwner(userID, this.jobOwnerRec);
            }
        }
    }

    private boolean isJobUseInheritadAgent(IAttrHolder jobDTLRecord) {
        boolean isInharitedAgent = jobDTLRecord.getAttr("JOBDTL_INHAGENT").equals("Y");
        return isInharitedAgent;
    }

    private void handleJobOwner(int userID, IAttrHolder jobOwnertRecord) {
        if (userID != 0) {
            IAttrHolder tmp_usrmst_rec = this.srcDef.getRecordByID("USRMST", userID);
            if (tmp_usrmst_rec != null) {
                this.jobOwner = tmp_usrmst_rec.getAttr("USRMST_NAME");
            }
            if (this.isWindowsOS) {
                this.jobOwner = tmp_usrmst_rec.getAttr("USRMST_DOMAIN") + "\\" + tmp_usrmst_rec.getAttr("USRMST_NAME");
            }
        }
        this.validateJobOwner(this.jobOwner);
        if (this.jobOwner.isEmpty() && jobOwnertRecord != null) {
            String ownerName = jobOwnertRecord.getAttr("OWNER_NAME");
            String string = this.jobOwner = ownerName == null ? "" : ownerName;
        }
        if (this.jobOwner.isEmpty()) {
            this.job.addMessage("INF2004", this.job.getJobname4Report(), this.originalJobName);
            this.jobOwner = "DEFAULT_OWNER";
        }
    }

    private void validateJobOwner(String jobOwner) {
        if (jobOwner == null) {
            String jobName = this.job.getJobname4Report();
            throw new RuntimeException(String.format("\nInvalid data:\n\nThe job (%s) has no job ownerTry extracting the data again or contact BMC support.\n", jobName));
        }
    }

    private void getJobOwnerFromParentJob(IAttrHolder jobMSTRecord) {
        int jobParentId = jobMSTRecord.getAttrAsInt("JOBMST_PRNTID");
        IAttrHolder parentJOBMstRec = this.srcDef.getRecordByID("JOBMST", jobParentId);
        int parentJOBDTLId = parentJOBMstRec.getAttrAsInt("JOBDTL_ID");
        IAttrHolder parentJOBDTLRec = this.srcDef.getRecordByID("JOBDTL", parentJOBDTLId);
        int parentUserID = parentJOBDTLRec.getAttrAsInt("JOBDTL_PROXY");
        boolean jobUseInheritadAgent = this.isJobUseInheritadAgent(parentJOBDTLRec);
        if (parentUserID == 0 && jobUseInheritadAgent) {
            this.getJobOwnerFromParentJob(parentJOBMstRec);
        } else {
            IAttrHolder parentJobOwnerRec = this.getParentJobOwnerRec(parentJOBMstRec);
            this.handleJobOwner(parentUserID, parentJobOwnerRec);
        }
    }

    private IAttrHolder getParentJobOwnerRec(IAttrHolder parentJOBMstRec) {
        int parentJobOwnerID = parentJOBMstRec.getAttrAsInt("JOBMST_OWNER");
        IAttrHolder parentJobOwnerRec = this.srcDef.getRecordByID("OWNER", parentJobOwnerID);
        return parentJobOwnerRec;
    }

    public String getJobOwner() {
        return this.jobOwner;
    }
}

