/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.InConditionBuilder;
import com.bmc.ctmconvert.common.conditions.OutConditionBuilder;
import com.bmc.ctmconvert.common.conditions.Sign;
import com.bmc.ctmconvert.common.integration_factory.wrapper.PeopleSoftWrapper;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tidal.AbstractTidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.IntStream;

public class TidalPeopleSoftConvertor
extends AbstractTidalCmConvertor {
    private final TidalJob job;

    public TidalPeopleSoftConvertor(TidalJob job) {
        this.job = job;
    }

    @Override
    public void convertCmValues(IAttrHolder jobDtlRecord) {
        XmlElement adapterXml = XmlLoader.from((String)jobDtlRecord.getAttr("JOBDTL_EXTINFO"));
        List<XmlElement> steps = this.getSteps(adapterXml);
        if (steps.size() == 1) {
            XmlElement step = steps.getFirst();
            this.convertStepToPeopleSoftJob(this.job, step, adapterXml);
        } else {
            TidalJob subFolder = this.convertJobToSubFolder(this.job, steps);
            List<SchedEntity> children = subFolder.getChildren();
            IntStream.range(0, steps.size()).forEach(index -> {
                XmlElement step = (XmlElement)steps.get(index);
                SchedEntity childJob = (SchedEntity)children.get(index);
                this.convertStepToPeopleSoftJob(childJob, step, adapterXml);
            });
        }
    }

    private TidalJob convertJobToSubFolder(TidalJob job, List<XmlElement> steps) {
        TidalJob.Manipulator manipulator = job.getManipulator();
        manipulator.setToSubFolder();
        List<AssistingJob> children = manipulator.createChildren(steps.size());
        this.addConditionsTo(children, steps, job.getJobName());
        return job;
    }

    private void convertStepToPeopleSoftJob(SchedEntity jobToConvert, XmlElement stepXml, XmlElement adapterXml) {
        PeopleSoftWrapper wrapper = new PeopleSoftWrapper(jobToConvert).convert().withAppendOutput(this.getAppendOutputFrom(stepXml)).withConnectionProfile(this.job.getNodeid());
        wrapper.withUserID(this.getUserIdFrom(adapterXml));
        this.getVariablesFrom(stepXml).forEach(arg_0 -> ((PeopleSoftWrapper)wrapper).withVariable(arg_0));
        this.getProcessNameFrom(stepXml).ifPresent(arg_0 -> ((PeopleSoftWrapper)wrapper).withProcessName(arg_0));
        this.getProcessTypeFrom(stepXml).ifPresent(arg_0 -> ((PeopleSoftWrapper)wrapper).withProcessType(arg_0));
        this.getControlIdFrom(stepXml).ifPresent(arg_0 -> ((PeopleSoftWrapper)wrapper).withRunControlId(arg_0));
    }

    private void addConditionsTo(List<AssistingJob> children, List<XmlElement> steps, String parentName) {
        StepConditionHandler conditionHandler = new StepConditionHandler(steps, parentName);
        children.forEach(child -> {
            String jobName = child.getJobName();
            conditionHandler.getInConditionsFor(jobName).forEach(arg_0 -> ((AssistingJob)child).addInCondition(arg_0));
            conditionHandler.getOutConditionsFor(jobName).forEach(arg_0 -> ((AssistingJob)child).addOutCondition(arg_0));
        });
    }

    public static String createJobName(int index, String parentJobName) {
        return parentJobName + "_Step" + index;
    }

    private boolean getAppendOutputFrom(XmlElement step) {
        String shouldAppendOutput = step.getValueOfFirstChildElementByName("psjob_output");
        return !"0".equals(shouldAppendOutput);
    }

    private Optional<String> getProcessTypeFrom(XmlElement step) {
        return this.emptyOrNull(step.getValueOfFirstChildElementByName("psjob_proctype"));
    }

    private Optional<String> getControlIdFrom(XmlElement step) {
        return this.emptyOrNull(step.getValueOfFirstChildElementByName("psjob_runcontrol"));
    }

    private Optional<String> getProcessNameFrom(XmlElement step) {
        return this.emptyOrNull(step.getValueOfFirstChildElementByName("psjob_procname"));
    }

    private Optional<String> emptyOrNull(String value) {
        return Optional.ofNullable(value).filter(x -> !x.isEmpty());
    }

    private List<XmlElement> getSteps(XmlElement adapterXml) {
        return adapterXml.getFirstChildElementByName("steps").getAllDecnedElementByName("step");
    }

    private List<String> getVariablesFrom(XmlElement step) {
        return step.getFirstChildElementByName("psjob_runvals").getAllDecnedElementByName("param").stream().map(param -> param.getValueOfFirstChildElementByName("var.compound")).map(String::trim).toList();
    }

    private String getUserIdFrom(XmlElement adapterXml) {
        return adapterXml.getValueOfFirstChildElementByName("username");
    }

    private static class StepConditionHandler {
        private final List<XmlElement> steps;
        private final String parentName;
        private final Map<String, List<Properties>> inConditions;
        private final Map<String, List<Properties>> outConditions;

        public StepConditionHandler(List<XmlElement> steps, String parentName) {
            this.steps = steps;
            this.parentName = parentName;
            this.inConditions = new HashMap<String, List<Properties>>();
            this.outConditions = new HashMap<String, List<Properties>>();
            this.calculateConditions();
        }

        public List<Properties> getInConditionsFor(String jobName) {
            return this.inConditions.getOrDefault(jobName, Collections.emptyList());
        }

        public List<Properties> getOutConditionsFor(String jobName) {
            return this.outConditions.getOrDefault(jobName, Collections.emptyList());
        }

        private List<Pair<String, String>> getSourceToTargetConditions() {
            return this.steps.stream().map(x -> new StepData((XmlElement)x, this.parentName)).filter(e -> e.getParentStepName().isPresent()).map(stepData -> Pair.of((Object)stepData.getParentStepName().get(), (Object)stepData.getStepName())).toList();
        }

        private String createUniqueConditionName(String source, String target) {
            return source + "-TO-" + target;
        }

        private void calculateConditions() {
            this.getSourceToTargetConditions().forEach(pair -> {
                String source = (String)pair.getKey();
                String target = (String)pair.getValue();
                String uniqueConditionName = this.createUniqueConditionName(source, target);
                Properties inCondition = InConditionBuilder.make((String)uniqueConditionName);
                Properties outCondition = OutConditionBuilder.make((String)uniqueConditionName);
                Properties deleteCondition = ((OutConditionBuilder)new OutConditionBuilder().setConditionName(uniqueConditionName)).setSign(Sign.Remove).build().getProperties();
                Function<String, List> newList = k -> new ArrayList();
                this.inConditions.computeIfAbsent(target, newList).add(inCondition);
                this.outConditions.computeIfAbsent(source, newList).add(outCondition);
                this.outConditions.computeIfAbsent(target, newList).add(deleteCondition);
            });
        }

        record StepData(XmlElement stepData, String parentName) {
            public String getStepName() {
                Optional number = GlobalFunctions.getNumberFrom((String)this.stepData.getAttribute("psjob_step"));
                return number.map(i -> TidalPeopleSoftConvertor.createJobName(i, this.parentName)).orElseThrow();
            }

            public Optional<String> getParentStepName() {
                String parentStep = Optional.ofNullable(this.stepData.getAttribute("parent_step")).orElse("");
                Optional number = GlobalFunctions.getNumberFrom((String)parentStep);
                return number.map(i -> TidalPeopleSoftConvertor.createJobName(i, this.parentName));
            }
        }
    }
}

