/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tidal.TidalOEBSConvertor;
import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TidalOEBSRequestSetConvertor
extends TidalOEBSConvertor {
    public TidalOEBSRequestSetConvertor(String jobdtl_extinfo, String user) {
        this.autoeditToValue.put("%%OAP-USERNAME", user);
        XmlElement xmlRootElement = XmlLoader.from((String)jobdtl_extinfo);
        this.setMainAutoedits(xmlRootElement);
        this.setRequsets(xmlRootElement);
    }

    private void setMainAutoedits(XmlElement xmlRootElement) {
        String setDesp = xmlRootElement.getValueOfFirstChildElementByName("user_cp_rs_name");
        this.autoeditToValue.put("%%OAP-SETDESP", setDesp);
        String setName = xmlRootElement.getValueOfFirstChildElementByName("cp_rs_name");
        this.autoeditToValue.put("%%OAP-SETNAME", setName);
        String appDesp = xmlRootElement.getValueOfFirstChildElementByName("appl_name");
        this.autoeditToValue.put("%%OAP-APPDESP", appDesp);
        String appName = xmlRootElement.getValueOfFirstChildElementByName("cp_rs_appl_short_name");
        this.autoeditToValue.put("%%OAP-APPNAME", appName);
    }

    private void setRequsets(XmlElement rootElement) {
        List requests = rootElement.getAllDecnedElementByName("request");
        int requestSeq = 1;
        for (XmlElement request : requests) {
            this.setAutoeditsPerRequest(requestSeq, request);
            XmlElement parameters = request.getFirstChildElementByName("parameters");
            if (parameters != null) {
                this.setParamsPairRequest(parameters, requestSeq);
            }
            ++requestSeq;
        }
    }

    private void setAutoeditsPerRequest(int requestSeq, XmlElement request) {
        this.setOperatingUnit(requestSeq, request);
        String progName = request.getValueOfFirstChildElementByName("cp_rs_name");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PROGNAME", requestSeq), progName);
        String progDesp = request.getValueOfFirstChildElementByName("user_cp_rs_name");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PROGDESP", requestSeq), progDesp);
        String appDesp = request.getValueOfFirstChildElementByName("appl_name");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-APPDESP", requestSeq), appDesp);
        String appName = request.getValueOfFirstChildElementByName("cp_rs_appl_short_name");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-APPNAME", requestSeq), appName);
        String stageName = request.getValueOfFirstChildElementByName("stage_name");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-STAGENAME", requestSeq), stageName);
        String stageSeq = request.getValueOfFirstChildElementByName("stage_seq");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-STAGESEQ", requestSeq), stageSeq);
        String language = request.getValueOfFirstChildElementByName("nls_lang");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-LANGUAGE", requestSeq), language);
        String printTo = request.getValueOfFirstChildElementByName("printer");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PRINTERNAME", requestSeq), printTo);
        String printStyle = request.getValueOfFirstChildElementByName("print_style");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PRINTSTYLE", requestSeq), printStyle);
        String copies = request.getValueOfFirstChildElementByName("number_copies");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PRINTCOPIES", requestSeq), copies);
        String progSeq = request.getValueOfFirstChildElementByName("cp_seq");
        this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PROGSEQ", requestSeq), String.valueOf(progSeq));
    }

    private void setOperatingUnit(int requestSeq, XmlElement request) {
        String operatingUnit = request.getValueOfFirstChildElementByName("operating_unit");
        if (!operatingUnit.isEmpty()) {
            this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-HAS_OPERATING_UNIT", requestSeq), "Y");
            this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-OPERATING_UNIT", requestSeq), operatingUnit);
        } else {
            this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-HAS_OPERATING_UNIT", requestSeq), "N");
        }
    }

    private void setParamsPairRequest(XmlElement parameterTable, int requsetNumber) {
        List allParameters = parameterTable.getAllDecnedElementByName("param");
        int paramNumber = 1;
        for (XmlElement xmlElement : allParameters) {
            String name = xmlElement.getValueOfFirstChildElementByName("end_user_colname");
            String value = xmlElement.getValueOfFirstChildElementByName("value");
            this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PARMS-P%03d-NAME", requsetNumber, paramNumber), name);
            this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PARMS-P%03d-VALUE", requsetNumber, paramNumber), value);
            this.autoeditToValue.put(String.format("%%%%OAP-SETPROG-P%03d-PARMS-P%03d-VALSETTYP", requsetNumber, paramNumber), "N");
            ++paramNumber;
        }
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        return new HashMap<String, String>(this.paramsToAutoeditsMap);
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        return new HashMap<String, TidalXmlCmConvertor.NodeHandler>(this.getCommonElementHandlerMap());
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        Set<Pair<String, String>> MandatoryAutoeditsList = this.getCommonMandatoryAutoeditsList();
        MandatoryAutoeditsList.add((Pair<String, String>)new Pair((Object)"%%OAP-SETDESP", (Object)"user_cp_rs_name"));
        MandatoryAutoeditsList.add((Pair<String, String>)new Pair((Object)"%%OAP-SETNAME", (Object)"cp_rs_name"));
        return MandatoryAutoeditsList;
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.setCommonDefaultAutoeditValues();
        this.autoeditToValue.put("%%OAP-TASKTYPE", "REQUEST_SET");
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        return new HashSet<String>(this.getCommonSuppresedElements());
    }
}

