/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class TidalInformaticaConvertor
extends TidalXmlCmConvertor {
    private static final String DEFAULT_DEPTH = "10";
    private static final String DEFAULT_EXE_MODE = "WHOLE";
    private static final String DEFAULT_RESTART_MODE = "RECOVER";
    private static final Map<String, String> paramsToAutoeditsMap = new HashMap<String, String>();
    private static final Set<String> suppressedElements;

    public TidalInformaticaConvertor() {
        this.applForm = "Informatica";
        this.applType = "ETL_INFA";
        this.applVer = "8.0.00";
        this.cmVer = "N/A";
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        return new HashMap<String, String>(paramsToAutoeditsMap);
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        HashMap<String, TidalXmlCmConvertor.NodeHandler> handledElementsMap = new HashMap<String, TidalXmlCmConvertor.NodeHandler>();
        handledElementsMap.put("parameters", this::reportParametersListNode);
        handledElementsMap.put("folder", null);
        handledElementsMap.put("workflow", null);
        handledElementsMap.put("workflow_id", null);
        handledElementsMap.put("paramfilename", null);
        handledElementsMap.put("runinstname", null);
        handledElementsMap.put("starttaskname", null);
        handledElementsMap.put("taskname", null);
        return handledElementsMap;
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        return new HashSet<String>(suppressedElements);
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.autoeditToValue.put("%%INF-ACCOUNT", "DEFAULT_CONNECTION");
        this.autoeditToValue.put("%%INF-DEPTH", DEFAULT_DEPTH);
        this.autoeditToValue.put("%%INF-WORKFLOW_RESTART_MODE", DEFAULT_RESTART_MODE);
        if (this.autoeditToValue.containsKey("%%INF-RUN_SINGLE_TASK") && !((String)this.autoeditToValue.get("%%INF-RUN_SINGLE_TASK")).isEmpty()) {
            this.autoeditToValue.put("%%INF-WORKFLOW_EXE_MODE", "SINGLE");
        } else if (this.autoeditToValue.containsKey("%%INF-START_FROM_TASK") && !((String)this.autoeditToValue.get("%%INF-START_FROM_TASK")).isEmpty()) {
            this.autoeditToValue.put("%%INF-WORKFLOW_EXE_MODE", "FROM_TASK");
        } else {
            this.autoeditToValue.put("%%INF-WORKFLOW_EXE_MODE", DEFAULT_EXE_MODE);
        }
    }

    @Override
    protected String getJobConvertedSuccessMessageID() {
        return "WRN2316";
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        result.add(new Pair((Object)"%%INF-WORKFLOW", (Object)"Workflow"));
        result.add(new Pair((Object)"%%INF-REP_FOLDER", (Object)"Repository Folder"));
        return result;
    }

    private void reportParametersListNode(Node node) {
        Node child = node.getFirstChild();
        do {
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase("parameter")) continue;
            String heading = "";
            if (child.hasAttributes() && child.getAttributes().getNamedItem("heading") != null) {
                heading = child.getAttributes().getNamedItem("heading").getNodeValue();
            }
            this.reportSingleParameter(child.getFirstChild(), heading);
        } while ((child = child.getNextSibling()) != null);
    }

    private void reportSingleParameter(Node node, String prefix) {
        do {
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("value") || node.getAttributes().getNamedItem("name") == null) continue;
            this.ignoredElementsStringList.add(String.format("%s/%s=%s", prefix.trim(), node.getAttributes().getNamedItem("name").getNodeValue().trim(), node.getTextContent().trim()));
        } while ((node = node.getNextSibling()) != null);
    }

    static {
        paramsToAutoeditsMap.put("folder", "%%INF-REP_FOLDER");
        paramsToAutoeditsMap.put("workflow", "%%INF-WORKFLOW");
        paramsToAutoeditsMap.put("workflow_id", "%%INF-RUN_ID");
        paramsToAutoeditsMap.put("paramfilename", "%%INF-WORKFLOW_PARAMETERS_FILE");
        paramsToAutoeditsMap.put("runinstname", "%%INF-INSTANCE_NAME");
        paramsToAutoeditsMap.put("starttaskname", "%%INF-START_FROM_TASK");
        paramsToAutoeditsMap.put("taskname", "%%INF-RUN_SINGLE_TASK");
        suppressedElements = new HashSet<String>();
        suppressedElements.add("var.compound");
        suppressedElements.add("jobdef");
        suppressedElements.add("params");
        suppressedElements.addAll(paramsToAutoeditsMap.keySet());
    }
}

