/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.file_watcher.AgeFormatBuilder;
import com.bmc.ctmconvert.common.message.MessageRegistry;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tidal.Calendars;
import com.bmc.ctmconvert.tidal.DependenciesAccumulator;
import com.bmc.ctmconvert.tidal.JobDep;
import com.bmc.ctmconvert.tidal.JobDepList;
import com.bmc.ctmconvert.tidal.JobDepTable;
import com.bmc.ctmconvert.tidal.JobRscTable;
import com.bmc.ctmconvert.tidal.Jobmst;
import com.bmc.ctmconvert.tidal.NodeGroupsTable;
import com.bmc.ctmconvert.tidal.NodesTable;
import com.bmc.ctmconvert.tidal.RbcFactory;
import com.bmc.ctmconvert.tidal.TidalCmsManager;
import com.bmc.ctmconvert.tidal.TidalDoMail;
import com.bmc.ctmconvert.tidal.TidalGlobals;
import com.bmc.ctmconvert.tidal.TidalJob;
import com.bmc.ctmconvert.tidal.TidalTimeZoneHandler;
import com.bmc.ctmconvert.tidal.TrgJobTable;
import com.bmc.ctmconvert.tidal.TrgMstTable;
import com.bmc.ctmconvert.tidal.TrgTskTable;
import com.bmc.ctmconvert.tidal.TskAlrtTable;
import com.bmc.ctmconvert.tidal.TskLogTable;
import com.bmc.ctmconvert.tidal.TskMailTable;
import com.bmc.ctmconvert.tidal.TskMstTable;
import com.bmc.ctmconvert.tidal.TskSchTable;
import com.bmc.ctmconvert.tidal.TskVarTable;
import com.bmc.ctmconvert.tidal.VarMstTable;
import com.bmc.ctmconvert.tidal.VariableDepMsgReporter;
import com.bmc.ctmconvert.tidal.variables.AbstractVariable;
import com.bmc.ctmconvert.tidal.variables.ConstantVariables;
import com.bmc.ctmconvert.tidal.variables.VariableNamer;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.vc.Message;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TidalDefs
implements SourceDefinitions {
    private static final String TSKMST_ID = "TSKMST_ID";
    private static final String TRGMST_TRIGGER = "TRGMST_TRIGGER";
    private static final String TRGMST_TYPE = "TRGMST_TYPE";
    private HashMap<String, RecordsHolder> m_dataSource = null;
    private static final int TOP_LEVEL_PARENT_ID = 0;
    private Jobmst jobmstTable = null;
    private AttrHolderList top_level_parents = null;
    private RulesDataSet m_rules = null;
    private Set<String> agentListNamesReported = new HashSet<String>();
    private HashMap<Integer, List<AssistingJob>> assistingJobs = new HashMap();
    private HashMap<Integer, List<List<String>>> jobID2Messages = new HashMap();
    private int jobID = 0;
    private CtmPriority priorityCalculator = null;
    private TidalCmsManager cmManager;
    private VariableNamer variableNamer;
    private TidalTimeZoneHandler timeZoneConvertor;
    private static ArrayList<String> generalMesssages = new ArrayList();
    private InputStream mstInStream;
    private InputStream depInStream;

    public TidalDefs(RulesDataSet ruleManager, InputStream mstInStream, HashMap<String, RecordsHolder> m_dataSource, InputStream depInStream) {
        this.m_rules = ruleManager;
        this.mstInStream = mstInStream;
        this.m_dataSource = m_dataSource;
        this.depInStream = depInStream;
        this.variableNamer = new VariableNamer();
    }

    public void finalize_() {
        Jobmst.destroy();
        this.m_dataSource = null;
        Calendars.destroy();
        JobDepTable.destroy();
        JobRscTable.destroy();
        NodeGroupsTable.destroy();
        NodesTable.destroy();
        TrgJobTable.destroy();
        TrgMstTable.destroy();
        TrgTskTable.destroy();
        TskAlrtTable.destroy();
        TskLogTable.destroy();
        TskMailTable.destroy();
        TskMstTable.destroy();
        TskSchTable.destroy();
        TskVarTable.destroy();
        VarMstTable.destroy();
        DependenciesAccumulator.destroy();
        RbcFactory.resetNames();
        generalMesssages = new ArrayList();
        AbstractVariable.clearInternalID();
    }

    public String getEntNameFieldName() {
        return "JOBMST_NAME";
    }

    public String getIdFieldName() {
        return "JOBMST_ID";
    }

    public String getParentEntFieldName() {
        return "JOBMST_PRNTNAME";
    }

    public AttrHolderList getTopLevelEntities() {
        return this.top_level_parents;
    }

    public boolean hasChildren(String entId) {
        int parentID = 0;
        try {
            parentID = Integer.parseInt(entId);
        }
        catch (NumberFormatException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return false;
        }
        return this.jobmstTable.hasChilds(parentID);
    }

    public void init() {
        this.jobmstTable = this.mstInStream == null ? Jobmst.instance() : Jobmst.instance(this.mstInStream);
        if (this.depInStream != null) {
            JobDepTable.instance(this.depInStream, this.m_rules);
        }
        this.top_level_parents = this.jobmstTable.getChilds(0);
        Calendars.getInstance().writeRbcsToXml(this.m_dataSource.get("EVNTMST"), this.m_dataSource.get("EVNTYEAR"), this.m_dataSource.get("EVNTCOND"));
        this.priorityCalculator = new CtmPriority(0, 100);
        this.cmManager = new TidalCmsManager(this.getTableByName("JOBMST"), this.getTableByName("JOBDTL"), this.getTableByName("SERVICEMST"));
        this.handleTimezone();
        this.createGlobalVariablesForDateTimeFormats();
    }

    private void handleTimezone() {
        RecordsHolder table_BIZUNIT = this.getTableByName("BIZUNIT");
        String vendorName = Params.instance().getVendorName();
        try (FileInputStream timeZoneMapperInputStream = new FileInputStream(Globs.MODULES_DATA_DIR + Globs.DIRSEP + vendorName + Globs.DIRSEP + "Tidal2CtmTimeZones.txt");){
            this.timeZoneConvertor = new TidalTimeZoneHandler(timeZoneMapperInputStream, table_BIZUNIT);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void createGlobalVariablesForDateTimeFormats() {
        for (Map.Entry<String, String> autoedit : ConstantVariables.getGlobalDateFormatAutoedits()) {
            String name = autoedit.getKey();
            String value = autoedit.getValue();
            String reportDisplayName = "ALL";
            Reporter.addGlobalAutoEditAction(null, (String)name, (String)value, (String)reportDisplayName);
        }
    }

    public TidalCmsManager getCmManager() {
        return this.cmManager;
    }

    public TidalTimeZoneHandler getTimeZoneConvertor() {
        return this.timeZoneConvertor;
    }

    public void applyFilter(String root) {
    }

    public AttrHolderList getChildren(String parentEntityId) {
        int parentID = 0;
        try {
            parentID = Integer.valueOf(parentEntityId);
        }
        catch (NumberFormatException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return null;
        }
        return this.jobmstTable.getChilds(parentID);
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        TidalJob job = TidalJob.createTidalJob(table, attributes, (SourceDefinitions)this, RuleManager.instance().getCurrentRules());
        return job;
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        TidalJob job = TidalJob.createTidalJob((TidalJob)parent, attributes, (SourceDefinitions)this, RuleManager.instance().getCurrentRules());
        return job;
    }

    public IAttrHolder getRecordByID(String CSVTableName, int id) {
        return this.getTableByName(CSVTableName).get(id);
    }

    public RecordsHolder getTableByName(String CSVTableName) {
        return this.m_dataSource.get(CSVTableName);
    }

    public List<AssistingJob> getAssistingJobs(int jobID) {
        return this.assistingJobs.get(jobID);
    }

    private Properties createInCond(JobDep dep, String condReleation) {
        String condName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", JobDepTable.instance().getCondName(dep));
        Properties props = new Properties();
        props.put("NAME", condName);
        props.put("AND_OR", condReleation);
        props.put("ODATE", this.calculateConditionOdate(dep.getDateOffset()));
        return props;
    }

    List<Properties> generateOutConds(boolean forSuccesfulCompletion, int jobmst_id) {
        this.jobID = jobmst_id;
        ArrayList<Properties> retList = new ArrayList<Properties>();
        JobDepList out_deps = JobDepTable.instance().getOutDeps(jobmst_id);
        if (out_deps == null) {
            return retList;
        }
        for (JobDep dep : out_deps) {
            int type = dep.type();
            assert (type == 1);
            boolean dependencyRelevant = this.isDepRelevant(forSuccesfulCompletion, dep.getJobDepType());
            if (!dependencyRelevant) continue;
            Properties cond = this.createOutCond(dep);
            retList.add(cond);
        }
        return retList;
    }

    private boolean isDepRelevant(boolean forSuccesfulCompletion, JobDep.JobDepType jobDepType) {
        boolean dependencyRelevant = false;
        if (forSuccesfulCompletion && (jobDepType == JobDep.JobDepType.COMPLETED || jobDepType == JobDep.JobDepType.ENDED_OK || jobDepType == JobDep.JobDepType.LAUNCH || jobDepType == JobDep.JobDepType.UNSUPPORTED_JOBDEP)) {
            dependencyRelevant = true;
        } else if (!(forSuccesfulCompletion || jobDepType != JobDep.JobDepType.COMPLETED && jobDepType != JobDep.JobDepType.LAUNCH && jobDepType != JobDep.JobDepType.ENDED_NOTOK)) {
            dependencyRelevant = true;
        }
        return dependencyRelevant;
    }

    private Properties createOutCond(JobDep dep) {
        JobDep.JobDepType jobDepType = dep.getJobDepType();
        if (jobDepType == JobDep.JobDepType.UNSUPPORTED_JOBDEP) {
            ArrayList<String> list = this.getUnSupportedJobDependencyMessage(dep);
            this.updateJobMessages(this.jobID, list);
        }
        String condName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", JobDepTable.instance().getCondName(dep));
        Properties props = new Properties();
        props.put("NAME", condName);
        props.put("ODATE", this.calculateConditionOdate(dep.getDateOffset()));
        props.put("SIGN", "ADD");
        return props;
    }

    private String calculateConditionOdate(int dateOffset) {
        String odate = "ODAT";
        if (dateOffset == -1) {
            odate = "NEXT";
        } else if (dateOffset == 1) {
            odate = "PREV";
        }
        return odate;
    }

    private ArrayList<String> getUnSupportedJobDependencyMessage(JobDep dep) {
        Integer status = new Integer(dep.getJobStatus());
        String JobStatusName = JobDep.JOB_STATUS.toEnum(status).toString();
        String operatorString = dep.operatorIsValid() ? "a Valid" : "an Invalid";
        String operator = dep.getOperator();
        String condName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", JobDepTable.instance().getCondName(dep));
        ArrayList<String> list = new ArrayList<String>();
        list.add("WRN1007");
        list.add(JobStatusName);
        list.add(operatorString);
        list.add(operator);
        list.add(condName);
        return list;
    }

    public List<Properties> getQuantResources(int jobmstID) {
        ArrayList<Properties> retList = null;
        AttrHolderList my_resources = JobRscTable.instance().getJobResources(jobmstID);
        if (my_resources != null && !my_resources.isEmpty()) {
            retList = new ArrayList<Properties>();
            for (IAttrHolder res : my_resources) {
                Properties resource = this.createResource(res.getAttrAsInt("RESMST_ID"), res.getAttrAsInt("RESJOB_USE"), jobmstID);
                if (resource.isEmpty()) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("INF2006");
                    this.updateJobMessages(jobmstID, list);
                    continue;
                }
                retList.add(resource);
            }
        }
        return retList;
    }

    private Properties createResource(int res_id, int res_used, int jobmstID) {
        String name;
        Properties props = new Properties();
        IAttrHolder temp = this.getRecordByID("RESMST", res_id);
        if (temp != null && (name = temp.getAttr("RESMST_NAME")) != null) {
            String validatedValue = "";
            if (!name.isEmpty()) {
                validatedValue = FieldValidation.instance().validateAndReturnFixedValue("QUANTITATIVE_RESOURCE_NAME", name);
                ArrayList validObjectMessages = FieldValidation.instance().getErrMsgs();
                for (Message message : validObjectMessages) {
                    ArrayList<String> msgList;
                    if (message.getMsgType() == Message.MessageType.LENGTH) {
                        msgList = new ArrayList<String>();
                        msgList.add("INF0013");
                        msgList.add("QUANTITATIVE_RESOURCE_NAME");
                        msgList.add("(TIDAL- RESMST_NAME)");
                        msgList.add(name);
                        msgList.add(validatedValue);
                        this.updateJobMessages(jobmstID, msgList);
                        continue;
                    }
                    if (message.getMsgType() != Message.MessageType.INVALID_CHARACTER) continue;
                    msgList = new ArrayList();
                    msgList.add("INF0014");
                    msgList.add("QUANTITATIVE_RESOURCE_NAME");
                    msgList.add("(TIDAL- RESMST_NAME)");
                    msgList.add(name);
                    msgList.add(validatedValue);
                    this.updateJobMessages(jobmstID, msgList);
                }
            }
            props.put("NAME", validatedValue);
            props.put("QUANT", String.valueOf(res_used));
        }
        return props;
    }

    private Properties createOnStmt(int tsk_id, int trig_type, int action, int subtype, int exit_code, SchedEntity job) {
        Properties props = new Properties();
        switch (trig_type) {
            case 3: {
                props.put("CODE", "OK");
                props.put("STMT", "*");
                break;
            }
            case 2: 
            case 12: {
                props.put("CODE", "NOTOK");
                props.put("STMT", "*");
                break;
            }
            case 1: {
                break;
            }
            case 36: {
                if (exit_code < 0) break;
                props.put("STMT", "*");
                String temp = "COMPSTAT=" + exit_code;
                props.put("CODE", temp);
                break;
            }
            default: {
                String detailedMsg = String.format("%d", trig_type);
                ArrayList<String> list = new ArrayList<String>();
                list.add("WRN1008");
                list.add(detailedMsg);
                this.updateJobMessages(this.jobID, list);
            }
        }
        if (props.isEmpty()) {
            return props;
        }
        switch (action) {
            case 1: {
                IAttrHolder mail_detail = TskMailTable.instance().getTskMail(tsk_id);
                if (mail_detail == null) break;
                TidalDoMail doMail = new TidalDoMail(mail_detail, this::getRecordByID, ((TidalJob)job)::expandAutoedits, tsk_id);
                Properties doMailProperties = doMail.getDoMailProperties();
                props.putAll((Map<?, ?>)doMailProperties);
                LinkedHashMap<String, List<String>> doMailMessages = doMail.getMessages();
                for (String messageId : doMailMessages.keySet()) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(messageId);
                    list.addAll((Collection)doMailMessages.get(messageId));
                    this.updateJobMessages(this.jobID, list);
                }
                break;
            }
            case 6: {
                props.put("ACTION", "DOFORCEJOB");
                AttrHolderList job_details = TskSchTable.instance().getTskSch(tsk_id);
                if (job_details == null) break;
                IAttrHolder ah = (IAttrHolder)job_details.get(0);
                int recovery_job_id = ah.getAttrAsInt("JOBMST_ID");
                IAttrHolder recovery_job_record = this.getRecordByID("JOBMST", recovery_job_id);
                if (recovery_job_record == null) {
                    String detailedMsg = "Could not find recovery job for jobID - " + recovery_job_id;
                    ArrayList<String> list6 = new ArrayList<String>();
                    list6.add("INF2012");
                    list6.add(detailedMsg);
                    this.updateJobMessages(this.jobID, list6);
                    break;
                }
                String recovery_job_name = recovery_job_record.getAttr("JOBMST_NAME");
                Object table_name = "";
                Integer recoveryJobParentID = recovery_job_record.getAttrAsInt("JOBMST_PRNTID");
                if (recoveryJobParentID == null || recoveryJobParentID == 0) {
                    if (Jobmst.instance().hasChilds(recovery_job_id)) {
                        table_name = recovery_job_name;
                        recovery_job_name = " ";
                    } else {
                        table_name = recovery_job_name + "_TABLE";
                    }
                } else {
                    IAttrHolder recovery_job_parent = this.getRecordByID("JOBMST", recoveryJobParentID);
                    table_name = recovery_job_parent.getAttr("JOBMST_NAME");
                }
                table_name = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", (String)table_name);
                recovery_job_name = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", recovery_job_name);
                props.put("NAME", recovery_job_name);
                props.put("ODATE", "ODAT");
                props.put("TABLE_NAME", table_name);
                break;
            }
            case 3: {
                Object detailedMsg;
                String prefix;
                AttrHolderList job_details;
                props.put("ACTION", "DOSHOUT");
                switch (subtype) {
                    case 2: {
                        props.put("DEST", "EM");
                        job_details = TskAlrtTable.instance().getTskAlrt(tsk_id);
                        prefix = "ALRT";
                        break;
                    }
                    case 5: {
                        props.put("DEST", "IOALOG");
                        job_details = TskLogTable.instance().getTskLog(tsk_id);
                        prefix = "LOG";
                        break;
                    }
                    default: {
                        detailedMsg = String.format("TASK_TYPE <%d> is not implemented for DOSHOUT", subtype);
                        ArrayList<String> list7 = new ArrayList<String>();
                        list7.add("WRN1008");
                        list7.add((String)detailedMsg);
                        this.updateJobMessages(this.jobID, list7);
                        props.clear();
                        return props;
                    }
                }
                if (job_details == null) break;
                block30: for (IAttrHolder job_detail : job_details) {
                    String message = job_detail.getAttr("TSK" + prefix + "_MSG");
                    message = ((TidalJob)job).expandAutoedits(message);
                    int max_message_size = 255;
                    if (message.length() > max_message_size) {
                        message = message.substring(0, max_message_size - 1);
                    }
                    props.put("MESSAGE", message);
                    int level = job_detail.getAttrAsInt("TSK" + prefix + "_LEVEL");
                    switch (level) {
                        case 1: {
                            props.put("URGENCY", "V");
                            continue block30;
                        }
                        case 2: {
                            props.put("URGENCY", "U");
                            continue block30;
                        }
                    }
                    props.put("URGENCY", "R");
                }
                break;
            }
            case 2: {
                props.put("ACTION", "DOAUTOEDIT2");
                AttrHolderList job_details = TskVarTable.instance().getTskVar(tsk_id);
                if (job_details == null) break;
                for (IAttrHolder job_detail : job_details) {
                    int var_id = job_detail.getAttrAsInt("VARMST_ID");
                    AttrHolderList var_list = VarMstTable.instance().getJobResources(var_id);
                    if (var_list == null) continue;
                    block32: for (IAttrHolder var : var_list) {
                        Object temp = var.getAttr("VARMST_NAME");
                        temp = "%%" + (String)temp;
                        String validatedAutoeditName = FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", (String)temp, true, "Variable", job.getOriginalJobName(), (List)job.getMessages());
                        props.put("NAME", validatedAutoeditName);
                        int type = job_detail.getAttrAsInt("TSKVAR_TYPE");
                        switch (type) {
                            case 1: {
                                String value = job_detail.getAttr("TSKVAR_VAL");
                                props.put("VALUE", ((TidalJob)job).expandAutoedits(value));
                                continue block32;
                            }
                            case 2: {
                                props.put("VALUE", "%%plus1");
                                continue block32;
                            }
                            case 3: {
                                props.put("VALUE", "%%minus1");
                                continue block32;
                            }
                        }
                        String detailedMsg = String.format("Unsupported CODE for VAR TASK TYPE : <%d>", type);
                        ArrayList<String> list8 = new ArrayList<String>();
                        list8.add("WRN1008");
                        list8.add(detailedMsg);
                        this.updateJobMessages(this.jobID, list8);
                        props.clear();
                        return props;
                    }
                }
                break;
            }
            case 5: {
                props.put("ACTION", "SPCYC");
                props.put("NAME", "SPCYC");
                break;
            }
            case 4: {
                props.put("ACTION", "RERUN");
                props.put("NAME", "RERUN");
                break;
            }
            case 7: {
                props.put("ACTION", "OK");
                props.put("NAME", "OK");
                break;
            }
            case 8: {
                props.put("ACTION", "NOTOK");
                props.put("NAME", "NOTOK");
                break;
            }
            default: {
                Object detailedMsg = String.format("Unsupported CODE for ACTION : <%d>", action);
                ArrayList<String> list9 = new ArrayList<String>();
                list9.add("WRN1008");
                list9.add((String)detailedMsg);
                this.updateJobMessages(this.jobID, list9);
                props.clear();
            }
        }
        return props;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        TidalJob _job = (TidalJob)job;
        this.jobID = _job.getJobID();
        ArrayList<Properties> retList = new ArrayList<Properties>();
        JobDepList my_deps = JobDepTable.instance().getJobDependencies(_job.getJobID());
        int counter = 0;
        String condRelation = this.getConditionsRelationship(_job);
        if (my_deps != null) {
            block5: for (JobDep dep : my_deps) {
                Properties cond;
                int type = dep.type();
                switch (type) {
                    case 1: {
                        JobDep.JobDepType jobDepType = dep.getJobDepType();
                        if (jobDepType == JobDep.JobDepType.UNSUPPORTED_JOBDEP) {
                            ArrayList<String> list = this.getUnSupportedJobDependencyMessage(dep);
                            this.updateJobMessages(this.jobID, list);
                        }
                        cond = this.createInCond(dep, condRelation);
                        this.reportCanIgnoreDependency(dep, this.jobID, cond.getProperty("NAME"));
                        this.reportDependencyRelativeToGroupInstance(dep, this.jobID, cond.getProperty("NAME"));
                        retList.add(cond);
                        continue block5;
                    }
                    case 2: {
                        this.createFileDep(dep, job, ++counter);
                        cond = this.createInCond(dep, condRelation);
                        retList.add(cond);
                        continue block5;
                    }
                    case 3: {
                        VariableDepMsgReporter msgParameterProvider = new VariableDepMsgReporter(VarMstTable.instance()::getJobResources, this::updateJobMessages);
                        msgParameterProvider.reportVarDepMessage(_job.getJobName(), dep, this.jobID);
                        cond = this.createInCond(dep, condRelation);
                        retList.add(cond);
                        continue block5;
                    }
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add("INF2016");
                this.updateJobMessages(this.jobID, list);
                cond = this.createInCond(dep, condRelation);
                retList.add(cond);
            }
        }
        List<Properties> jobIndCondsPropList = DependenciesAccumulator.getInstance().getJobConds(retList, this.jobID, true);
        this.handleCleanUpConditionRule(jobIndCondsPropList);
        return jobIndCondsPropList;
    }

    String getConditionsRelationship(TidalJob job) {
        IAttrHolder jobdtlRecord = job.getJobdtlRec();
        Integer depLogic = jobdtlRecord.getAttrAsInt("JOBDTL_DEPLOGIC");
        return switch (depLogic) {
            case 1 -> "AND";
            case 2 -> "OR";
            default -> "AND";
        };
    }

    private void handleCleanUpConditionRule(List<Properties> jobIndCondsPropList) {
        boolean cleanup = RuleManager.instance().getCurrentRules().getBooleanRule("Additional Tidal rules", new String[]{"CLEANUP_CONDITIONS"});
        if (cleanup) {
            ArrayList<Properties> delPropOutConds = new ArrayList<Properties>();
            for (Properties incondition : jobIndCondsPropList) {
                Properties cleanupOutCondition = this.addCleanUpCondition(incondition);
                delPropOutConds.add(cleanupOutCondition);
            }
            DependenciesAccumulator.getInstance().getJobConds(delPropOutConds, this.jobID, false);
        }
    }

    private Properties addCleanUpCondition(Properties incondition) {
        String condName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", incondition.getProperty("NAME"));
        Properties cleanupOutCondition = new Properties();
        cleanupOutCondition.put("NAME", condName);
        cleanupOutCondition.put("ODATE", "ODAT");
        cleanupOutCondition.put("SIGN", "DEL");
        return cleanupOutCondition;
    }

    private void reportCanIgnoreDependency(JobDep dep, int jobId, String controlMconditionName) {
        boolean isTidalCanIgnoreDependency = "Y".equals(dep.getAttr("JOBDEP_CANIGNORE"));
        if (isTidalCanIgnoreDependency) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("WRN2320");
            list.add(dep.getAttr("JOBDEP_ID"));
            list.add(controlMconditionName);
            this.updateJobMessages(jobId, list);
        }
    }

    private void reportDependencyRelativeToGroupInstance(JobDep dep, int jobId, String controlMconditionName) {
        boolean isDependencyRelativeToGroupInstance = "Y".equals(dep.getAttr("JOBDEP_INGROUP"));
        if (isDependencyRelativeToGroupInstance) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("WRN2322");
            list.add(dep.getAttr("JOBDEP_ID"));
            list.add(controlMconditionName);
            this.updateJobMessages(jobId, list);
        }
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        ArrayList<Properties> retList = new ArrayList<Properties>();
        if (job.type() != SchedEntity.TYPE.TABLE) {
            TidalJob _job = (TidalJob)job;
            this.jobID = _job.getJobID();
            retList.addAll(this.trackToOnDoStmt(_job));
            retList.addAll(this.triggersToOnStmts(job));
            retList.addAll(this.failureDepToOnDocond(_job));
        }
        return retList;
    }

    ArrayList<Properties> failureDepToOnDocond(TidalJob job) {
        ArrayList onFailureOutcondList = (ArrayList)this.generateOutConds(false, job.getJobID());
        for (Properties outcond : onFailureOutcondList) {
            outcond.put("CODE", "NOTOK");
            outcond.put("ACTION", "DOCOND");
        }
        return onFailureOutcondList;
    }

    List<Properties> trackToOnDoStmt(TidalJob job) {
        ArrayList<Properties> retList;
        block14: {
            String testStrings;
            int trackMethod;
            block13: {
                JOBDTL_NORMALOP_VALUES normalOpValues;
                retList = new ArrayList<Properties>();
                trackMethod = job.getJobdtlRec().getAttrAsInt("JOBDTL_TRACKMETHOD");
                if (trackMethod != 1) break block13;
                int int_normal_op = 0;
                int int_normal_range = 0;
                int int_normal_exit = 0;
                Properties Statement2 = new Properties();
                String normal_op = job.getJobdtlRec().getAttr("JOBDTL_NORMALOP").trim();
                String normal_range = job.getJobdtlRec().getAttr("JOBDTL_NORMALRANGE").trim();
                String normal_exit = job.getJobdtlRec().getAttr("JOBDTL_NORMALEXIT").trim();
                try {
                    int_normal_op = Integer.valueOf(normal_op);
                    int_normal_range = Integer.valueOf(normal_range);
                    int_normal_exit = Integer.valueOf(normal_exit);
                    normalOpValues = JOBDTL_NORMALOP_VALUES.values()[int_normal_op];
                }
                catch (NumberFormatException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    int_normal_op = 0;
                    normalOpValues = JOBDTL_NORMALOP_VALUES.values()[int_normal_op];
                }
                switch (normalOpValues.ordinal()) {
                    case 1: {
                        if (int_normal_exit != 0 || int_normal_range != 0) {
                            Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_exit - 1));
                            Statement2.setProperty("STMT", "*");
                            Statement2.setProperty("ACTION", "OK");
                            retList.add(Statement2);
                            Statement2 = new Properties();
                            Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_range));
                            Statement2.setProperty("STMT", "*");
                            Statement2.setProperty("ACTION", "NOTOK");
                            retList.add(Statement2);
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        Statement2.setProperty("CODE", String.format("COMPSTAT LT %d", int_normal_exit));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "OK");
                        retList.add(Statement2);
                        Statement2 = new Properties();
                        Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_range));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "OK");
                        retList.add(Statement2);
                        break;
                    }
                    case 3: {
                        Statement2.setProperty("CODE", String.format("COMPSTAT LT %d", int_normal_exit));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "OK");
                        retList.add(Statement2);
                        Statement2 = new Properties();
                        Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_exit - 1));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "NOTOK");
                        retList.add(Statement2);
                        break;
                    }
                    case 4: {
                        Statement2.setProperty("CODE", String.format("COMPSTAT LT %d", int_normal_exit + 1));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "OK");
                        retList.add(Statement2);
                        Statement2 = new Properties();
                        Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_exit));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "NOTOK");
                        retList.add(Statement2);
                        break;
                    }
                    case 5: {
                        Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_exit));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "OK");
                        retList.add(Statement2);
                        Statement2 = new Properties();
                        Statement2.setProperty("CODE", String.format("COMPSTAT LT %d", int_normal_exit + 1));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "NOTOK");
                        retList.add(Statement2);
                        break;
                    }
                    case 6: {
                        Statement2.setProperty("CODE", String.format("COMPSTAT GT %d", int_normal_exit - 1));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "OK");
                        retList.add(Statement2);
                        Statement2 = new Properties();
                        Statement2.setProperty("CODE", String.format("COMPSTAT LT %d", int_normal_exit));
                        Statement2.setProperty("STMT", "*");
                        Statement2.setProperty("ACTION", "NOTOK");
                        retList.add(Statement2);
                        break;
                    }
                    default: {
                        this.addMessage(job.getJobname4Report(), "WRN1013", job.getJobName(), String.valueOf(normal_op));
                        break;
                    }
                }
                break block14;
            }
            if (!(trackMethod != 4 && trackMethod != 5 || (testStrings = job.getJobdtlRec().getAttr("JOBDTL_TRACKCMD").trim()) == null || testStrings.isEmpty())) {
                String[] abnormalStrings = testStrings.split("[\r\n,]+");
                for (int i = 0; i < abnormalStrings.length; ++i) {
                    Properties currOnStmt = new Properties();
                    currOnStmt.put("STMT", "*");
                    currOnStmt.put("CODE", "*" + abnormalStrings[i] + "*");
                    currOnStmt.put("ACTION", trackMethod == 5 ? "NOTOK" : "OK");
                    retList.add(currOnStmt);
                }
            }
        }
        return retList;
    }

    Set<Properties> triggersToOnStmts(SchedEntity job) {
        TidalJob _job = (TidalJob)job;
        AttrHolderList triggers_list = TrgJobTable.instance().getJobTrg(_job.getJobID());
        HashSet<Properties> retList = new HashSet<Properties>();
        if (triggers_list != null) {
            for (IAttrHolder trigger : triggers_list) {
                AttrHolderList events_list;
                Properties cond;
                if (!trigger.isFieldExist("TRGJOB_TYPE")) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("WRN2309");
                    this.updateJobMessages(this.jobID, list);
                    continue;
                }
                ArrayList<String> exit_codes = new ArrayList<String>();
                if (trigger.getAttrAsInt("TRGJOB_TYPE") != 0) continue;
                if (_job.getJobdtlRec().getAttrAsInt("JOBDTL_CONCUR") == 4 && job.isCyclic()) {
                    cond = new Properties();
                    cond = this.createOnStmt(-1, 2, 5, -1, -1, job);
                    if (!cond.isEmpty()) {
                        retList.add(cond);
                    }
                }
                if ((events_list = TrgMstTable.instance().getTrgMst(trigger.getAttrAsInt("TRGMST_ID"))) == null) continue;
                for (IAttrHolder event : events_list) {
                    AttrHolderList action_list;
                    int intVal;
                    Iterator params;
                    String[] params_list;
                    if (event.getAttrAsInt(TRGMST_TYPE) != 1) continue;
                    if (event.getAttrAsInt(TRGMST_TRIGGER) == 36 && (params_list = ((String)((Object)(params = event.getAttr("TRGMST_PARM")))).split(",")) != null) {
                        for (String current_param : params_list) {
                            if (!current_param.contains("EX") || !current_param.contains("=")) continue;
                            String target_str = current_param.substring(current_param.indexOf("=") + 1);
                            exit_codes.add(target_str);
                        }
                    }
                    switch (event.getAttrAsInt("TRGMST_JOBCTL")) {
                        case 5: {
                            String exit_code;
                            cond = new Properties();
                            if (event.getAttrAsInt(TRGMST_TRIGGER) == 1) {
                                cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), 3, 4, -1, -1, job);
                                if (!cond.isEmpty()) {
                                    retList.add(cond);
                                }
                                cond = new Properties();
                                cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), 2, 4, -1, -1, job);
                                if (cond.isEmpty()) break;
                                retList.add(cond);
                                break;
                            }
                            if (event.getAttrAsInt(TRGMST_TRIGGER) == 36 && !exit_codes.isEmpty()) {
                                params = exit_codes.iterator();
                                while (params.hasNext()) {
                                    exit_code = (String)params.next();
                                    try {
                                        intVal = Integer.parseInt(exit_code);
                                    }
                                    catch (NumberFormatException ex) {
                                        intVal = -1;
                                    }
                                    if ((cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), event.getAttrAsInt(TRGMST_TRIGGER), 4, -1, intVal, job)).isEmpty()) continue;
                                    retList.add(cond);
                                }
                                break;
                            }
                            cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), event.getAttrAsInt(TRGMST_TRIGGER), 4, -1, -1, job);
                            if (cond.isEmpty()) break;
                            retList.add(cond);
                            break;
                        }
                        case 6: 
                        case 8: {
                            String exit_code;
                            cond = new Properties();
                            if (event.getAttrAsInt(TRGMST_TRIGGER) == 36 && !exit_codes.isEmpty()) {
                                params = exit_codes.iterator();
                                while (params.hasNext()) {
                                    exit_code = (String)params.next();
                                    try {
                                        intVal = Integer.parseInt(exit_code);
                                    }
                                    catch (NumberFormatException ex) {
                                        intVal = -1;
                                    }
                                    if ((cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), event.getAttrAsInt(TRGMST_TRIGGER), 8, -1, intVal, job)).isEmpty()) continue;
                                    retList.add(cond);
                                }
                                break;
                            }
                            cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), event.getAttrAsInt(TRGMST_TRIGGER), 8, -1, -1, job);
                            if (cond.isEmpty()) break;
                            retList.add(cond);
                            break;
                        }
                        case 7: {
                            String exit_code;
                            cond = new Properties();
                            if (event.getAttrAsInt(TRGMST_TRIGGER) == 36 && !exit_codes.isEmpty()) {
                                params = exit_codes.iterator();
                                while (params.hasNext()) {
                                    exit_code = (String)params.next();
                                    try {
                                        intVal = Integer.parseInt(exit_code);
                                    }
                                    catch (NumberFormatException ex) {
                                        intVal = -1;
                                    }
                                    if ((cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), event.getAttrAsInt(TRGMST_TRIGGER), 7, -1, intVal, job)).isEmpty()) continue;
                                    retList.add(cond);
                                }
                                break;
                            }
                            cond = this.createOnStmt(trigger.getAttrAsInt("TRGMST_ID"), event.getAttrAsInt(TRGMST_TRIGGER), 7, -1, -1, job);
                            if (cond.isEmpty()) break;
                            retList.add(cond);
                            break;
                        }
                        default: {
                            int type_t = event.getAttrAsInt("TRGMST_JOBCTL");
                            this.addMessage(_job.getJobname4Report(), "WRN2332", job.getJobName(), String.valueOf(type_t), String.valueOf(switch (type_t) {
                                case 1 -> "JOB_CTL_CANCEL";
                                case 2 -> "JOB_CTL_HOLD";
                                case 3 -> "JOB_CTL_OVERRIDE";
                                case 4 -> "JOB_CTL_RELEASE";
                                case 9 -> "JOB_CTL_SET_EXTERNAL";
                                case 10 -> "JOB_CTL_SET_ORPHANED";
                                case 11 -> "JOB_CTL_SET_SKIPPED";
                                case 12 -> "JOB_CTL_SET_CANCEL_PENDING";
                                case 13 -> "JOB_CTL_SET_WAITOP";
                                case 14 -> "JOB_CTL_SET_CANCEL_WAITOP";
                                default -> "";
                            }));
                        }
                    }
                    if ((action_list = TrgTskTable.instance().getTrgTsk(trigger.getAttrAsInt("TRGMST_ID"))) == null) continue;
                    for (IAttrHolder current_action : action_list) {
                        AttrHolderList action_details = TskMstTable.instance().getTskMst(current_action.getAttrAsInt(TSKMST_ID));
                        if (action_details == null) continue;
                        for (IAttrHolder detail : action_details) {
                            int sub_type = detail.getAttrAsInt("TSKMST_TYPE");
                            cond = new Properties();
                            int task_type = -1;
                            switch (sub_type) {
                                case 1: {
                                    task_type = 1;
                                    break;
                                }
                                case 2: 
                                case 5: {
                                    task_type = 3;
                                    break;
                                }
                                case 4: {
                                    task_type = 6;
                                    break;
                                }
                                case 6: {
                                    task_type = 2;
                                    break;
                                }
                                default: {
                                    this.addMessage(_job.getJobname4Report(), "WRN2333", job.getJobName(), String.valueOf(sub_type), switch (sub_type) {
                                        case 3 -> "TASK_TYPE_SNMP";
                                        case 7 -> "TASK_TYPE_ITO";
                                        case 8 -> "TASK_TYPE_ALARMPOINT";
                                        case 9 -> "TASK_TYPE_WMI";
                                        case 10 -> "TASK_TYPE_MANAGEX";
                                        case 11 -> "TASK_TYPE_NETIQ";
                                        case 14 -> "TASK_TYPE_IRC";
                                        case 17 -> "TASK_TYPE_SAP";
                                        case 18 -> "TASK_TYPE_SERVICE";
                                        default -> "";
                                    });
                                }
                            }
                            if (task_type == -1) continue;
                            if (event.getAttrAsInt(TRGMST_TRIGGER) == 1) {
                                cond = this.createOnStmt(current_action.getAttrAsInt(TSKMST_ID), 3, task_type, sub_type, -1, job);
                                if (!cond.isEmpty()) {
                                    retList.add(cond);
                                }
                                cond = new Properties();
                                cond = this.createOnStmt(current_action.getAttrAsInt(TSKMST_ID), 2, task_type, sub_type, -1, job);
                                if (cond.isEmpty()) continue;
                                retList.add(cond);
                                continue;
                            }
                            if (event.getAttrAsInt(TRGMST_TRIGGER) == 36 && !exit_codes.isEmpty()) {
                                for (String exit_code : exit_codes) {
                                    try {
                                        intVal = Integer.parseInt(exit_code);
                                    }
                                    catch (NumberFormatException ex) {
                                        intVal = -1;
                                    }
                                    if ((cond = this.createOnStmt(current_action.getAttrAsInt(TSKMST_ID), event.getAttrAsInt(TRGMST_TRIGGER), task_type, sub_type, intVal, job)).isEmpty()) continue;
                                    retList.add(cond);
                                }
                                continue;
                            }
                            cond = this.createOnStmt(current_action.getAttrAsInt(TSKMST_ID), event.getAttrAsInt(TRGMST_TRIGGER), task_type, sub_type, -1, job);
                            if (cond.isEmpty()) continue;
                            retList.add(cond);
                        }
                    }
                }
            }
        }
        return retList;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        TidalJob _job = (TidalJob)job;
        this.jobID = _job.getJobID();
        List<Properties> jobPropList = this.generateOutConds(true, _job.getJobID());
        List<Properties> returnsJobOutConds = DependenciesAccumulator.getInstance().getJobConds(jobPropList, this.jobID, false);
        return returnsJobOutConds;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public List<List<String>> getMessages(int jobID) {
        return this.jobID2Messages.get(jobID);
    }

    private void updateJobMessages(int jobID, List<String> list2) {
        if (this.jobID2Messages.get(jobID) != null) {
            this.jobID2Messages.get(jobID).add(list2);
        } else {
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            list.add(list2);
            this.jobID2Messages.put(jobID, list);
        }
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return entAttr.getAttrAsInt("JOBMST_TYPE") == 1;
    }

    public String getPriority(int priority) {
        return this.priorityCalculator.calculatePriority(priority);
    }

    private void createFileDep(JobDep dep, SchedEntity job, int counter) {
        boolean cleanup;
        int jobId = ((TidalJob)job).getJobID();
        if (!this.assistingJobs.containsKey(jobId)) {
            this.assistingJobs.put(jobId, new ArrayList());
        }
        ArrayList asstJobList = (ArrayList)this.assistingJobs.get(jobId);
        String jobname4Report = ((TidalJob)job).getJobname4Report();
        String jobName = ((TidalJob)job).getJobName();
        Properties assistInCond = new Properties();
        int jobDepFileType = dep.getAttrAsInt("JOBDEP_FILETYPE");
        String depFile = dep.getAttr("JOBDEP_FILENAME");
        int depModifier = dep.getAttrAsInt("JOBDEP_FILEEXTENT");
        NodesTable.Node node = null;
        Integer nodekey = dep.getAttrAsInt("NODMST_ID");
        if (nodekey != null) {
            node = NodesTable.instance().get(nodekey);
        }
        AssistingJob fwJob = this.createFilewatcherJob(depFile, job, node != null ? node.fullName() : "");
        fwJob.setAttribute("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", "FW-" + job.getJobName() + "_" + String.valueOf(dep.getJobDepID())));
        fwJob.setAttribute("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", fwJob.getAttr("JOBNAME").replace("/", "").replace("\\", "")));
        fwJob.setAutoedit("%%FileWatch-TIME_LIMIT", Integer.toString(1380));
        Properties satisfiedCond = new Properties();
        String condName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", JobDepTable.instance().getCondName(dep));
        satisfiedCond.put("NAME", condName);
        satisfiedCond.put("ODATE", "ODAT");
        satisfiedCond.put("SIGN", "ADD");
        switch (jobDepFileType) {
            case 200: {
                fwJob.addOutCondition(satisfiedCond);
                break;
            }
            case 201: {
                Properties assistOutCond = new Properties();
                String assistCondName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", "ASST_" + JobDepTable.instance().getCondName(dep));
                assistOutCond.put("NAME", assistCondName);
                assistOutCond.put("ODATE", "ODAT");
                assistOutCond.put("SIGN", "ADD");
                assistInCond.put("NAME", assistCondName);
                assistInCond.put("AND_OR", "AND");
                assistInCond.put("ODATE", "ODAT");
                AssistingJob fwStep1 = this.createFilewatcherJob(depFile, job, node != null ? node.fullName() : "");
                fwStep1.setAttribute("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", "FW-" + job.getJobName() + "-" + depFile + "-0"));
                fwStep1.setAttribute("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", fwStep1.getAttr("JOBNAME").replace("/", "").replace("\\", "")));
                fwStep1.setAutoedit("%%FileWatch-TIME_LIMIT", Integer.toString(1));
                fwStep1.addOutCondition(assistOutCond);
                Properties docondStmt = new Properties();
                docondStmt.put("STMT", "*");
                docondStmt.put("CODE", "NOTOK");
                docondStmt.put("ACTION", "DOCOND");
                docondStmt.put("NAME", condName);
                docondStmt.setProperty("ODATE", "ODAT");
                docondStmt.put("SIGN", "ADD");
                fwStep1.addOnStmt(docondStmt);
                Properties doOKStmt = new Properties();
                doOKStmt.setProperty("CODE", "NOTOK");
                doOKStmt.setProperty("STMT", "*");
                doOKStmt.setProperty("ACTION", "OK");
                fwStep1.addOnStmt(doOKStmt);
                fwJob.setAutoedit("%%FileWatch-MODE", "DELETE");
                fwJob.addOutCondition(satisfiedCond);
                fwJob.addInCondition(assistInCond);
                new MessageRegistry().addMessage(jobname4Report, "INF2014", new String[]{jobName, TidalGlobals.fileDepIdToName.get(jobDepFileType), fwStep1.getJobName()});
                asstJobList.add(fwStep1);
                break;
            }
            case 202: {
                Properties assistOutCond = new Properties();
                String assistCondName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", "ASST_" + JobDepTable.instance().getCondName(dep));
                assistOutCond.put("NAME", assistCondName);
                assistOutCond.put("ODATE", "ODAT");
                assistOutCond.put("SIGN", "ADD");
                assistInCond.put("NAME", assistCondName);
                assistInCond.put("AND_OR", "AND");
                assistInCond.put("ODATE", "ODAT");
                AssistingJob fwStep1 = this.createFilewatcherJob(depFile, job, node != null ? node.fullName() : "");
                fwStep1.setAttribute("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", "FW-" + job.getJobName() + "-" + depFile + "-0"));
                fwStep1.setAttribute("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", fwStep1.getAttr("JOBNAME").replace("/", "").replace("\\", "")));
                fwStep1.setAutoedit("%%FileWatch-TIME_LIMIT", Integer.toString(1));
                fwStep1.addOutCondition(assistOutCond);
                fwJob.setAutoedit("%%FileWatch-MIN_DET_SIZE", Integer.toString(depModifier));
                fwJob.addInCondition(assistInCond);
                Properties docondStmt = new Properties();
                docondStmt.put("STMT", "*");
                docondStmt.put("CODE", "NOTOK");
                docondStmt.put("ACTION", "DOCOND");
                docondStmt.put("NAME", condName);
                docondStmt.setProperty("ODATE", "ODAT");
                docondStmt.put("SIGN", "ADD");
                fwJob.addOnStmt(docondStmt);
                Properties doOKStmt = new Properties();
                doOKStmt.setProperty("CODE", "NOTOK");
                doOKStmt.setProperty("STMT", "*");
                doOKStmt.setProperty("ACTION", "OK");
                fwJob.addOnStmt(doOKStmt);
                new MessageRegistry().addMessage(jobname4Report, "INF2014", new String[]{jobName, TidalGlobals.fileDepIdToName.get(jobDepFileType), fwStep1.getJobName()});
                asstJobList.add(fwStep1);
                break;
            }
            case 203: {
                fwJob.setAutoedit("%%FileWatch-MIN_DET_SIZE", Integer.toString(depModifier));
                fwJob.addOutCondition(satisfiedCond);
                break;
            }
            case 204: {
                fwJob.setAutoedit("%%FileWatch-MIN_AGE", new AgeFormatBuilder().setMinutes(depModifier / 60).buildMinAge());
                fwJob.addOutCondition(satisfiedCond);
                break;
            }
            case 205: {
                fwJob.setAutoedit("%%FileWatch-TIME_LIMIT", Integer.toString(1));
                fwJob.setAutoedit("%%FileWatch-MAX_AGE", new AgeFormatBuilder().setMinutes(depModifier / 60).buildMaxAge());
                fwJob.addOutCondition(satisfiedCond);
                break;
            }
        }
        if (assistInCond != null && !assistInCond.isEmpty() && (cleanup = RuleManager.instance().getCurrentRules().getBooleanRule("Additional Tidal rules", new String[]{"CLEANUP_CONDITIONS"}).booleanValue())) {
            Properties cleanupCondition = new Properties();
            String cleanupConditionValidName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", assistInCond.getProperty("NAME"));
            cleanupCondition.put("NAME", cleanupConditionValidName);
            cleanupCondition.put("ODATE", "ODAT");
            cleanupCondition.put("SIGN", "DEL");
            fwJob.addOutCondition(cleanupCondition);
        }
        new MessageRegistry().addMessage(jobname4Report, "INF2014", new String[]{jobName, TidalGlobals.fileDepIdToName.get(jobDepFileType), fwJob.getJobName()});
        asstJobList.add(fwJob);
    }

    private AssistingJob createFilewatcherJob(String watchedFile, SchedEntity assisted, String node) {
        AssistingJob fwJob = new AssistingJob(assisted);
        fwJob.setAttribute("MEMLIB", "Not in use for File Watcher jobs");
        if (node.isEmpty()) {
            node = assisted.getAttr("NODEID");
        }
        fwJob.setAttribute("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", node));
        if (this.m_rules.getTaskTypeHandler().isToDummy()) {
            fwJob.setAttribute("TASKTYPE", "Dummy");
        } else {
            fwJob.setAttribute("TASKTYPE", "Job");
        }
        fwJob.setOptionalAttribute("APPL_FORM", "File Watcher");
        fwJob.setOptionalAttribute("APPL_TYPE", "FileWatch");
        fwJob.setOptionalAttribute("APPL_VER", "9.0.00.300");
        fwJob.setOptionalAttribute("CM_VER", "8.0.00");
        String file = this.resolveParametersForFileWatcherJob(watchedFile, assisted, fwJob);
        fwJob.setAutoedit("%%FileWatch-FILE_PATH", file);
        fwJob.setAutoedit("%%FileWatch-MIN_DET_SIZE", "0");
        fwJob.setAutoedit("%%FileWatch-INT_FILE_SEARCHES", "60");
        fwJob.setAutoedit("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        fwJob.setAutoedit("%%FileWatch-NUM_OF_ITERATIONS", "3");
        fwJob.setAutoedit("%%FileWatch-TIME_LIMIT", "0");
        fwJob.setAutoedit("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
        fwJob.setAutoedit("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        fwJob.setAutoedit("%%FileWatch-PATH", "Not in use for File Watcher jobs");
        fwJob.setAutoedit("%%FileWatch-MODE", "CREATE");
        fwJob.setAutoedit("%%FileWatch-FILESIZE_WILDCARD", "N");
        fwJob.setAutoedit("%%FileWatch-START_TIME", "NOW");
        fwJob.setAutoedit("%%FileWatch-STOP_TIME", "0");
        return fwJob;
    }

    private String resolveParametersForFileWatcherJob(String watchedFile, SchedEntity assisted, AssistingJob fwJob) {
        String file = ((TidalJob)assisted).expandAutoedits(watchedFile);
        fwJob.addAllAutoedits((Map)assisted.getAutoedits());
        return file;
    }

    public ArrayList<String> getGeneralMessages() {
        return new ArrayList<String>(new LinkedHashSet<String>(generalMesssages));
    }

    public String resolveSystemVariables(String unresolved) {
        unresolved = unresolved.replace("<SystemDate>", "%%$DATE");
        unresolved = unresolved.replace("<SysDate>", "%%$DATE");
        unresolved = unresolved.replace("<SystemTime>", "%%TIME");
        unresolved = unresolved.replace("<SysTime>", "%%TIME");
        unresolved = unresolved.replace("<SystemName>", "%%DATACENTER");
        unresolved = unresolved.replace("<UserName>", "%%USER");
        unresolved = unresolved.replace("<JobRuleID>", "%%JOBNO");
        unresolved = unresolved.replace("<JobID>", "%%ORDERID");
        unresolved = unresolved.replace("<JobName>", "%%JOBNAME");
        unresolved = unresolved.replace("<JobName..p>", "%%SCHEDTAB");
        unresolved = unresolved.replace("<JobName.p>", "%%SCHEDTAB");
        unresolved = unresolved.replace("<JobParent>", "%%GROUP_ORDID");
        unresolved = unresolved.replace("<AgentName>", "%%NODEID");
        unresolved = unresolved.replace("<JobAgent>", "%%NODEID");
        unresolved = unresolved.replace("<JobRunID>", "%%ORDERID");
        unresolved = unresolved.replace("<ExitCode>", "%%COMPSTAT");
        unresolved = unresolved.replace("<JobExit>", "%%COMPSTAT");
        unresolved = unresolved.replace("<ExternalID>", "%%JOBID");
        unresolved = unresolved.replace("<RuntimeUser>", "%%OWNER");
        unresolved = unresolved.replace("<JobOwner>", "%%OWNER");
        unresolved = unresolved.replace("<ScheduledDate>", "%%$ODATE");
        return unresolved;
    }

    public void createDependencies(String root) {
    }

    public void addMessage(String displayNameForReport, String messageID, String ... args) {
        Reporter.addMessage(generalMesssages, (String)messageID, (String)displayNameForReport, (String[])args);
    }

    public Set<String> getAgentListNames() {
        HashSet<String> set = new HashSet<String>(this.agentListNamesReported);
        return set;
    }

    public void addAgentListNames(String name) {
        this.agentListNamesReported.add(name);
    }

    public VariableNamer getVariableNamer() {
        return this.variableNamer;
    }

    public RulesDataSet getRules() {
        return this.m_rules;
    }

    private static enum JOBDTL_NORMALOP_VALUES {
        NOT_VALID,
        OP_EQUALS,
        OP_NOT_EQUALS,
        OP_LESS_THAN,
        OP_LESS_THAN_OR_EQUAL,
        OP_GREATER_THAN,
        OP_GREATER_THAN_OR_EQUAL,
        OP_ODD,
        OP_EVEN;

    }
}

