/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tidal.AbstractTidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TidalAS400Convertor
extends AbstractTidalCmConvertor {
    private final TidalJob job;

    public TidalAS400Convertor(TidalJob job) {
        this.job = job;
    }

    @Override
    public void convertCmValues(IAttrHolder jobDtlRecord) {
        this.convertDefaults(this.job);
        XmlElement adapterXml = XmlLoader.from((String)jobDtlRecord.getAttr("JOBDTL_EXTINFO"));
        this.job.addVariable("%%OS400-CMDLINE1", TidalAS400Convertor.getCommandLineFrom(adapterXml));
        this.job.addVariable("%%OS400-JOB_NAME", this.getOS400JobNameFrom(adapterXml));
        this.getOS400JobDescriptionAndLibraryFrom(adapterXml).ifPresent(v -> this.job.addVariable("%%OS400-JOBD", (String)v));
        this.getOS400JobQueueAndLibraryFrom(adapterXml).ifPresent(v -> this.job.addVariable("%%OS400-JOBQ", (String)v));
        this.getLibraryListFrom(adapterXml).ifPresent(v -> this.job.addVariable("%%OS400-INLLIBL1", (String)v));
        this.getInqueryMessageFrom(adapterXml).ifPresent(v -> this.job.addVariable("%%OS400-INQMSGRPY", (String)v));
    }

    private Optional<String> getInqueryMessageFrom(XmlElement adapterXml) {
        return TidalAS400Convertor.nullOrEmpty(adapterXml.getValueOfFirstChildElementByName("IMR"));
    }

    private Optional<String> getLibraryListFrom(XmlElement adapterXml) {
        return TidalAS400Convertor.nullOrEmpty(adapterXml.getValueOfFirstChildElementByName("ILIB"));
    }

    private Optional<String> getOS400JobQueueAndLibraryFrom(XmlElement adapterXml) {
        return this.getMultipleValuesFrom(adapterXml, "JQLIB", "JQ");
    }

    private Optional<String> getMultipleValuesFrom(XmlElement adapterXml, String ... names) {
        String result = Stream.of(names).map(arg_0 -> ((XmlElement)adapterXml).getValueOfFirstChildElementByName(arg_0)).filter(Objects::nonNull).filter(x -> !x.isEmpty()).collect(Collectors.joining("/"));
        return TidalAS400Convertor.nullOrEmpty(result);
    }

    private static Optional<String> nullOrEmpty(String result) {
        return Optional.ofNullable(result).filter(x -> !x.isEmpty());
    }

    private Optional<String> getOS400JobDescriptionAndLibraryFrom(XmlElement adapterXml) {
        return this.getMultipleValuesFrom(adapterXml, "JDLIB", "JD");
    }

    private String getOS400JobNameFrom(XmlElement adapterXml) {
        return adapterXml.getValueOfFirstChildElementByName("JN");
    }

    private void convertDefaults(TidalJob job) {
        job.setAttribute("APPL_TYPE", "OS400");
        job.setAttribute("APPL_VER", "9.0.19");
        job.setAttribute("APPL_FORM", "OS/400 Full");
        job.setAttribute("CM_VER", "N/A");
        job.setAttribute("MULTY_AGENT", "N");
        job.addVariable("%%OS400-AEV_LEN", "4000");
        job.addVariable("%%OS400-OBJTYP", "*MULTICMD");
        job.addVariable("%%OS400-JOB_OWNER", job.getOwner());
    }

    private static String getCommandLineFrom(XmlElement adapterXml) {
        return adapterXml.getValueOfFirstChildElementByName("CMD");
    }
}

