/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.SourceDataBox;
import com.bmc.ctmconvert.common.exceptions.ConversionRuntimeException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SourceDataTidalCSVManager {
    private String[] m_columnsHeaders;
    private String[] m_agentColumnsHeaders;
    private String[] m_groupSgentColumnsHeaders;
    private HashMap<String, String> m_JobID_Command = new HashMap();
    private ArrayList<String> m_singleJobs = new ArrayList();
    private HashMap<String, ArrayList<String>> m_JobID_Info = new HashMap();
    private HashMap<String, String> m_JobID_ParentID = new HashMap();
    private HashMap<String, String> m_JobID_Name = new HashMap();
    private HashMap<String, String> m_JobName_ID = new HashMap();
    private int m_rowsCount = 0;
    private int m_jobsInsideBoxesCount = 0;
    private HashMap<String, List<String>> m_AgentID_Info = new HashMap();
    private HashMap<String, List<String>> m_GroupAgentID_Info = new HashMap();
    private HashMap<String, ArrayList<String>> m_JobID_SonsList = new HashMap();
    private HashMap<String, Integer> m_Nodes_2_Jobs_Count = new HashMap();
    private HashMap<String, String> mstNodeMap = new HashMap();
    private HashMap<String, String> m_NodLSTMS_Id_2_Name = new HashMap();
    private Map<String, List<String>> lstdtNodeMap = new HashMap<String, List<String>>();
    private HashMap<String, Boolean> hirarchyStrct = new HashMap();
    private HashMap<String, String> agentsGroupTree = new HashMap();
    private HashMap<String, String> agentsIdForNames = new HashMap();
    private HashMap<String, SourceDataBox> m_boxes = new HashMap();
    private HashMap<String, String> m_JobID_EventID = new HashMap();
    private HashMap<String, String> m_EventID_EventName = new HashMap();
    private HashMap<String, String> m_EventName_EventID = new HashMap();
    private HashMap<String, ArrayList<String>> m_EventID_JobsIDList = new HashMap();

    public int getCRowsNumber() {
        return this.m_rowsCount;
    }

    public int getJobsNumber() {
        int num = 0;
        num += this.m_jobsInsideBoxesCount;
        if (null != this.getAllSingleJobs()) {
            num += this.getAllSingleJobs().size();
        }
        return num;
    }

    public ArrayList<String> getAllSingleJobs() {
        return this.m_singleJobs;
    }

    public String[] getColumnsHeaders() {
        return this.m_columnsHeaders;
    }

    public String[] getAgentscolumnsHeaders() {
        return this.m_agentColumnsHeaders;
    }

    public String[] getGroupAgentscolumnsHeaders() {
        return this.m_groupSgentColumnsHeaders;
    }

    public String getJobName(String jobID) {
        return this.m_JobID_Name.get(jobID);
    }

    public String getJobID(String jobName) {
        return this.m_JobName_ID.get(jobName);
    }

    public String[] getJobInfo(String jobName) {
        String[] result = null;
        ArrayList<String> tempList = this.m_JobID_Info.get(jobName);
        if (null != tempList) {
            result = new String[tempList.size()];
            tempList.toArray(result);
        }
        return result;
    }

    public String[] getAgentsInfo(String agentName) {
        String[] result = null;
        List<String> tempList = this.m_AgentID_Info.get(agentName);
        if (null != tempList) {
            result = new String[tempList.size()];
            tempList.toArray(result);
        }
        return result;
    }

    public String[] getGroupAgentsInfo(String groupAgentName) {
        String[] result = null;
        List<String> tempList = this.m_GroupAgentID_Info.get(groupAgentName);
        if (null != tempList) {
            result = new String[tempList.size()];
            tempList.toArray(result);
        }
        return result;
    }

    public ArrayList<String> getCalendarsJobsNames(String calendarName) {
        ArrayList<String> resultList = new ArrayList<String>();
        String eventID = this.m_EventName_EventID.get(calendarName);
        if (null != eventID) {
            for (String jobID : this.m_EventID_JobsIDList.get(eventID)) {
                resultList.add(this.m_JobID_Name.get(jobID));
            }
        }
        return resultList;
    }

    public ArrayList<String> getCalendarsList() {
        ArrayList<String> calendarList = new ArrayList<String>(this.m_EventID_EventName.values());
        calendarList.removeAll(Collections.singleton(null));
        return calendarList;
    }

    public String getCalendarName(String calendarID) {
        return this.m_EventID_EventName.get(calendarID);
    }

    public String getJobCommand(String jobname) {
        return this.m_JobID_Command.get(jobname);
    }

    public Set<String> getBoxesList() {
        return this.m_boxes.keySet();
    }

    public SourceDataBox getBoxByID(String boxID) {
        return this.m_boxes.get(boxID);
    }

    public SourceDataTidalCSVManager(String jobMST, String jobDTL, String eventMST, String nodMST, String nodLSTMS, String nodLSTDT) {
        this.loadJOBDTLCSVFiles(jobDTL);
        this.loadNODMSTCSVFiles(nodMST);
        this.loadNODLSTMSCSVFiles(nodLSTMS);
        this.loadNODLSTDTCSVFiles(nodLSTDT);
        this.loadJOBMSTCSVFiles(jobMST);
        this.loadEVNTMSTCSVFiles(eventMST);
        this.createBoxesHierarchy();
        this.createCalendarHierarchy();
    }

    private void loadNODLSTDTCSVFiles(String fileName) {
        int d = 0;
        try {
            CsvReader reader = new CsvReader(fileName);
            String agentId = "";
            int index_NODMST_ID = 2;
            String agentGroupId = "";
            int index_NODLSTMST_ID = 1;
            reader.readRecord();
            while (reader.readRecord()) {
                agentId = reader.getValues()[index_NODMST_ID];
                agentGroupId = reader.getValues()[index_NODLSTMST_ID];
                ArrayList<String> listOfAgents = new ArrayList<String>();
                if (this.lstdtNodeMap.containsKey(agentGroupId)) {
                    this.lstdtNodeMap.get(agentGroupId).add(agentId);
                } else {
                    listOfAgents.add(agentId);
                    this.lstdtNodeMap.put(agentGroupId, listOfAgents);
                }
                ++d;
            }
            reader.close();
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error in loadNODLSTDTCSVFiles");
            sb.append("File : " + fileName);
            sb.append("Line : " + d);
            sb.append("Exception while reading csv file: " + String.valueOf(e));
            ConversionLogger.getLogger().info(sb.toString());
        }
    }

    private void loadNODLSTMSCSVFiles(String fileName) {
        int d = 0;
        try {
            CsvReader reader = new CsvReader(fileName);
            String nodLSTMSName = "";
            int index_NODLSTMST_NAME = 1;
            String nodLSTMSIdStr = "";
            int index_NODLSTMST_ID = 0;
            String nodParentIdStr = "";
            int index_NODPARENT_ID = 4;
            reader.readRecord();
            this.m_groupSgentColumnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_groupSgentColumnsHeaders.length; ++i) {
                this.m_groupSgentColumnsHeaders[i] = reader.getValues()[i];
            }
            ArrayList<String> tempArray = new ArrayList<String>();
            while (reader.readRecord()) {
                nodLSTMSName = reader.getValues()[index_NODLSTMST_NAME];
                nodLSTMSIdStr = reader.getValues()[index_NODLSTMST_ID];
                this.m_NodLSTMS_Id_2_Name.put(nodLSTMSIdStr, nodLSTMSName);
                this.agentsIdForNames.put(nodLSTMSName, nodLSTMSIdStr);
                nodParentIdStr = reader.getValues()[index_NODPARENT_ID];
                if (!nodParentIdStr.equals("")) {
                    this.agentsGroupTree.put(nodLSTMSIdStr, nodParentIdStr);
                } else if (!nodParentIdStr.equals("")) {
                    ArrayList<String> childsList = new ArrayList<String>();
                    childsList.add(nodLSTMSIdStr);
                    this.agentsGroupTree.put(nodLSTMSIdStr, nodParentIdStr);
                }
                if (nodParentIdStr.equals("")) {
                    this.hirarchyStrct.put(nodLSTMSIdStr, true);
                } else {
                    this.hirarchyStrct.put(nodLSTMSIdStr, false);
                }
                tempArray = new ArrayList();
                int length = reader.getValues().length;
                for (int i = 0; i < length; ++i) {
                    tempArray.add(reader.getValues()[i]);
                }
                this.m_GroupAgentID_Info.put(nodLSTMSIdStr, tempArray);
                ++d;
            }
            reader.close();
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error in loadNODLSTMSCSVFiles");
            sb.append("File : " + fileName);
            sb.append("Line : " + d);
            sb.append("Exception while reading csv file: " + String.valueOf(e));
            ConversionLogger.getLogger().info(sb.toString());
        }
    }

    private void loadNODMSTCSVFiles(String fileName) {
        int d = 0;
        try {
            CsvReader reader = new CsvReader(fileName);
            String nodeMstName = "";
            int index_NODMST_NAME = 2;
            String nodeMstIdStr = "";
            int index_NODMST_ID = 0;
            reader.readRecord();
            this.m_agentColumnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_agentColumnsHeaders.length; ++i) {
                this.m_agentColumnsHeaders[i] = reader.getValues()[i];
            }
            ArrayList<String> tempArray = null;
            while (reader.readRecord()) {
                nodeMstName = reader.getValues()[index_NODMST_NAME];
                nodeMstIdStr = reader.getValues()[index_NODMST_ID];
                this.mstNodeMap.put(nodeMstIdStr, nodeMstName);
                this.agentsIdForNames.put(nodeMstName, nodeMstIdStr);
                tempArray = new ArrayList<String>();
                int length = reader.getValues().length;
                for (int i = 0; i < length; ++i) {
                    tempArray.add(reader.getValues()[i]);
                }
                this.m_AgentID_Info.put(nodeMstIdStr, tempArray);
                ++d;
            }
            reader.close();
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error in loadNODMSTCSVFiles");
            sb.append("File : " + fileName);
            sb.append("Line : " + d);
            sb.append("Exception while reading csv file: " + String.valueOf(e));
            ConversionLogger.getLogger().info(sb.toString());
        }
    }

    public void loadJOBMSTCSVFiles(String fileName) {
        try {
            CsvReader reader = new CsvReader(fileName);
            String jobIDStr = "";
            int index_JOBMST_ID = 0;
            String parentIDStr = "";
            int index_JOBMST_PRNTID = 2;
            String eventStr = "";
            int index_EVNTMST_ID = 4;
            String jobNameStr = "";
            int index_JOBMST_NAME = 6;
            ArrayList<String> tempArray = null;
            int length = 0;
            reader.readRecord();
            this.m_columnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_columnsHeaders.length; ++i) {
                this.m_columnsHeaders[i] = reader.getValues()[i];
            }
            while (reader.readRecord()) {
                length = reader.getValues().length;
                jobIDStr = reader.getValues()[index_JOBMST_ID];
                parentIDStr = reader.getValues()[index_JOBMST_PRNTID];
                if (!parentIDStr.isEmpty()) {
                    ArrayList<String> sonsList = this.m_JobID_SonsList.get(parentIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(jobIDStr);
                    this.m_JobID_SonsList.put(parentIDStr, sonsList);
                    if (this.m_JobID_EventID.containsKey(parentIDStr) && !this.m_EventID_JobsIDList.get(this.m_JobID_EventID.get(parentIDStr)).contains(jobIDStr)) {
                        this.m_EventID_JobsIDList.get(this.m_JobID_EventID.get(parentIDStr)).add(jobIDStr);
                    }
                } else {
                    this.m_singleJobs.add(jobIDStr);
                }
                this.m_JobID_ParentID.put(jobIDStr, parentIDStr);
                tempArray = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    tempArray.add(reader.getValues()[i]);
                }
                eventStr = reader.getValues()[index_EVNTMST_ID];
                if (!eventStr.isEmpty()) {
                    this.m_JobID_EventID.put(jobIDStr, eventStr);
                    ArrayList<String> eventJobsList = this.m_EventID_JobsIDList.get(eventStr);
                    if (null == eventJobsList) {
                        eventJobsList = new ArrayList();
                    }
                    if (!eventJobsList.contains(jobIDStr)) {
                        eventJobsList.add(jobIDStr);
                        this.m_EventID_JobsIDList.put(eventStr, eventJobsList);
                    }
                }
                if (!(jobNameStr = reader.getValues()[index_JOBMST_NAME]).isEmpty()) {
                    this.m_JobID_Name.put(jobIDStr, jobNameStr);
                    this.m_JobName_ID.put(jobNameStr, jobIDStr);
                } else {
                    ConversionLogger.getLogger().info("Job Name is empty for id:" + jobIDStr);
                }
                this.m_JobID_Info.put(jobIDStr, tempArray);
                ++this.m_rowsCount;
            }
            reader.close();
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error in loadJOBMSTCSVFiles");
            sb.append("File : " + fileName);
            sb.append("Exception while reading csv file: " + String.valueOf(e));
            ConversionLogger.getLogger().info(sb.toString());
        }
    }

    public void loadJOBDTLCSVFiles(String fileName) {
        int d = 0;
        try {
            CsvReader reader = new CsvReader(fileName);
            reader.setSafetySwitch(false);
            String jobIDStr = "";
            int index_JOBDTL_ID = 0;
            String jobCMDStr = "";
            int index_JOBDTL_CMD = 1;
            String nodeMstIdStr = "";
            int index_NODEMST_ID = 21;
            reader.readRecord();
            while (reader.readRecord()) {
                jobIDStr = reader.getValues()[index_JOBDTL_ID];
                jobCMDStr = reader.getValues()[index_JOBDTL_CMD];
                this.m_JobID_Command.put(jobIDStr, jobCMDStr);
                nodeMstIdStr = reader.getValues()[index_NODEMST_ID];
                if (!nodeMstIdStr.equals("")) {
                    int count = this.m_Nodes_2_Jobs_Count.containsKey(nodeMstIdStr) ? this.m_Nodes_2_Jobs_Count.get(nodeMstIdStr) : 0;
                    this.m_Nodes_2_Jobs_Count.put(nodeMstIdStr, count + 1);
                }
                ++d;
            }
            reader.close();
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.logExceptionMessage(fileName, d, ioobe);
            throw new ConversionRuntimeException("access non existing column number " + ioobe.getMessage() + " in jobdtl csv file", (RuntimeException)ioobe);
        }
        catch (IOException e) {
            this.logExceptionMessage(fileName, d, e);
        }
    }

    private <E extends Exception> void logExceptionMessage(String fileName, int d, E e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error in loadJOBDTLCSVFiles");
        sb.append("File : " + fileName);
        System.out.println("Line : " + d);
        sb.append("Exception while reading csv file: " + String.valueOf(e));
        ConversionLogger.getLogger().info(sb.toString());
    }

    public HashMap<String, Integer> getNodesJobsCount() {
        return this.m_Nodes_2_Jobs_Count;
    }

    public List<String> getAgentGroupsList() {
        return new ArrayList<String>(this.m_NodLSTMS_Id_2_Name.keySet());
    }

    public String getAgentGroupName(String agentListId) {
        return this.m_NodLSTMS_Id_2_Name.get(agentListId);
    }

    public String getAgentListCount() {
        return String.valueOf(this.m_NodLSTMS_Id_2_Name.size());
    }

    public String getAgentId(String name) {
        return this.agentsIdForNames.get(name);
    }

    public String getParent(String son) {
        return this.agentsGroupTree.get(son);
    }

    public boolean isRoot(String parent) {
        Boolean isRoot = this.hirarchyStrct.get(parent);
        return isRoot == null || isRoot != false;
    }

    public String getNodeName(String id) {
        return this.mstNodeMap.get(id);
    }

    public ArrayList<String> getAgentGroupsMembersLists() {
        ArrayList<String> agentListLists = new ArrayList<String>(this.lstdtNodeMap.keySet());
        agentListLists.removeAll(Collections.singleton(null));
        return agentListLists;
    }

    public List<String> getMembersforAgentGroup(String agentListKey) {
        return this.lstdtNodeMap.get(agentListKey);
    }

    public void loadEVNTMSTCSVFiles(String fileName) {
        try {
            CsvReader reader = new CsvReader(fileName);
            String eventIDStr = "";
            int index_event_ID = 0;
            String eventNameStr = "";
            int index_event_Name = 1;
            reader.readRecord();
            while (reader.readRecord()) {
                eventIDStr = reader.getValues()[index_event_ID];
                if (!this.m_EventID_JobsIDList.containsKey(eventIDStr)) continue;
                eventNameStr = reader.getValues()[index_event_Name];
                this.m_EventID_EventName.put(eventIDStr, eventNameStr);
                this.m_EventName_EventID.put(eventNameStr, eventIDStr);
            }
            reader.close();
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error in loadEVNTMSTCSVFiles");
            sb.append("File : " + fileName);
            sb.append("Exception while reading csv file: " + String.valueOf(e));
            ConversionLogger.getLogger().info(sb.toString());
        }
    }

    public void createBoxesHierarchy() {
        SourceDataBox tempBox = null;
        SourceDataBox tempChildBox = null;
        ArrayList<String> sonsList = null;
        HashMap<String, SourceDataBox> tempBoxesMap = new HashMap<String, SourceDataBox>();
        HashMap<String, ArrayList<String>> tempJobID_SonsList = new HashMap<String, ArrayList<String>>(this.m_JobID_SonsList);
        ArrayList<String> parentsList = new ArrayList<String>();
        parentsList.addAll(this.m_JobID_SonsList.keySet());
        for (String strBox : tempJobID_SonsList.keySet()) {
            if (this.m_singleJobs.contains(strBox)) {
                this.m_singleJobs.remove(strBox);
                this.m_JobID_ParentID.remove(strBox);
            }
            if (null == (tempBox = (SourceDataBox)tempBoxesMap.get(strBox))) {
                tempBox = new SourceDataBox(strBox);
            }
            sonsList = tempJobID_SonsList.get(strBox);
            Iterator<String> iter = sonsList.iterator();
            while (iter.hasNext()) {
                String strChild = iter.next();
                if (parentsList.contains(strChild)) {
                    parentsList.remove(strChild);
                }
                if (!tempJobID_SonsList.containsKey(strChild)) {
                    ++this.m_jobsInsideBoxesCount;
                    tempBox.AddJobToList(strChild);
                    if (null != this.m_EventID_JobsIDList.get(this.m_JobID_EventID.get(strBox)) && !this.m_EventID_JobsIDList.get(this.m_JobID_EventID.get(strBox)).contains(strChild)) {
                        this.m_EventID_JobsIDList.get(this.m_JobID_EventID.get(strBox)).add(strChild);
                    }
                    iter.remove();
                    continue;
                }
                tempChildBox = (SourceDataBox)tempBoxesMap.get(strChild);
                if (null == tempChildBox) {
                    tempChildBox = new SourceDataBox(strChild);
                    tempBoxesMap.put(strChild, tempChildBox);
                }
                tempBox.AddBoxToList(tempChildBox);
            }
            tempBoxesMap.put(strBox, tempBox);
        }
        sonsList = null;
        for (String parent : parentsList) {
            this.m_boxes.put(parent, (SourceDataBox)tempBoxesMap.get(parent));
        }
    }

    public void createCalendarHierarchy() {
        HashMap mapParentID_SonsList = new HashMap();
        String eventSonID = null;
        for (String sonID : this.m_JobID_ParentID.keySet()) {
            eventSonID = this.m_JobID_EventID.get(this.m_JobID_ParentID.get(sonID));
            if (null != eventSonID) continue;
            String tempParent = this.m_JobID_ParentID.get(sonID);
            while (this.m_JobID_ParentID.containsKey(tempParent)) {
                tempParent = this.m_JobID_ParentID.get(tempParent);
            }
            if (tempParent.isEmpty()) continue;
            ArrayList<String> tempList = (ArrayList<String>)mapParentID_SonsList.get(tempParent);
            if (null == tempList) {
                tempList = new ArrayList<String>();
            }
            if (!tempList.contains(sonID)) {
                tempList.add(sonID);
            }
            mapParentID_SonsList.put(tempParent, tempList);
        }
        for (String parentID : mapParentID_SonsList.keySet()) {
            String eventStr = this.m_JobID_EventID.get(parentID);
            if (null == eventStr) continue;
            ArrayList<String> jobsList = this.m_EventID_JobsIDList.get(eventStr);
            if (null == jobsList) {
                jobsList = new ArrayList();
            }
            for (String newJob : (ArrayList)mapParentID_SonsList.get(parentID)) {
                if (jobsList.contains(newJob)) continue;
                jobsList.add(newJob);
            }
            this.m_EventID_JobsIDList.put(eventStr, jobsList);
        }
    }
}

