/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFilteredTree;
import com.bmc.ctmconvert.base.BaseListCellRenderer;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseSplitPane;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDataBox;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.tidal.SourceDataTidalCSVManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class SourceDataTidal
extends BasePanel
implements ActionListener,
TreeSelectionListener {
    private SourceDataTidalCSVManager m_SDReport = null;
    private JTextArea m_jobsInfoAreaText = null;
    private JList m_jobsSelectingList = null;
    private String m_treeNodeParentName = "";
    private String m_newline = System.getProperty("line.separator");
    private boolean m_bNodeView = false;
    private boolean m_bJobAreaIncreased = false;
    private static final String m_sJobs = "Jobs";
    private static final String m_sCalendars = "Calendars";
    private static final String m_sNodes = "Agent Lists";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private HashMap<String, String> m_nodeName_nodeDescription;
    private int m_boxesCounter = 0;
    private int m_calendarsCounter = 0;
    private int m_jobsCounter = 0;
    private int m_jobsInCalendarsCounter = 0;
    private BaseSplitPane mainSplitPane;
    private BaseSplitPane rightHandSplitPane;
    private BaseFilteredTree mainTree;
    private static final int lowMachinesThreshold = 25;
    private int lowMachinesUseCount = 0;
    private ArrayList<String> listNamesOflowMachinesUse = new ArrayList();
    private HashMap<Object, String> m_Node_JobID = new HashMap();
    private HashMap<Object, String> m_Node_AgentID = new HashMap();

    public SourceDataTidal(String fileName, String descriptionXMLFileName) {
        this.init(fileName, descriptionXMLFileName);
    }

    private void init(String fileName, String descriptionXMLFileName) {
        if (null != this.m_SDReport) {
            this.m_SDReport = null;
        }
        String path = fileName;
        this.m_SDReport = new SourceDataTidalCSVManager(path + Globs.DIRSEP + "JOBMST.csv", path + Globs.DIRSEP + "JOBDTL.csv", path + Globs.DIRSEP + "EVNTMST.csv", path + Globs.DIRSEP + "NODMST.csv", path + Globs.DIRSEP + "NODLSTMS.csv", path + Globs.DIRSEP + "NODLSTDT.csv");
        this.createTreePanel();
        this.createRightHandPanel();
        this.fillListOfLowMachineUse();
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.m_nodeName_nodeDescription = this.getDescriptionNodes();
        this.mainTree.setSelectionRow(0);
        this.updateRightHandPanel();
        this.baseContentPanel = new BaseContentPanel();
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.CLOSE}));
        this.mainSplitPane = new BaseSplitPane(1, this.mainTree.getComponent(), this.rightHandSplitPane.getComponent());
        this.baseContentPanel.setContentPanel((BaseComponent)this.mainSplitPane);
        this.setContentPanel(this.baseContentPanel);
    }

    private void fillListOfLowMachineUse() {
        HashMap<String, Integer> nodes = this.m_SDReport.getNodesJobsCount();
        for (String nodeId : nodes.keySet()) {
            String nodeName;
            if (nodes.get(nodeId) > 25 || (nodeName = this.m_SDReport.getNodeName(nodeId)) == null) continue;
            this.listNamesOflowMachinesUse.add(nodeName);
            ++this.lowMachinesUseCount;
        }
    }

    public void setSelectedRow() {
        int selectedRow = this.mainTree.getSelectionRow();
        this.mainTree.setSelectionRow(-1);
        this.mainTree.setSelectionRow(selectedRow);
        this.mainTree.requestFocus();
    }

    private void createRightHandPanel() {
        this.rightHandSplitPane = new BaseSplitPane(0);
        this.increaseJobsInfoArea();
    }

    private void updateRightHandPanel() {
        if (null != this.m_jobsSelectingList) {
            JScrollPane selectionList = new JScrollPane(this.m_jobsSelectingList);
            selectionList.setBorder(null);
            this.rightHandSplitPane.setComponent((Component)selectionList, BaseSplitPane.ComponentPosition.TOP);
        } else {
            this.rightHandSplitPane.setComponent(null, BaseSplitPane.ComponentPosition.TOP);
        }
        if (null != this.m_jobsInfoAreaText) {
            JScrollPane jobInfo = new JScrollPane(this.m_jobsInfoAreaText);
            jobInfo.setBorder(null);
            this.rightHandSplitPane.setComponent((Component)jobInfo, BaseSplitPane.ComponentPosition.BOTTOM);
            this.m_jobsInfoAreaText.setSelectionStart(0);
            this.m_jobsInfoAreaText.setSelectionEnd(0);
        } else {
            this.rightHandSplitPane.setComponent(null, BaseSplitPane.ComponentPosition.BOTTOM);
        }
    }

    private void updateJobsInfoArea(String messageID, boolean clearJobsInfoArea) {
        StringBuilder formatedData = new StringBuilder();
        if (!clearJobsInfoArea) {
            String[] columns = this.m_SDReport.getColumnsHeaders();
            String[] jobInfo = this.m_SDReport.getJobInfo(messageID);
            String jobCMD = null;
            if (null != jobInfo) {
                for (int i = 0; i < columns.length; ++i) {
                    if (jobInfo[i].equalsIgnoreCase("NULL") || jobInfo[i].isEmpty()) continue;
                    formatedData.append(columns[i]);
                    formatedData.append(" : ");
                    formatedData.append(jobInfo[i]);
                    formatedData.append(this.m_newline);
                }
            }
            if (null != (jobCMD = this.m_SDReport.getJobCommand(messageID)) && !jobCMD.isEmpty()) {
                formatedData.append(this.m_newline);
                formatedData.append("Command line : ");
                formatedData.append(jobCMD);
                formatedData.append(this.m_newline);
            }
        }
        this.m_jobsInfoAreaText.setText(formatedData.toString());
        this.m_jobsInfoAreaText.setSelectionStart(0);
        this.m_jobsInfoAreaText.setSelectionEnd(0);
    }

    private void updateGroupAgentsInfoArea(String messageID, boolean clearAgentsInfoArea) {
        StringBuilder formatedData = new StringBuilder();
        if (!clearAgentsInfoArea) {
            String[] columns = this.m_SDReport.getGroupAgentscolumnsHeaders();
            String[] agentInfo = this.m_SDReport.getGroupAgentsInfo(messageID);
            if (null != agentInfo) {
                for (int i = 0; i < columns.length; ++i) {
                    if (agentInfo[i].equalsIgnoreCase("NULL") || agentInfo[i].isEmpty()) continue;
                    formatedData.append(columns[i]);
                    formatedData.append(" : ");
                    formatedData.append(agentInfo[i]);
                    formatedData.append(this.m_newline);
                }
            }
        }
        this.m_jobsInfoAreaText.setText(formatedData.toString());
        this.m_jobsInfoAreaText.setSelectionStart(0);
        this.m_jobsInfoAreaText.setSelectionEnd(0);
    }

    private void updateAgentsInfoArea(String messageID, boolean clearAgentsInfoArea) {
        StringBuilder formatedData = new StringBuilder();
        if (!clearAgentsInfoArea) {
            String[] columns = this.m_SDReport.getAgentscolumnsHeaders();
            String[] agentInfo = this.m_SDReport.getAgentsInfo(messageID);
            if (null != agentInfo) {
                for (int i = 0; i < columns.length; ++i) {
                    if (agentInfo[i].equalsIgnoreCase("NULL") || agentInfo[i].isEmpty()) continue;
                    formatedData.append(columns[i]);
                    formatedData.append(" : ");
                    formatedData.append(agentInfo[i]);
                    formatedData.append(this.m_newline);
                }
            }
        }
        this.m_jobsInfoAreaText.setText(formatedData.toString());
        this.m_jobsInfoAreaText.setSelectionStart(0);
        this.m_jobsInfoAreaText.setSelectionEnd(0);
    }

    private void decreaseJobsInfoArea() {
        if (null != this.m_jobsInfoAreaText) {
            this.m_jobsInfoAreaText.removeAll();
            this.m_jobsInfoAreaText = null;
        }
        this.m_jobsInfoAreaText = new JTextArea();
        this.m_jobsInfoAreaText.setEditable(false);
        this.m_jobsInfoAreaText.setBackground(Color.WHITE);
        if (null != this.m_jobsSelectingList) {
            this.m_jobsSelectingList.removeAll();
            this.m_jobsSelectingList = null;
        }
        this.m_jobsSelectingList = new JList();
        this.m_jobsSelectingList.setCellRenderer(new BaseListCellRenderer());
        this.m_jobsSelectingList.setSelectionMode(0);
        this.m_jobsSelectingList.setFixedCellHeight(20);
        this.m_jobsSelectingList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList jListSource = (JList)e.getSource();
                Object[] selection = jListSource.getSelectedValues();
                if (!e.getValueIsAdjusting()) {
                    for (int i = 0; i < selection.length; ++i) {
                        SourceDataTidal.this.updateJobsInfoArea(SourceDataTidal.this.m_SDReport.getJobID((String)selection[i]), false);
                    }
                }
            }
        });
        this.updateRightHandPanel();
    }

    private void increaseJobsInfoArea() {
        if (null != this.m_jobsSelectingList) {
            this.m_jobsSelectingList = null;
        }
        this.updateRightHandPanel();
    }

    private void updateListArea(String parentID, String messageID, boolean clearList) {
        if (clearList) {
            this.m_jobsSelectingList.removeAll();
            this.m_jobsSelectingList.setModel(new DefaultListModel());
        } else if (parentID.startsWith(m_sCalendars)) {
            ArrayList<String> allJobs = this.m_SDReport.getCalendarsJobsNames(messageID);
            this.m_jobsSelectingList.removeAll();
            if (null != allJobs) {
                this.m_jobsSelectingList.setListData(allJobs.toArray());
            }
        }
        this.m_jobsSelectingList.updateUI();
    }

    private void createTreePanel() {
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode jobsNodes = new DefaultMutableTreeNode("Jobs(" + this.m_SDReport.getJobsNumber() + ")");
        DefaultMutableTreeNode calendarsNodes = null;
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode agentLists = new DefaultMutableTreeNode("Agent Lists(" + this.m_SDReport.getAgentListCount() + ")");
        DefaultMutableTreeNode agentList = null;
        this.m_jobsCounter = this.m_SDReport.getJobsNumber();
        StringBuilder nodeName = new StringBuilder();
        TreeSet<String> boxesList = new TreeSet<String>(this.m_SDReport.getBoxesList());
        if (null != boxesList) {
            for (String string : boxesList) {
                node = this.getBoxSubTree(this.m_SDReport.getBoxByID(string));
                if (null == node) continue;
                jobsNodes.add(node);
                this.m_Node_JobID.put(node.toString(), string);
            }
        }
        ArrayList<String> childrenList = null;
        childrenList = this.m_SDReport.getAllSingleJobs();
        for (String singleChildJob : childrenList) {
            node = new DefaultMutableTreeNode(this.m_SDReport.getJobName(singleChildJob));
            this.m_Node_JobID.put(node.toString(), singleChildJob);
            jobsNodes.add(node);
        }
        ArrayList<String> arrayList = this.m_SDReport.getCalendarsList();
        if (null != arrayList) {
            Collections.sort(arrayList);
            if (arrayList.size() > 0) {
                calendarsNodes = new DefaultMutableTreeNode("Calendars(" + arrayList.size() + ")");
                this.m_calendarsCounter = arrayList.size();
                for (String calendar : arrayList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(calendar);
                    nodeName.append("(");
                    nodeName.append(this.m_SDReport.getCalendarsJobsNames(calendar).size());
                    nodeName.append(")");
                    node = new DefaultMutableTreeNode(nodeName.toString());
                    calendarsNodes.add(node);
                    this.m_jobsInCalendarsCounter += this.m_SDReport.getCalendarsJobsNames(calendar).size();
                }
            }
        }
        agentLists = this.handleAgentLists(agentLists, agentList, node);
        if (null != jobsNodes) {
            mainTreeNodes.add(jobsNodes);
        }
        if (null != calendarsNodes) {
            mainTreeNodes.add(calendarsNodes);
        }
        if (null != agentLists) {
            mainTreeNodes.add(agentLists);
        }
        this.mainTree = new BaseFilteredTree(mainTreeNodes);
        this.mainTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private DefaultMutableTreeNode handleRootAgentGroup(HashMap<String, DefaultMutableTreeNode> listOfRoots, String agentGroupId, DefaultMutableTreeNode agentList) {
        if (listOfRoots.containsKey(agentGroupId)) {
            agentList = listOfRoots.get(agentGroupId);
        } else {
            String agentGroupName = this.m_SDReport.getAgentGroupName(agentGroupId);
            agentList = new DefaultMutableTreeNode(agentGroupName);
            listOfRoots.put(agentGroupId, agentList);
        }
        List<String> membersList = this.m_SDReport.getMembersforAgentGroup(agentGroupId);
        if (membersList != null && !membersList.isEmpty()) {
            for (String childId : membersList) {
                String childName = this.m_SDReport.getNodeName(childId);
                if (this.m_SDReport.getParent(childId) != null && (this.m_SDReport.getParent(childId) == null || !this.m_SDReport.getParent(childId).equals(agentGroupId))) continue;
                agentList.add(new DefaultMutableTreeNode(childName));
            }
        }
        return agentList;
    }

    private DefaultMutableTreeNode handleAgentLists(DefaultMutableTreeNode agentLists, DefaultMutableTreeNode agentList, DefaultMutableTreeNode node) {
        ArrayList<String> agentListsList = this.m_SDReport.getAgentGroupsMembersLists();
        HashMap<String, DefaultMutableTreeNode> listOfRoots = new HashMap<String, DefaultMutableTreeNode>();
        HashMap<String, DefaultMutableTreeNode> listOfAgentGroups = new HashMap<String, DefaultMutableTreeNode>();
        if (agentListsList != null && agentListsList.size() > 0) {
            Collections.sort(agentListsList);
            DefaultMutableTreeNode agentGroupIdBeforeRoot = null;
            for (String agentGroupId : agentListsList) {
                if (this.m_SDReport.isRoot(agentGroupId)) {
                    agentList = this.handleRootAgentGroup(listOfRoots, agentGroupId, agentList);
                } else {
                    String agentGroupName = this.m_SDReport.getAgentGroupName(agentGroupId);
                    DefaultMutableTreeNode parentNode = null;
                    while (!this.m_SDReport.isRoot(agentGroupId)) {
                        List<String> membersList = this.m_SDReport.getMembersforAgentGroup(agentGroupId);
                        if (membersList != null && !membersList.isEmpty()) {
                            for (String menberId : membersList) {
                                String memberName = this.m_SDReport.getNodeName(menberId);
                                agentGroupName = this.m_SDReport.getAgentGroupName(agentGroupId);
                                if (parentNode == null) {
                                    parentNode = new DefaultMutableTreeNode(agentGroupName);
                                }
                                if (memberName == null || memberName.equals("") || this.m_SDReport.getParent(menberId) != null && (this.m_SDReport.getParent(menberId) == null || !this.m_SDReport.getParent(menberId).equals(agentGroupId))) continue;
                                boolean childAlreadyExist = false;
                                for (int i = 0; i < parentNode.getChildCount(); ++i) {
                                    DefaultMutableTreeNode localChild = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                                    if (!localChild.getUserObject().toString().equals(memberName)) continue;
                                    childAlreadyExist = true;
                                    break;
                                }
                                if (childAlreadyExist) continue;
                                parentNode.add(new DefaultMutableTreeNode(memberName));
                            }
                        }
                        if (!listOfAgentGroups.containsKey(agentGroupId)) {
                            listOfAgentGroups.put(agentGroupId, parentNode);
                        }
                        agentGroupIdBeforeRoot = parentNode;
                        agentGroupId = this.m_SDReport.getParent(agentGroupId);
                        DefaultMutableTreeNode localNode = null;
                        if (!listOfAgentGroups.containsKey(agentGroupId)) {
                            agentGroupName = this.m_SDReport.getAgentGroupName(agentGroupId);
                            listOfAgentGroups.put(agentGroupId, new DefaultMutableTreeNode(agentGroupName));
                            localNode = parentNode;
                        } else {
                            localNode = (DefaultMutableTreeNode)listOfAgentGroups.get(agentGroupId);
                            localNode.add(parentNode);
                        }
                        parentNode = localNode;
                    }
                    if (this.m_SDReport.isRoot(agentGroupId)) {
                        if (listOfRoots.containsKey(agentGroupId)) {
                            agentList = listOfRoots.get(agentGroupId);
                        } else {
                            agentGroupName = this.m_SDReport.getAgentGroupName(agentGroupId);
                            if (!listOfRoots.containsKey(agentGroupId)) {
                                agentList = new DefaultMutableTreeNode(agentGroupName);
                                listOfRoots.put(agentGroupId, agentList);
                            } else {
                                agentList = listOfRoots.get(agentGroupId);
                            }
                        }
                        if (agentGroupIdBeforeRoot == null) {
                            agentGroupIdBeforeRoot = parentNode;
                        }
                        agentList.add(agentGroupIdBeforeRoot);
                    }
                }
                agentLists.add(agentList);
            }
        }
        agentLists = this.handleAgentListWithoutAgents(agentLists, agentList, agentListsList, listOfRoots);
        return agentLists;
    }

    private DefaultMutableTreeNode handleAgentListWithoutAgents(DefaultMutableTreeNode agentLists, DefaultMutableTreeNode agentList, ArrayList<String> agentListsList, HashMap<String, DefaultMutableTreeNode> listOfRoots) {
        List<String> listOfAgentsGroups = this.m_SDReport.getAgentGroupsList();
        for (String agentsGroupId : listOfAgentsGroups) {
            List<String> membersforAgentGroup = this.m_SDReport.getMembersforAgentGroup(agentsGroupId);
            if (membersforAgentGroup != null && !membersforAgentGroup.isEmpty() || listOfRoots.containsKey(agentsGroupId)) continue;
            String agentListName = this.m_SDReport.getAgentGroupName(agentsGroupId);
            agentList = new DefaultMutableTreeNode(agentListName);
            agentLists.add(agentList);
        }
        return agentLists;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        int level;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.mainTree.getLastSelectedPathComponent();
        this.m_treeNodeParentName = "";
        if (node == null) {
            return;
        }
        String sNodeParent = "";
        DefaultMutableTreeNode nodeParent = null;
        DefaultMutableTreeNode chosenNode = node;
        if (!node.isRoot()) {
            while (null != node.getParent()) {
                nodeParent = node;
                node = (DefaultMutableTreeNode)node.getParent();
            }
            sNodeParent = ((Object)nodeParent).toString();
        }
        if ((level = chosenNode.getLevel()) <= 1) {
            this.increaseJobsInfoArea();
            this.m_bJobAreaIncreased = true;
            String description = chosenNode.toString().split("\\(")[0];
            this.setDescriptionArea(this.m_nodeName_nodeDescription.get(description));
        } else {
            String nodeInfo = this.m_Node_JobID.get(chosenNode.toString());
            if (nodeInfo == null) {
                nodeInfo = this.m_SDReport.getAgentId(chosenNode.toString());
            }
            this.m_bNodeView = sNodeParent.startsWith(m_sJobs);
            if (!this.m_bNodeView) {
                this.m_bNodeView = sNodeParent.startsWith(m_sNodes);
            }
            boolean agentsFlag = false;
            if (sNodeParent.matches("Agent Lists\\(\\d+\\)")) {
                agentsFlag = true;
            }
            if (chosenNode.isLeaf()) {
                this.m_treeNodeParentName = sNodeParent;
                if (sNodeParent.matches("Agent Lists\\(\\d+\\)")) {
                    this.updateAgentsInfoArea(nodeInfo.toString(), false);
                } else if (!this.m_bNodeView) {
                    String[] nodeType;
                    if (this.m_bJobAreaIncreased) {
                        this.decreaseJobsInfoArea();
                        this.m_bJobAreaIncreased = false;
                    }
                    nodeInfo = (nodeType = chosenNode.toString().split("\\(")).length == 2 ? nodeType[0] : this.splitString(chosenNode.toString());
                    this.updateListArea(this.m_treeNodeParentName, nodeInfo.toString(), false);
                    this.updateJobsInfoArea(nodeInfo.toString(), true);
                } else {
                    if (!this.m_bJobAreaIncreased) {
                        this.increaseJobsInfoArea();
                        this.m_bJobAreaIncreased = true;
                    }
                    if (chosenNode.toString().endsWith("(0)")) {
                        String[] sNodeInfo = chosenNode.toString().split("\\(");
                        String nodeName = sNodeInfo.length == 2 ? sNodeInfo[0] : this.splitString(chosenNode.toString());
                        this.updateJobsInfoArea(nodeName, false);
                    } else {
                        this.updateJobsInfoArea(nodeInfo.toString(), false);
                    }
                }
            } else if (!this.m_bNodeView) {
                if (this.m_bJobAreaIncreased) {
                    this.decreaseJobsInfoArea();
                    this.m_bJobAreaIncreased = false;
                }
                this.updateListArea(this.m_treeNodeParentName, "", true);
                this.updateJobsInfoArea("", true);
            } else {
                if (!this.m_bJobAreaIncreased) {
                    this.increaseJobsInfoArea();
                    this.m_bJobAreaIncreased = true;
                }
                if (chosenNode.toString().equals(sNodeParent)) {
                    if (!agentsFlag) {
                        this.updateJobsInfoArea("", true);
                    } else {
                        this.updateGroupAgentsInfoArea("", true);
                    }
                } else if (!agentsFlag) {
                    this.updateJobsInfoArea(nodeInfo.toString(), false);
                } else {
                    this.updateGroupAgentsInfoArea(nodeInfo.toString(), false);
                }
            }
        }
        if (this.m_jobsSelectingList != null) {
            this.m_jobsSelectingList.setSelectedIndex(0);
        }
    }

    public DefaultMutableTreeNode getAgentsBoxSubTree(SourceDataBox box) {
        ArrayList jobs;
        if (null == box) {
            return null;
        }
        String id = box.getBoxName();
        int size = box.size();
        String nodeName = this.m_SDReport.getNodeName(id);
        if (nodeName == null) {
            nodeName = this.m_SDReport.getAgentGroupName(id);
        }
        DefaultMutableTreeNode boxNode = new DefaultMutableTreeNode(nodeName + "(" + size + ")");
        ++this.m_boxesCounter;
        ArrayList boxes = box.getBoxesList();
        if (null != boxes && boxes.size() > 0) {
            DefaultMutableTreeNode node = null;
            for (SourceDataBox tempBox : boxes) {
                node = this.getAgentsBoxSubTree(tempBox);
                if (null == node) continue;
                boxNode.add(node);
                this.m_Node_AgentID.put(node.toString(), tempBox.getBoxName());
            }
        }
        if (null != (jobs = box.getJobsList()) && jobs.size() > 0) {
            DefaultMutableTreeNode node = null;
            for (String job : jobs) {
                node = new DefaultMutableTreeNode(this.m_SDReport.getJobName(job));
                boxNode.add(node);
                this.m_Node_JobID.put(node.toString(), job);
            }
        }
        return boxNode;
    }

    public DefaultMutableTreeNode getBoxSubTree(SourceDataBox box) {
        ArrayList jobs;
        if (null == box) {
            return null;
        }
        String name = box.getBoxName();
        int size = box.size();
        DefaultMutableTreeNode boxNode = new DefaultMutableTreeNode(this.m_SDReport.getJobName(name) + "(" + size + ")");
        ++this.m_boxesCounter;
        ArrayList boxes = box.getBoxesList();
        if (null != boxes && boxes.size() > 0) {
            DefaultMutableTreeNode node = null;
            for (SourceDataBox tempBox : boxes) {
                node = this.getBoxSubTree(tempBox);
                if (null == node) continue;
                boxNode.add(node);
                this.m_Node_JobID.put(node.toString(), tempBox.getBoxName());
            }
        }
        if (null != (jobs = box.getJobsList()) && jobs.size() > 0) {
            DefaultMutableTreeNode node = null;
            for (String job : jobs) {
                node = new DefaultMutableTreeNode(this.m_SDReport.getJobName(job));
                boxNode.add(node);
                this.m_Node_JobID.put(node.toString(), job);
            }
        }
        return boxNode;
    }

    public String splitString(String inSTR) {
        StringTokenizer st = new StringTokenizer(inSTR.toString(), "\\(\\)", true);
        Object sNodeInfo = "";
        String[] tempArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tempArray[i] = st.nextToken();
            ++i;
        }
        for (i = 0; i < tempArray.length - 3; ++i) {
            sNodeInfo = (String)sNodeInfo + tempArray[i];
        }
        return sNodeInfo;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        String sMainSummary;
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:");
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
        String extraSummary = null;
        for (String nodeName : ((HashMap)descriptionMap_NodeName_NodeDesc).keySet()) {
            if (this.m_DescriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = (String)((HashMap)descriptionMap_NodeName_NodeDesc).get(nodeName);
                } else {
                    mainSummary.append(nodeName);
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)((HashMap)descriptionMap_NodeName_NodeDesc).get(nodeName)));
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.m_newline);
                }
            }
            descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, (String)((HashMap)descriptionMap_NodeName_NodeDesc).get(nodeName)));
        }
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(this.m_newline);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(this.m_newline);
            mainSummary.append(this.m_newline);
        }
        if (!this.m_DescriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)((HashMap)descriptionMap_NodeName_NodeDesc).get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)((HashMap)descriptionMap_NodeName_NodeDesc).get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(this.m_newline);
                mainSummary.append(this.m_newline);
                mainSummary.append("ExtraSummary");
                mainSummary.append(this.m_newline);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(this.m_newline);
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    public String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        String numInflu = Integer.toString(sNodeName.startsWith(m_sCalendars) ? this.m_jobsInCalendarsCounter : this.m_jobsCounter);
        sDescription = sDescription.replaceAll("#NUM_INFL_JOB#", numInflu);
        String numEnti = Integer.toString(sNodeName.startsWith(m_sCalendars) ? this.m_calendarsCounter : this.m_jobsCounter);
        sDescription = sDescription.replaceAll("#NUM_ENTITIES#", numEnti);
        sDescription = sDescription.replaceAll("#NUM_TABLES#", Integer.toString(this.m_boxesCounter));
        sDescription = sDescription.replaceAll("#ENV_NAME#", Params.instance().getDatasourceName());
        if ((sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES#", Integer.toString(this.lowMachinesUseCount))).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            for (String machine : this.listNamesOflowMachinesUse) {
                machinesList.append(machine);
                machinesList.append(this.m_newline);
            }
            sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        sDescription = sDescription.replaceAll("#NUM_USED_AGENTS#", Integer.toString(this.getUsedNodeCount()));
        return sDescription;
    }

    private int getUsedNodeCount() {
        int count = 0;
        for (String node : this.m_SDReport.getNodesJobsCount().keySet()) {
            count += this.m_SDReport.getNodesJobsCount().get(node) > 0 ? 1 : 0;
        }
        return count;
    }

    private void setDescriptionArea(String sDescription) {
        if (null != sDescription) {
            if (!sDescription.isEmpty()) {
                if (null == this.m_jobsInfoAreaText) {
                    this.m_jobsInfoAreaText = new JTextArea();
                    this.m_jobsInfoAreaText.setEditable(false);
                    this.m_jobsInfoAreaText.setBackground(Color.WHITE);
                }
                this.m_jobsInfoAreaText.setText(sDescription);
            } else if (null != this.m_jobsInfoAreaText) {
                this.m_jobsInfoAreaText = null;
            }
        } else if (null != this.m_jobsInfoAreaText) {
            this.m_jobsInfoAreaText.setText("");
        }
        this.updateRightHandPanel();
    }

    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.fireNavegationEvent(actionCommand);
        }
    }
}

