/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.exceptions.RBCIllegalValueException;
import com.bmc.ctmconvert.common.message.MessageRegistry;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.tidal.RbcRetriever;
import com.bmc.ctmconvert.tidal.utils.ConvertDateUtils;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RbcFactory {
    private static final int RBC_NAME_MAX_LENGTH = 19;
    public static final String EVNTMST_MONTHS = "EVNTMST_MONTHS";
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY_WITH_DAYS = 4;
    public static final int MONTHLY_WITH_WEEKS = 5;
    public static final int LIST = 6;
    public static final int GROUP = 1;
    public static final int SUBSET = 7;
    private static HashMap<Integer, String> idToUsedName;
    private Function<String, String> forceValidName;
    private BiFunction<String, String, String> firstDayOfWeekRule;
    private static final int EVNTMST_MONTHDAYS_LASTCHAR = 32;
    private final String allDaysCtmCalendarName = "ALLDAYS";
    private Optional<CtmCalendar> ctmCalendar;
    private final RbcRetriever.EventGetter eventGetter;
    private final RbcRetriever.EventConditionsGetter eventConditionsGetter;
    private final RbcRetriever.EventYearListGetter eventYearListGetter;
    private final RbcRetriever.GroupChildrenGetter groupChildrenGetter;

    public RbcFactory(RbcRetriever.GroupChildrenGetter groupChildrenGetter, RbcRetriever.EventYearListGetter eventYearListGetter, RbcRetriever.EventConditionsGetter eventConditionsGetter, RbcRetriever.EventGetter eventGetter) {
        this.groupChildrenGetter = groupChildrenGetter;
        this.eventYearListGetter = eventYearListGetter;
        this.eventConditionsGetter = eventConditionsGetter;
        this.eventGetter = eventGetter;
        if (idToUsedName == null) {
            RbcFactory.resetNames();
        }
    }

    public static void resetNames() {
        idToUsedName = new HashMap();
    }

    void setValidator(Function<String, String> validationFunction) {
        this.forceValidName = validationFunction;
    }

    void setFirstDayOfWeekRule(BiFunction<String, String, String> firstDayOfWeekRule) {
        this.firstDayOfWeekRule = firstDayOfWeekRule;
    }

    public void WriteCalendarsToFile(IAttrHolder eventMstRecord, DefCalFile defCalFile) {
        if (!this.isGroupCalendars(eventMstRecord)) {
            defCalFile.writeRBC(this.generateSingleRbc(eventMstRecord).getRBCForCalendarFile(true));
            this.ctmCalendar.ifPresent(ctmCal -> defCalFile.write(ctmCal, false));
        }
    }

    public void writeAllDaysCalendar(DefCalFile defCalFile) {
        defCalFile.write(CtmCalendar.createAllDaysCalendar((String)this.allDaysCtmCalendarName, (String)Params.instance().getDatacenterName()), false);
    }

    public List<RBC> generateRbcs(IAttrHolder eventMstRecord) {
        List<RBC> result;
        if (this.isGroupCalendars(eventMstRecord)) {
            result = this.getAllCalendarsInGroupCalendarType(eventMstRecord);
        } else {
            RBC tempResult = this.generateSingleRbc(eventMstRecord);
            result = Collections.singletonList(tempResult);
        }
        return result;
    }

    private RBC generateSingleRbc(IAttrHolder eventMstRecord) {
        this.ctmCalendar = Optional.empty();
        RBC result = this.genrateEmptyRBC(eventMstRecord);
        boolean isValidRBC = this.isSupportedFreqAndOffset(eventMstRecord, result);
        if (!this.isSupportedType(eventMstRecord, result)) {
            isValidRBC = false;
        }
        this.setRbcByType(eventMstRecord, result);
        result.getRBCForCalendarFile();
        if (result.isWeekdaysTruncated()) {
            String evntName = eventMstRecord.getAttr("EVNTMST_NAME");
            this.issueMessage(evntName, "WRN2328", evntName);
            this.addCalendarAction(evntName, "WRN2328 -The Conversion tool was unable to convert Tidal's calendar scheduling. The Calendar was converted to an empty Control-M Global Calendar. You will need to update Control-M Calendar manually to ensure it reflects the same scheduling behavior.");
            isValidRBC = false;
        }
        this.handleEventConditions(eventMstRecord, result);
        if (isValidRBC) {
            this.settingFirstDayOfTheWeek(result);
            String untilDt = eventMstRecord.getAttr("EVNTMST_UNTILDT");
            LocalDate untilDate = ConvertDateUtils.tryConvertDate(untilDt);
            String fromDt = eventMstRecord.getAttr("EVNTMST_FROMDT");
            LocalDate fromDate = ConvertDateUtils.tryConvertDate(fromDt);
            if (this.isDateConverted(fromDate)) {
                result.setActive_from(fromDate);
            }
            if (this.isDateConverted(untilDate)) {
                result.setActive_till(untilDate);
            }
            this.addMonths(eventMstRecord.getAttr(EVNTMST_MONTHS), result);
        } else {
            String resultName = result.getName();
            result = new RBC();
            result.setLevel(RBC.LEVEL.CONTROL_M);
            result.setName(resultName);
        }
        return result;
    }

    private void handleEventConditions(IAttrHolder eventMstRecord, RBC result) {
        Integer eventMstID = eventMstRecord.getAttrAsInt("EVNTMST_ID");
        List<IAttrHolder> eventConditions = this.eventConditionsGetter.getConditions(eventMstID);
        String originalCalendarName = Optional.ofNullable(eventMstRecord.getAttr("EVNTMST_NAME")).orElse("");
        if (eventConditions.size() == 1) {
            if (!this.isCalendarTypeList(eventMstRecord)) {
                this.handleEvntConditionInNonListCalendar(result, eventConditions.getFirst(), originalCalendarName);
            } else {
                this.issueMessage(originalCalendarName, "WRN2350", originalCalendarName, result.getName());
            }
        } else if (eventConditions.size() > 1) {
            this.issueMessage(originalCalendarName, "WRN2347", originalCalendarName, result.getName());
        }
    }

    private void handleEvntConditionInNonListCalendar(RBC result, IAttrHolder eventCondition, String originalCalendarName) {
        int confirmationCalendarID = eventCondition.getAttrAsInt("EVNTCOND_ACTIONID");
        IAttrHolder confirmationCalendarRecord = this.eventGetter.getEvent(confirmationCalendarID);
        if (this.isCalendarExist(confirmationCalendarRecord)) {
            if (this.isCalendarTypeList(confirmationCalendarRecord)) {
                this.addEvntConditionConfirmationCalendar(result, eventCondition, originalCalendarName, confirmationCalendarRecord);
            } else {
                this.issueMessage(originalCalendarName, "WRN2348", originalCalendarName, result.getName(), this.getCalendarType(confirmationCalendarRecord));
            }
        }
    }

    private boolean isCalendarExist(IAttrHolder confirmationCalendarRecord) {
        return confirmationCalendarRecord.isFieldExist("EVNTMST_TYPE");
    }

    private void addEvntConditionConfirmationCalendar(RBC result, IAttrHolder eventConditions, String originalCalendarName, IAttrHolder confirmationCalendarRecord) {
        result.setConfcal(confirmationCalendarRecord.getAttr("EVNTMST_ID"));
        int action = eventConditions.getAttrAsInt("EVNTCOND_ACTION");
        int offest = eventConditions.getAttrAsInt("EVNTCOND_OFFSET");
        switch (action) {
            case 1: {
                result.setShift(RBC.SHIFT.IGNOREJOB);
                break;
            }
            case 5: {
                result.setShift(RBC.SHIFT.PREVDAY);
                break;
            }
            case 6: {
                result.setShift(RBC.SHIFT.NEXTDAY);
                break;
            }
            default: {
                this.issueMessage(originalCalendarName, "WRN2349", originalCalendarName, result.getName(), this.getCalendarConditionActionName(action));
            }
        }
        result.setShiftnum(offest);
    }

    private String getCalendarType(IAttrHolder eventMstRecord) {
        int evntType = eventMstRecord.getAttrAsInt("EVNTMST_TYPE");
        String calendarType = "unknown";
        switch (evntType) {
            case 2: {
                calendarType = "DAILY";
                break;
            }
            case 3: {
                calendarType = "WEEKLY";
                break;
            }
            case 4: {
                calendarType = "MONTHLY WITH DAYS";
                break;
            }
            case 5: {
                calendarType = "MONTHLY WITH WEEKS";
                break;
            }
            case 6: {
                calendarType = "LIST";
                break;
            }
            case 7: {
                calendarType = "SUBSET";
            }
        }
        return calendarType;
    }

    private String getCalendarConditionActionName(int action) {
        String actionName = "unknown";
        switch (action) {
            case 2: {
                actionName = "Previous Day";
                break;
            }
            case 3: {
                actionName = "Next Day";
                break;
            }
            case 4: {
                actionName = "Next Calendar";
            }
        }
        return actionName;
    }

    private boolean isSupportedType(IAttrHolder eventMstRecord, RBC rbc) {
        boolean result = false;
        Integer evntType = eventMstRecord.getAttrAsInt("EVNTMST_TYPE");
        String evntName = eventMstRecord.getAttr("EVNTMST_NAME");
        String evntTypeName = "";
        switch (evntType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                result = true;
                break;
            }
            default: {
                evntTypeName = "Unknown type";
            }
        }
        if (!result) {
            this.issueMessage(evntName, "WRN2327", evntName, rbc.getName(), evntTypeName, evntType.toString());
            this.addCalendarAction(rbc.getName(), "WRN2327 -Tidal Calendar Type is currently not supported by the Conversion tool. The Calendar was converted to an empty Control-M Global Calendar. You will need to update Control-M Calendar manually to ensure it reflects the same scheduling behavior.");
        }
        return result;
    }

    private void addCalendarAction(String calendarName, String description) {
        HashMap<String, String> calendarAction = new HashMap<String, String>();
        calendarAction.put("ACTENTTYPE", "CAL");
        calendarAction.put("JOBID", "Not Relevant");
        calendarAction.put("ACTENTNAME", calendarName);
        calendarAction.put("ACTENTQTY", "0");
        calendarAction.put("ACTSTATUS", "0");
        calendarAction.put("ACTDESC", description);
        Reporter.addAction(calendarAction);
    }

    private RBC genrateEmptyRBC(IAttrHolder eventMstRecord) {
        RBC result = new RBC();
        result.setLevel(RBC.LEVEL.CONTROL_M);
        String validName = this.generateName(eventMstRecord);
        result.setName(validName);
        this.issueMessageIfTheCalendarDefinedAsNoPublic(eventMstRecord, validName);
        return result;
    }

    private void issueMessageIfTheCalendarDefinedAsNoPublic(IAttrHolder eventMstRecord, String validName) {
        if ("N".equals(eventMstRecord.getAttr("EVNTMST_PUBLIC"))) {
            String originalName = eventMstRecord.getAttr("EVNTMST_NAME") == null ? "" : eventMstRecord.getAttr("EVNTMST_NAME");
            this.issueMessage(originalName, "INF2029", originalName, validName);
        }
    }

    private void settingFirstDayOfTheWeek(RBC result) {
        String firstDayOfWeekRule = this.getFirstDayOfWeekRule().apply("Additional Tidal rules", "FIRST_DAY_OF_WEEK");
        result.setFirstDayOfTheWeek(RBC.stringToWEEKDAY((String)firstDayOfWeekRule));
    }

    private void setRbcByType(IAttrHolder eventMstRecord, RBC rbc) {
        Integer evntType = eventMstRecord.getAttrAsInt("EVNTMST_TYPE");
        switch (evntType) {
            case 2: {
                this.generateDaliyRbc(eventMstRecord, rbc);
                break;
            }
            case 3: {
                this.generateWeeklyRbc(eventMstRecord, rbc);
                break;
            }
            case 4: {
                this.generateMonthlyWithDaysRbc(eventMstRecord, rbc);
                break;
            }
            case 5: {
                this.generateMonthlyWithWeeksRbc(eventMstRecord, rbc);
                break;
            }
            case 6: {
                this.generateRbcBasedOnRegularCalendar(eventMstRecord, rbc);
                break;
            }
            case 7: {
                this.generateSubSetRBCCalendar(eventMstRecord, rbc);
            }
        }
    }

    private void generateSubSetRBCCalendar(IAttrHolder eventMstRecord, RBC rbc) {
        String originalCalendarName = Optional.ofNullable(eventMstRecord.getAttr("EVNTMST_NAME")).orElse("");
        int evntIdOfBaseCalendar = eventMstRecord.getAttrAsInt("EVNTMST_CALENDAR");
        IAttrHolder evntMstBaseCalendarRecord = this.eventGetter.getEvent(evntIdOfBaseCalendar);
        if (this.isCalendarExist(evntMstBaseCalendarRecord)) {
            if (this.isCalendarTypeList(evntMstBaseCalendarRecord)) {
                rbc.setDayscal(String.valueOf(evntIdOfBaseCalendar));
                rbc.addAllMonths();
                int days = this.getDaysForTheSubsetCalendar(eventMstRecord);
                this.setDaysInRBC(rbc, days);
            } else {
                this.issueMessage(originalCalendarName, "WRN2351", originalCalendarName, rbc.getName(), this.getCalendarType(evntMstBaseCalendarRecord));
            }
        }
    }

    private void setDaysInRBC(RBC rbc, int days) {
        try {
            if (days > 0) {
                rbc.addDay(RBC.DAY_TYPE.WORKINGDAY, days);
            }
            if (days < 0) {
                rbc.addDay(RBC.DAY_TYPE.DAY_FROM_END, Math.abs(days));
            }
        }
        catch (RBCIllegalValueException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
        }
    }

    private int getDaysForTheSubsetCalendar(IAttrHolder eventMstRecord) {
        int evntID = eventMstRecord.getAttrAsInt("EVNTMST_ID");
        int offset = eventMstRecord.getAttrAsInt("EVNTMST_OFFSET");
        int occur = eventMstRecord.getAttrAsInt("EVNTMST_OCCUR");
        if (offset == 0) {
            offset = this.getOffsetFromEvntConditions(evntID);
        }
        return occur + offset;
    }

    private Integer getOffsetFromEvntConditions(int evntID) {
        return this.eventConditionsGetter.getConditions(evntID).stream().findFirst().map(cond -> cond.getAttrAsInt("EVNTCOND_OFFSET")).orElse(0);
    }

    private void generateRbcBasedOnRegularCalendar(IAttrHolder eventMstRecord, RBC rbc) {
        String datacenterName = Params.instance().getDatacenterName();
        String ctmCalendarIdName = eventMstRecord.getAttr("EVNTMST_ID");
        CtmCalendar cal = new CtmCalendar(ctmCalendarIdName, datacenterName);
        rbc.setDayscal(ctmCalendarIdName);
        List<IAttrHolder> eventYEARRecord = this.eventYearListGetter.getYearList(Integer.parseInt(ctmCalendarIdName));
        for (IAttrHolder evtYear : eventYEARRecord) {
            int year = evtYear.getAttrAsInt("EVNTYEAR_YEAR");
            Object days = evtYear.getAttr("EVNTYEAR_DATES1") + evtYear.getAttr("EVNTYEAR_DATES2");
            days = ((String)days).replaceAll(" ", "N");
            this.fillCtmCalendarDays((String)days, year, cal);
        }
        this.ctmCalendar = Optional.of(cal);
    }

    private void fillCtmCalendarDays(String days, int year, CtmCalendar cal) {
        GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
        for (int i = 0; i < days.length(); ++i) {
            if ("Y".equals(String.valueOf(days.charAt(i)))) {
                cal.addDay(year, tmpCal.get(2) + 1, tmpCal.get(5));
            }
            tmpCal.add(6, 1);
        }
    }

    private void generateMonthlyWithDaysRbc(IAttrHolder eventMstRecord, RBC rbc) {
        char[] monthDays = this.asCharArray(eventMstRecord, "EVNTMST_MONTHDAYS");
        for (int monthDayNumber = 0; monthDayNumber < monthDays.length; ++monthDayNumber) {
            RBC.DAY_TYPE dayType = RBC.DAY_TYPE.DAY;
            int monthsDay = monthDayNumber + 1;
            if (monthsDay == 32) {
                dayType = RBC.DAY_TYPE.DAY_FROM_END;
            }
            if (monthDays[monthDayNumber] != 'Y') continue;
            try {
                rbc.addDay(dayType, monthsDay == 32 ? 1 : monthsDay);
                continue;
            }
            catch (RBCIllegalValueException e) {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            }
        }
    }

    private void generateMonthlyWithWeeksRbc(IAttrHolder eventMstRecord, RBC rbc) {
        char[] days = this.asCharArray(eventMstRecord, "EVNTMST_WEEKDAYS");
        char[] weeks = this.asCharArray(eventMstRecord, "EVNTMST_WEEKS");
        for (int weekNumber = 0; weekNumber < weeks.length; ++weekNumber) {
            if (weeks[weekNumber] != 'Y') continue;
            this.addDaysToWeek(rbc, days, weekNumber + 1);
        }
    }

    private char[] asCharArray(IAttrHolder eventMstRecord, String columnName) {
        String evntDays = eventMstRecord.getAttr(columnName);
        return this.normalize(evntDays).toCharArray();
    }

    private String normalize(String evntDays) {
        return evntDays.replaceAll("[\\s\\t]", "").toUpperCase();
    }

    private void addDaysToWeek(RBC rbc, char[] days, int weekNumber) {
        for (int i = 0; i < days.length; ++i) {
            Optional<RBC.WEEKDAYS> weekDay;
            if (days[i] != 'Y' || !(weekDay = this.getWeekDay(i)).isPresent()) continue;
            try {
                rbc.addDayInWeek(weekNumber, weekDay.get());
                continue;
            }
            catch (RBCIllegalValueException e) {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            }
        }
    }

    private void generateDaliyRbc(IAttrHolder eventMstRecord, RBC rbc) {
        this.convertWeekDays(eventMstRecord, rbc);
    }

    private void generateWeeklyRbc(IAttrHolder eventMstRecord, RBC rbc) {
        this.convertWeekDays(eventMstRecord, rbc);
    }

    private void convertWeekDays(IAttrHolder eventMstRecord, RBC rbc) {
        char[] days;
        String evntDays = eventMstRecord.getAttr("EVNTMST_WEEKDAYS");
        if (this.isEmptyWeekDays(evntDays, days = this.asCharArray(eventMstRecord, "EVNTMST_WEEKDAYS"))) {
            return;
        }
        this.addWeekdays(rbc, days);
    }

    private void addWeekdays(RBC rbc, char[] days) {
        for (int i = 0; i < days.length; ++i) {
            if (days[i] != 'Y') continue;
            Optional<RBC.WEEKDAYS> weekDay = this.getWeekDay(i);
            weekDay.ifPresent(arg_0 -> ((RBC)rbc).addWeekDay(arg_0));
        }
    }

    private boolean isEmptyWeekDays(String evntDays, char[] days) {
        return days.length == 0 || evntDays.equals("NNNNNNN");
    }

    private Optional<RBC.WEEKDAYS> getWeekDay(int weekday) {
        return switch (weekday) {
            case 0 -> Optional.of(RBC.WEEKDAYS.SUNDAY);
            case 1 -> Optional.of(RBC.WEEKDAYS.MONDAY);
            case 2 -> Optional.of(RBC.WEEKDAYS.TUESDAY);
            case 3 -> Optional.of(RBC.WEEKDAYS.WEDNESDAY);
            case 4 -> Optional.of(RBC.WEEKDAYS.THURSDAY);
            case 5 -> Optional.of(RBC.WEEKDAYS.FRIDAY);
            case 6 -> Optional.of(RBC.WEEKDAYS.SATURDAY);
            default -> Optional.empty();
        };
    }

    private void addMonths(String monthsStr, RBC targetRbc) {
        boolean defaultToAllMonths;
        boolean bl = defaultToAllMonths = monthsStr == null || monthsStr.matches("N{12}") || monthsStr.length() != 12;
        if (defaultToAllMonths) {
            targetRbc.addAllMonths();
        } else {
            for (int i = 0; i < 12; ++i) {
                if (monthsStr.charAt(i) == 'Y') {
                    targetRbc.addMonth(i + 1);
                    continue;
                }
                targetRbc.removeMonth(i + 1);
            }
        }
    }

    private boolean isDateConverted(LocalDate testedDate) {
        return testedDate != null && testedDate.getYear() > 1899;
    }

    private String generateName(IAttrHolder eventMstRecord) {
        String validName;
        Integer evntId = eventMstRecord.getAttrAsInt("EVNTMST_ID");
        if (idToUsedName.containsKey(evntId)) {
            validName = idToUsedName.get(evntId);
        } else {
            String originalName = eventMstRecord.getAttr("EVNTMST_NAME");
            validName = this.getValidationFunc().apply(originalName);
            if (idToUsedName.containsValue(validName)) {
                String evntIdAsString = evntId.toString();
                if (validName.length() + evntIdAsString.length() + 1 > 19) {
                    int cutLength = 19 - (evntIdAsString.length() + 1);
                    validName = validName.substring(0, cutLength);
                }
                validName = String.format("%s#%d", validName, evntId);
            }
            idToUsedName.put(evntId, validName);
            if (!originalName.equals(validName)) {
                String msgId = "INF2027";
                this.issueMessage(originalName, msgId, originalName, validName);
            }
        }
        return validName;
    }

    private boolean isSupportedFreqAndOffset(IAttrHolder eventMstRecord, RBC rbc) {
        String originalCalendarName = eventMstRecord.getAttr("EVNTMST_NAME") == null ? "" : eventMstRecord.getAttr("EVNTMST_NAME");
        String actualFrequency = eventMstRecord.getAttr("EVNTMST_FREQ") == null ? "" : eventMstRecord.getAttr("EVNTMST_FREQ");
        String actualOffset = eventMstRecord.getAttr("EVNTMST_OFFSET") == null ? "" : eventMstRecord.getAttr("EVNTMST_OFFSET");
        boolean isSupportedFrequency = actualFrequency.equals("1");
        boolean isSupportedOffset = actualOffset.equals("0");
        if (!this.isCalendarTypeList(eventMstRecord) && !this.isCalendarTypeSubset(eventMstRecord)) {
            this.issueMessageForUnsupportedFreqOrOffset(originalCalendarName, actualOffset, isSupportedOffset, "WRN2326", " -Tidal Calendar contains an offset value other than '0'. The Calendar was converted to an empty Control-M Global Calendar. You will need to update Control-M Calendar manually to ensure it reflects the same scheduling behavior. Consider using the Control-M Confirmation Calendar with the 'Shift By' option.");
        } else {
            isSupportedOffset = true;
            this.handleOffsetInCalendarListType(eventMstRecord, actualOffset, rbc);
        }
        this.issueMessageForUnsupportedFreqOrOffset(originalCalendarName, actualFrequency, isSupportedFrequency, "WRN2325", " -Tidal Calendar contains a frequency value other than '1'. The Calendar was converted to an empty Control-M Global Calendar. You will need to update Control-M Calendar manually to ensure it reflects the same scheduling behavior.");
        return isSupportedFrequency && isSupportedOffset;
    }

    private void issueMessageForUnsupportedFreqOrOffset(String originalCalendarName, String actual, boolean isSupported, String warning, String message) {
        if (!isSupported) {
            this.issueMessage(originalCalendarName, warning, originalCalendarName, actual);
            this.addCalendarAction(originalCalendarName, warning + message);
        }
    }

    private void handleOffsetInCalendarListType(IAttrHolder eventMstRecord, String offset, RBC rbc) {
        int offsetNumber;
        if (this.isCalendarTypeList(eventMstRecord) && (offsetNumber = Integer.parseInt(offset)) != 0) {
            rbc.setShiftnum(offsetNumber);
            rbc.setConfcal(this.allDaysCtmCalendarName);
        }
    }

    private boolean isCalendarTypeList(IAttrHolder eventMstRecord) {
        return eventMstRecord.getAttrAsInt("EVNTMST_TYPE") == 6;
    }

    private boolean isCalendarTypeSubset(IAttrHolder eventMstRecord) {
        return eventMstRecord.getAttrAsInt("EVNTMST_TYPE") == 7;
    }

    void issueMessage(String displayName, String msgId, String ... msgArgs) {
        new MessageRegistry().addMessage(displayName, msgId, msgArgs);
    }

    private Function<String, String> getValidationFunc() {
        Function<String, String> validationFunction = this.forceValidName;
        if (validationFunction == null) {
            validationFunction = name -> FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", name);
        }
        return validationFunction;
    }

    private BiFunction<String, String, String> getFirstDayOfWeekRule() {
        BiFunction<String, String, String> firstDayOfWeekRule = this.firstDayOfWeekRule;
        if (firstDayOfWeekRule == null) {
            firstDayOfWeekRule = (x, y) -> RuleManager.instance.getCurrentRules().getStringRule(x, new String[]{y});
        }
        return firstDayOfWeekRule;
    }

    public boolean isGroupCalendars(IAttrHolder eventMstRecord) {
        return eventMstRecord.getAttrAsInt("EVNTMST_TYPE") == 1;
    }

    private List<RBC> getAllCalendarsInGroupCalendarType(IAttrHolder eventMstRecord) {
        ArrayList<RBC> childRbcs = new ArrayList<RBC>();
        List<IAttrHolder> children = this.groupChildrenGetter.getchildren(eventMstRecord.getAttrAsInt("EVNTMST_ID"));
        for (IAttrHolder child : children) {
            List<RBC> tempRbcs = this.generateRbcs(child);
            boolean excludeChild = child.getAttrAsInt("EVNTCHLD_LOGIC") == 2;
            Integer offsetChild = child.getAttrAsInt("EVNTCHLD_OFFSET");
            for (RBC rbc : tempRbcs) {
                if (excludeChild) {
                    rbc.setAsExcludeRbc();
                }
                if (offsetChild == 0) continue;
                String groupCalendarName = eventMstRecord.getAttr("EVNTMST_NAME") == null ? "" : eventMstRecord.getAttr("EVNTMST_NAME");
                String childCalendarName = child.getAttr("EVNTMST_NAME") == null ? "" : child.getAttr("EVNTMST_NAME");
                this.issueMessage(String.format("%s_%s", groupCalendarName, childCalendarName), "WRN2346", groupCalendarName, childCalendarName, offsetChild.toString());
            }
            childRbcs.addAll(tempRbcs);
        }
        return childRbcs;
    }
}

