/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.Jobmst;

public class JobDep {
    public static final String JOBDEP_INGROUP = "JOBDEP_INGROUP";
    private IAttrHolder m_attrHolder;
    public static final String JOBDEP_ID = "JOBDEP_ID";
    public static final String JOBDEP_FILEEXTENT = "JOBDEP_FILEEXTENT";
    public static final String JOBDEP_FILETYPE = "JOBDEP_FILETYPE";
    public static final String JOBDEP_FILENAME = "JOBDEP_FILENAME";
    public static final int JOB_DEP_FILE = 2;
    public static final int JOB_DEP_JOB = 1;
    public static final int JOB_DEP_VARIABLE = 3;
    public static final int JOB_DEP_FILE_TYPE_EXISTING_FILE = 200;
    public static final String JOBDEP_JOBMST = "JOBDEP_JOBMST";
    public static final String JOBDEP_OPERATOR = "JOBDEP_OPERATOR";
    public static final String JOBDEP_STATUS = "JOBDEP_STATUS";
    public static final String JOBDEP_TYPE = "JOBDEP_TYPE";
    public static final String JOBDEP_DATEOFFSET = "JOBDEP_DATEOFFSET";

    public JobDep(IAttrHolder holder) {
        this.m_attrHolder = holder;
    }

    private String extractJobName(IAttrHolder iAttrHolder) {
        String JobName = "";
        if (iAttrHolder != null) {
            JobName = iAttrHolder.getAttr("JOBMST_NAME");
        }
        return JobName;
    }

    public String getSourceName() {
        int sourceID = this.m_attrHolder.getAttrAsInt(JOBDEP_JOBMST);
        IAttrHolder iAttrHolderSource = Jobmst.instance().getAttrbyJobID(sourceID);
        return this.extractJobName(iAttrHolderSource);
    }

    public String getTargetName() {
        int targetID = this.m_attrHolder.getAttrAsInt("JOBMST_ID");
        IAttrHolder iAttrHolderTarget = Jobmst.instance().getAttrbyJobID(targetID);
        return this.extractJobName(iAttrHolderTarget);
    }

    public String getSourceJobID() {
        int sourceID = this.m_attrHolder.getAttrAsInt(JOBDEP_JOBMST);
        return String.valueOf(sourceID);
    }

    public String getTargetJobID() {
        int targetID = this.m_attrHolder.getAttrAsInt("JOBMST_ID");
        return String.valueOf(targetID);
    }

    public String getAttr(String attrName) {
        return this.m_attrHolder.getAttr(attrName);
    }

    public Integer getAttrAsInt(String attrName) {
        return this.m_attrHolder.getAttrAsInt(attrName);
    }

    private static String translateOperator(int jobdep_operator) {
        switch (jobdep_operator) {
            case 1: {
                return "EQ";
            }
            case 2: {
                return "NE";
            }
            case 3: {
                return "LT";
            }
            case 4: {
                return "LE";
            }
            case 5: {
                return "GT";
            }
            case 6: {
                return "GE";
            }
        }
        return "??";
    }

    public boolean operatorIsValid() {
        return this.getOperator().compareTo("EQ") == 0;
    }

    private static JobDepType JobStatus2JobDepType(int jobStatus) {
        switch (JOB_STATUS.toEnum(jobStatus).ordinal()) {
            case 14: {
                return JobDepType.LAUNCH;
            }
            case 9: {
                return JobDepType.COMPLETED;
            }
            case 16: {
                return JobDepType.ENDED_OK;
            }
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 11: 
            case 27: {
                return JobDepType.ENDED_NOTOK;
            }
        }
        return JobDepType.UNSUPPORTED_JOBDEP;
    }

    public int getDateOffset() {
        Integer dateOffset = this.m_attrHolder.getAttrAsInt(JOBDEP_DATEOFFSET);
        return dateOffset == null ? 0 : dateOffset;
    }

    public int ownerJobId() {
        return this.m_attrHolder.getAttrAsInt("JOBMST_ID");
    }

    public int getJobDepID() {
        return this.m_attrHolder.getAttrAsInt(JOBDEP_ID);
    }

    public int dependencyJobId() {
        return this.getAttrAsInt(JOBDEP_JOBMST);
    }

    public int type() {
        return this.getAttrAsInt(JOBDEP_TYPE);
    }

    public int getJobStatus() {
        return this.getAttrAsInt(JOBDEP_STATUS);
    }

    public JobDepType getJobDepType() {
        JobDepType result = JobDep.JobStatus2JobDepType(this.getJobStatus());
        if (result != JobDepType.UNSUPPORTED_JOBDEP && !this.operatorIsValid()) {
            result = JobDepType.UNSUPPORTED_JOBDEP;
        }
        return result;
    }

    public String getOperator() {
        return JobDep.translateOperator(this.getAttrAsInt(JOBDEP_OPERATOR));
    }

    public static enum JOB_STATUS {
        JOB_STATUS_ABNORMAL(103),
        JOB_STATUS_ABORTED(106),
        JOB_STATUS_ACTIVE(51),
        JOB_STATUS_AGENTINACTIVE(8),
        JOB_STATUS_AGENTOUTAGE(9),
        JOB_STATUS_AGENTUNAVAIL(7),
        JOB_STATUS_CANCELLED(109),
        JOB_STATUS_CANCELLED_NORMAL(112),
        JOB_STATUS_CANCELLED_PENDING(12),
        JOB_STATUS_COMPLETED(100),
        JOB_STATUS_DEFERRED(53),
        JOB_STATUS_ERROR(66),
        JOB_STATUS_EXTERN(107),
        JOB_STATUS_HOLD(3),
        JOB_STATUS_LAUNCH(50),
        JOB_STATUS_ACTIVE_RANGE(50),
        JOB_STATUS_NORMAL(101),
        JOB_STATUS_ORPHAN(105),
        JOB_STATUS_PREABNORM(98),
        JOB_STATUS_PREDONE_RANGE(90),
        JOB_STATUS_PREEXTERN(99),
        JOB_STATUS_PRENORMAL(97),
        JOB_STATUS_PREORPHAN(110),
        JOB_STATUS_READY(49),
        JOB_STATUS_SCHEDULED(0),
        JOB_STATUS_SKIPPED(104),
        JOB_STATUS_STOP(52),
        JOB_STATUS_TIMEOUT(108),
        JOB_STATUS_TIMEOUTTODAY(5),
        JOB_STATUS_WAIT(1),
        JOB_STATUS_WAITCHILDREN(11),
        JOB_STATUS_WAITONGROUP(10),
        JOB_STATUS_WAITOP(2),
        JOB_STATUS_UNKNOWN(-1);

        private Integer value;

        public Integer getValue() {
            return this.value;
        }

        private JOB_STATUS(Integer value) {
            this.value = value;
        }

        public static JOB_STATUS toEnum(Integer value) {
            JOB_STATUS jobStatus = JOB_STATUS_UNKNOWN;
            for (JOB_STATUS type : JOB_STATUS.values()) {
                if (!type.value.equals(value)) continue;
                jobStatus = type;
                break;
            }
            return jobStatus;
        }
    }

    public static enum JobDepType {
        LAUNCH,
        COMPLETED,
        ENDED_OK,
        ENDED_NOTOK,
        UNSUPPORTED_JOBDEP;

    }
}

