/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.db.DbSqlWrapper;
import com.bmc.ctmconvert.tidal.AbstractTidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import com.bmc.ctmconvert.utils.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class JDBCConvertor
extends AbstractTidalCmConvertor {
    private final TidalJob job;
    private final DbSqlWrapper dbWrapper;

    public JDBCConvertor(TidalJob job) {
        this.job = job;
        this.dbWrapper = new DbSqlWrapper((SchedEntity)job).convertToDbSqlJob();
    }

    @Override
    public void convertCmValues(IAttrHolder jobDtlRecord) {
        XmlElement adapterXml = XmlLoader.from((String)jobDtlRecord.getAttr("JOBDTL_EXTINFO"));
        String query = this.getQueryFrom(adapterXml);
        this.dbWrapper.addSqlQuery(this.replaceVariablesIn(query)).setConnectionProfile(this.getDatabaseNameFrom(adapterXml).orElse("DEFAULT_CONNECTION"));
        this.getParametersFrom(adapterXml).forEach(p -> this.job.addAutoEdits((String)p.getKey(), (String)p.getValue()));
    }

    private Optional<String> getDatabaseNameFrom(XmlElement adapterXml) {
        return Optional.of(adapterXml.getFirstChildElementByName("dbname")).map(XmlElement::getValue).map(String::trim).filter(s -> !s.isEmpty());
    }

    private List<Pair<String, String>> getParametersFrom(XmlElement adapterXml) {
        List params = Optional.ofNullable(adapterXml.getFirstChildElementByName("params")).map(ps -> ps.getAllDecnedElementByName("param")).orElse(Collections.emptyList());
        return params.stream().map(p -> {
            String name = p.getValueOfFirstChildElementByName("pname").trim();
            String value = p.getValueOfFirstChildElementByName("pval").trim();
            return Pair.of((Object)("%%" + name), (Object)value);
        }).toList();
    }

    private String replaceVariablesIn(String query) {
        return query.replace(":", "%%");
    }

    private String getQueryFrom(XmlElement adapterXml) {
        return Optional.ofNullable(adapterXml.getFirstChildElementByName("sql")).map(XmlElement::getValue).map(String::trim).orElse("");
    }
}

