/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.tidal.CalcCyclicTimesSequence;
import com.bmc.ctmconvert.tidal.MessageReporter;

public class CyclicJobData {
    public String cyclicTimeSequences = "";
    public String cyclicType = null;
    public boolean isCyclic = false;
    public int maxReruns = 0;
    public int cyclicIntervals = 0;
    public String cyclicIntervalsStr = "00001M";
    private MessageReporter messageReporter;
    private IAttrHolder jobdtl_rec;
    private SchedEntity.TYPE jobType;

    public CyclicJobData(MessageReporter messageReporter, IAttrHolder jobdtl_rec, SchedEntity.TYPE jobType) {
        this.messageReporter = messageReporter;
        this.jobdtl_rec = jobdtl_rec;
        this.jobType = jobType;
    }

    boolean isTidalRepeatingJob() {
        return !this.jobdtl_rec.getAttr("JOBDTL_RERUN").isEmpty();
    }

    String buildCyclicIntervalString(int interval) {
        StringBuilder sb = new StringBuilder();
        String tmp = String.valueOf(interval);
        int numOfDigits = 5;
        int len = tmp.length();
        for (int i = 0; i < numOfDigits - len; ++i) {
            sb.append("0");
        }
        sb.append(tmp);
        sb.append("M");
        return sb.toString();
    }

    String handleCyclicAttribute() {
        String cycString = "0";
        if ((this.isTidalRepeatingJob() || this.isCustomDtlNotEmpty()) && (this.jobType == SchedEntity.TYPE.SMART_TABLE || this.jobType == SchedEntity.TYPE.JOB)) {
            this.isCyclic = true;
            cycString = "1";
            this.maxReruns = this.jobdtl_rec.getAttrAsInt("JOBDTL_INTERVALCNT");
            if (this.maxReruns > 99) {
                this.messageReporter.reportMaxRerunOutOfRange(this.maxReruns);
                this.maxReruns = 99;
            }
            if (this.isCustomDtlNotEmpty()) {
                this.setSpecificTimesCyclicAttributes();
            } else {
                this.setIntervalsCyclicAttributes();
            }
        }
        return cycString;
    }

    private boolean isCustomDtlNotEmpty() {
        return this.jobdtl_rec.isFieldExist("JOBDTL_CUSTOMST") && !this.jobdtl_rec.getAttr("JOBDTL_CUSTOMST").equals("");
    }

    private void setIntervalsCyclicAttributes() {
        this.cyclicType = "C";
        this.cyclicIntervals = this.jobdtl_rec.getAttrAsInt("JOBDTL_INTERVAL");
        this.cyclicIntervalsStr = this.buildCyclicIntervalString(this.cyclicIntervals);
    }

    private void setSpecificTimesCyclicAttributes() {
        this.cyclicType = "S";
        String timeSequence = this.jobdtl_rec.getAttr("JOBDTL_CUSTOMST");
        CalcCyclicTimesSequence calcCyclicTimesSequence = new CalcCyclicTimesSequence(this.jobdtl_rec);
        this.cyclicTimeSequences = calcCyclicTimesSequence.getTimesSequence();
    }

    void reportUnsupportedRepeatingJobGroup(String jobName) {
        if (this.isTidalRepeatingJob() && this.jobType == SchedEntity.TYPE.SUB_TABLE) {
            this.messageReporter.reportUnsupportedRepeatingJobSubFolder(jobName);
        }
    }
}

