/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tidal.JobDep;
import com.bmc.ctmconvert.tidal.Jobmst;
import com.bmc.ctmconvert.tidal.UniqueTidalConditionNameGenerator;

public class ConditionNameMaker {
    private JobDep jobDep;
    private UniqueTidalConditionNameGenerator uniqueTidalConditionNameGenerator = new UniqueTidalConditionNameGenerator();
    private RulesDataSet m_rules;
    private String convertFormat;

    public ConditionNameMaker(RulesDataSet m_rules) {
        this.m_rules = m_rules;
        this.getConvertFormat();
    }

    private void getConvertFormat() {
        this.convertFormat = this.m_rules.getStringRule("Tidal rules", new String[]{"ConvertToFormat"});
    }

    private String trimString(String jobName, int length) {
        if (jobName.length() > length) {
            jobName = jobName.substring(0, length);
        }
        return jobName;
    }

    public String buildCondName(JobDep jobDep) {
        this.jobDep = jobDep;
        this.getConvertFormat();
        if (this.convertFormat.equals("{Job/Folder Name}-TO-{TargetJob:Job/Folder Name}")) {
            return this.condJobAToJobBFormat(jobDep.getSourceName(), jobDep.getTargetName(), jobDep.getSourceJobID(), jobDep.getTargetJobID());
        }
        return this.condJobStatus();
    }

    public String condJobAToJobBFormat(String sourceJobName, String targetJobName, String sourceId, String targetId) {
        StringBuilder buffer = new StringBuilder();
        String condName = "";
        int chars2keep = 256;
        switch (this.jobDep.type()) {
            case 1: {
                chars2keep = 123;
                sourceJobName = this.trimString((String)sourceJobName, chars2keep);
                targetJobName = this.trimString(targetJobName, chars2keep);
                condName = this.uniqueTidalConditionNameGenerator.getUniqueConditionName(sourceId, targetId, (String)sourceJobName, targetJobName);
                condName = condName.replaceAll("[ '\\(\\)|\"]", "_");
                buffer.append(condName);
                break;
            }
            case 2: {
                int targetID = this.jobDep.getAttrAsInt("JOBMST_ID");
                IAttrHolder iAttrHolder = Jobmst.instance().getAttrbyJobID(targetID);
                String depId = String.valueOf(this.jobDep.getJobDepID() + "_");
                if (iAttrHolder != null) {
                    chars2keep = 123;
                    targetJobName = iAttrHolder.getAttr("JOBMST_NAME");
                    sourceJobName = "FW-" + targetJobName + "_" + String.valueOf(this.jobDep.getJobDepID());
                    sourceJobName = this.trimString((String)sourceJobName, chars2keep);
                    targetJobName = this.trimString(targetJobName, chars2keep);
                }
                condName = this.uniqueTidalConditionNameGenerator.getUniqueConditionName(depId, String.valueOf(targetID), (String)sourceJobName, targetJobName);
                condName = condName.replaceAll("[ '\\(\\)|\"]", "_");
                buffer.append(condName);
                break;
            }
            case 3: {
                buffer.append(String.valueOf(this.jobDep.getJobDepID() + "_"));
                buffer.append("VARIABLE_DEP_");
                buffer.append(this.jobDep.getAttr("VARMST_ID"));
                break;
            }
            default: {
                buffer.append(String.valueOf(this.jobDep.getJobDepID() + "_"));
                buffer.append("UNSUPPORTED_DEP_TYPE_");
                buffer.append((Object)this.jobDep.type());
            }
        }
        return buffer.toString();
    }

    public String condJobStatus() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(this.jobDep.getJobDepID() + "_"));
        switch (this.jobDep.type()) {
            case 1: {
                int job_depending_on = this.jobDep.dependencyJobId();
                String jobName = "unknown_jobname";
                try {
                    jobName = Jobmst.instance().getAttrbyJobID(job_depending_on).getAttr("JOBMST_NAME");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String job_depending_on_str = "_" + String.valueOf(job_depending_on);
                int chars2keep = 256;
                JobDep.JobDepType jobDepType = this.jobDep.getJobDepType();
                String prefix = String.format("%s_", jobDepType.toString());
                buffer.append(prefix);
                chars2keep = chars2keep - prefix.length() - job_depending_on_str.length();
                if (jobName.length() > chars2keep) {
                    jobName = jobName.substring(0, chars2keep);
                }
                jobName = jobName.replaceAll("[ '\\(\\)|\"]", "_");
                buffer.append(String.format("%s%s", jobName, job_depending_on_str));
                break;
            }
            case 2: {
                int fileDepJobID = this.jobDep.ownerJobId();
                String fileDepJobName = "unknown_jobname";
                try {
                    fileDepJobName = Jobmst.instance().getAttrbyJobID(fileDepJobID).getAttr("JOBMST_NAME");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String fileDepJobIDStr = "_" + String.valueOf(fileDepJobID);
                buffer.append("FILE_DEP");
                buffer.append(fileDepJobIDStr);
                buffer.append("_");
                buffer.append(fileDepJobName);
                buffer.append("_");
                buffer.append(this.jobDep.getAttr("JOBDEP_FILETYPE"));
                buffer.append("_");
                break;
            }
            case 3: {
                buffer.append("VARIABLE_DEP_");
                buffer.append(this.jobDep.getAttr("VARMST_ID"));
                break;
            }
            default: {
                buffer.append("UNSUPPORTED_DEP_TYPE_");
                buffer.append((Object)this.jobDep.type());
            }
        }
        return buffer.toString();
    }
}

