/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.EmptyAttrHolder;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.tidal.RbcFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Calendars {
    private static Calendars instance;
    public static final int UNDEFINED_CALENDAR = 0;
    private RecordsHolder evntyearRecords;
    private RecordsHolder evntConditionRecords;
    private RecordsHolder evntmstRecords;

    private Calendars() {
    }

    public static Calendars getInstance() {
        if (instance == null) {
            instance = new Calendars();
        }
        return instance;
    }

    public void writeRbcsToXml(RecordsHolder evntmstRecords, RecordsHolder evntyearRecords, RecordsHolder evntConditionRecords) {
        this.evntyearRecords = evntyearRecords;
        this.evntConditionRecords = evntConditionRecords;
        this.evntmstRecords = evntmstRecords;
        RbcFactory factory = new RbcFactory(eventId -> new ArrayList(), this::getYearList, this::getEvntConditionRecordList, this::getEvntMst);
        try (DefCalFile calendarsXml = DefCalFile.createDefCalFile();){
            factory.writeAllDaysCalendar(calendarsXml);
            for (IAttrHolder attr : evntmstRecords.getAllRecords()) {
                factory.WriteCalendarsToFile(attr, calendarsXml);
            }
        }
        catch (IOException e) {
            ExceptionHandler.getStackTrace((Exception)e);
        }
    }

    private List<IAttrHolder> getRecordsWithSameID(RecordsHolder evntyearRecords, int evntMstID) {
        return evntyearRecords.getAllRecords().stream().filter(rec -> rec.getAttrAsInt("EVNTMST_ID") == evntMstID).collect(Collectors.toList());
    }

    public List<IAttrHolder> getYearList(int evntMstID) {
        return this.getRecordsWithSameID(this.evntyearRecords, evntMstID);
    }

    public List<IAttrHolder> getEvntConditionRecordList(int evntMstID) {
        return this.getRecordsWithSameID(this.evntConditionRecords, evntMstID);
    }

    public IAttrHolder getEvntMst(int evntMstID) {
        return this.evntmstRecords.getAllRecords().stream().filter(rec -> rec.getAttrAsInt("EVNTMST_ID") == evntMstID).findFirst().orElse((IAttrHolder)new EmptyAttrHolder());
    }

    public static void destroy() {
        instance = null;
    }
}

