/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class CalcCyclicTimesSequence {
    private final IAttrHolder jobdtlRecord;
    private static final String delimitir = ",";

    public CalcCyclicTimesSequence(IAttrHolder jobdtlRecord) {
        this.jobdtlRecord = jobdtlRecord;
    }

    public String getTimesSequence() {
        String customsTimesSeperatedWithComma = this.jobdtlRecord.getAttr("JOBDTL_CUSTOMST");
        if (customsTimesSeperatedWithComma == null || customsTimesSeperatedWithComma.isEmpty()) {
            return "";
        }
        try {
            String[] parts = customsTimesSeperatedWithComma.split(delimitir);
            LinkedList<String> formattedParts = new LinkedList<String>();
            for (String specificTimeOrInterval : parts) {
                if (CalcCyclicTimesSequence.isSpecificTime(specificTimeOrInterval)) {
                    formattedParts.add(CalcCyclicTimesSequence.formatSpecificTimeWithHHmm(specificTimeOrInterval));
                    continue;
                }
                formattedParts.add(CalcCyclicTimesSequence.getSpecificTimesBasedOnInterval(specificTimeOrInterval));
            }
            return String.join((CharSequence)delimitir, formattedParts);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse attribute JOBDTL_CUSTOMST \"" + customsTimesSeperatedWithComma + "\"", e);
        }
    }

    @NotNull
    private static String getSpecificTimesBasedOnInterval(String specificTimeOrInterval) {
        return CalcCyclicTimesSequence.interpretMinutesIntervalToSpecificTimes(Integer.parseInt(specificTimeOrInterval));
    }

    private static boolean isSpecificTime(String specificTimeOrInterval) {
        return CalcCyclicTimesSequence.containsColon(specificTimeOrInterval);
    }

    @NotNull
    private static String formatSpecificTimeWithHHmm(String time) {
        if (time.length() <= 4) {
            return CalcCyclicTimesSequence.addLeadingZeros(time);
        }
        return time.replace(":", "");
    }

    private static boolean containsColon(String input) {
        return input.contains(":");
    }

    private static String addLeadingZeros(String time) {
        String[] parts = time.split(":");
        int hours = Integer.parseInt(parts[0]);
        int minutes = Integer.parseInt(parts[1]);
        return String.format("%02d%02d", hours, minutes);
    }

    private static String interpretMinutesIntervalToSpecificTimes(int intervalInMinutes) {
        LinkedList<String> result = new LinkedList<String>();
        for (int hour = 0; hour < 24; ++hour) {
            result.add(String.format("%02d%02d", hour, intervalInMinutes));
        }
        return String.join((CharSequence)delimitir, result);
    }
}

