/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.SelfConversionExecuter;
import com.bmc.ctmconvert.builderutils.BuilderUtils;
import com.bmc.ctmconvert.builderutils.CalculateJobTypes;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.rule.RulesParser;
import com.bmc.ctmconvert.workspace.Workspace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RunConversionCli {
    private static final String SELF_CONVERSION_CLI_ERROR_MESSAGE = "Conversion ended with Errors.\nFor more information, see <Conversion Home>\\logs\\selfConversionCliErrors";
    private static String inputDataPath = null;
    private static String conversionRulesPath = null;
    private static String targetControlM = "18";
    private static String resultsPath = null;
    private String[] args;
    private FileSystem fileSystem = FileSystems.getDefault();
    private ByteArrayOutputStream messagesWriter = new ByteArrayOutputStream();
    private PrintWriter messagePrinter;

    public void run() {
        this.messagePrinter = new PrintWriter(this.messagesWriter, true);
        this.messagePrinter.println("\nRunning SelfConversion from CLI\n");
        if (this.parseArgs(this.args)) {
            this.runConversionCli(this.fileSystem);
        }
        System.out.println(this.messagesWriter.toString());
    }

    private boolean parseArgs(String[] args) {
        inputDataPath = null;
        conversionRulesPath = null;
        targetControlM = "18";
        resultsPath = null;
        String description = "\n\nThe SelfConverionCLI utility gets input data that you want to convert to Control-M and\n\ta Conversion Rules json file, which is created using the Self Conversion GUI\n\tand It returns the Control-M definitions data result in an XML format";
        String usage = "\n\nUsage: SelfConversionCLI\n\t-inputData < input file in XML format>\n\t-convRules <conversion rules json file>\n\t-convResultFile <conversion result file name>\n\t[-targetCtmVersion <optional, The Control-M version you want to convert to, default: same as Self Conversion GUI default> ]\n";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (args[i].equalsIgnoreCase("-inputData")) {
                inputDataPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-convRules")) {
                conversionRulesPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetCtmVersion")) {
                targetControlM = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-convResultFile")) {
                resultsPath = args[++i];
                continue;
            }
            this.messagePrinter.println("Illegal parameters were specified." + description + usage);
            return false;
        }
        if (inputDataPath == null || conversionRulesPath == null || resultsPath == null) {
            this.messagePrinter.println("Missing parameters." + description + usage);
            return false;
        }
        this.messagePrinter.println("\nParameters used:");
        this.messagePrinter.println("inputData: " + inputDataPath);
        this.messagePrinter.println("convRules: " + conversionRulesPath);
        this.messagePrinter.println("convResultFile: " + resultsPath);
        this.messagePrinter.println("targetCtmVersion: " + targetControlM + "\n");
        return true;
    }

    private void runConversionCli(FileSystem fileSystem) {
        Workspace workspace;
        RulesParser rulesParser;
        String ruleSavedContent;
        JSONArray projectDataFilesPathArray = new JSONArray();
        projectDataFilesPathArray.put((Object)inputDataPath);
        try {
            Path path = fileSystem.getPath(conversionRulesPath, new String[0]);
            ruleSavedContent = new String(Files.readAllBytes(path));
        }
        catch (IOException e1) {
            String message = "Unable to read rules file: " + conversionRulesPath + "\n";
            this.writeToExceptionFile(this.messagePrinter, e1.getMessage(), message);
            return;
        }
        try {
            JSONObject ruleSavedContentJSONObj = new JSONObject(ruleSavedContent);
            JSONArray ruleContentForBuilderJSONArray = ruleSavedContentJSONObj.getJSONArray("rulesForServer");
            rulesParser = new RulesParser(ruleContentForBuilderJSONArray);
        }
        catch (JSONException e) {
            String message = "Illegal rules file: " + conversionRulesPath + "\n";
            this.writeToExceptionFile(this.messagePrinter, e.getMessage(), message);
            return;
        }
        Path resultDraftPath = fileSystem.getPath(resultsPath, new String[0]);
        SelfConversionExecuter selfConversionExecution = new SelfConversionExecuter(new BuilderUtils(fileSystem)::parseInputData);
        try {
            workspace = selfConversionExecution.executeConversion(projectDataFilesPathArray, rulesParser, resultDraftPath, targetControlM);
        }
        catch (ConvertorCancelClickException | ConvertorException | IOException e) {
            this.writeToExceptionFile(this.messagePrinter, e.getMessage(), SELF_CONVERSION_CLI_ERROR_MESSAGE);
            return;
        }
        catch (RuntimeException e) {
            this.writeToExceptionFile(this.messagePrinter, e.getMessage(), "");
            return;
        }
        DataAccumulator dataAccumulator = selfConversionExecution.getDataAccumulator();
        ByteArrayOutputStream outputXmlWriter = selfConversionExecution.getOutputXmlWriter();
        this.printResults(workspace, dataAccumulator, this.messagePrinter);
        this.writeXML(outputXmlWriter, this.messagePrinter, fileSystem);
    }

    private void writeXML(ByteArrayOutputStream outputXmlWriter, PrintWriter messagePrinter, FileSystem fileSystem) {
        Path path = fileSystem.getPath(resultsPath, new String[0]);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            outputXmlWriter.writeTo(outputStream);
        }
        catch (IOException e) {
            String message = "Unable to write output XML to file: " + resultsPath + "\n";
            this.writeToExceptionFile(messagePrinter, e.getMessage(), message);
        }
    }

    private void printResults(Workspace workspace, DataAccumulator dataAccumulator, PrintWriter messagePrinter) {
        messagePrinter.println("\nConversion completed successfully");
        messagePrinter.println(resultsPath + " created.\n");
        messagePrinter.println("Entities created:");
        messagePrinter.println("----------------");
        messagePrinter.println("Control-M Folders: " + dataAccumulator.getCreatedFoldersCount().toString());
        messagePrinter.println("Control-M Sub Folders: " + dataAccumulator.getCreatedSubCount().toString());
        messagePrinter.println("Control-M Jobs: " + dataAccumulator.getCreatedJobsCount().toString());
        if (dataAccumulator.getCreatedJobsCount() < workspace.getJobsList().size()) {
            messagePrinter.println("Some jobs are missing from the output XML");
        }
        if (dataAccumulator.getCreatedFoldersCount() < workspace.getFoldersList().size()) {
            messagePrinter.println("Some folders are missing from the output XML");
        }
        messagePrinter.println("\nJob Types distribution:");
        messagePrinter.println("------------------------");
        JSONObject jsonResponse = new JSONObject();
        CalculateJobTypes calculateJobTypes = new CalculateJobTypes();
        calculateJobTypes.sortJobsByKind(workspace, jsonResponse);
        JSONArray jobTypeCounts = (JSONArray)jsonResponse.get("jobTypeResult");
        for (int i = 0; i < jobTypeCounts.length(); ++i) {
            JSONObject jobTypeCount = (JSONObject)jobTypeCounts.get(i);
            messagePrinter.println(String.valueOf(jobTypeCount.get("type")) + ": " + String.valueOf(jobTypeCount.get("counter")));
        }
    }

    private void writeToExceptionFile(PrintWriter messagePrinter, String exceptionMessage, String message) {
        ExceptionHandler.initSelfConversionCLIExceptionFile();
        ExceptionHandler.writeToSelfConversionCliExceptionFile((String)(message + exceptionMessage));
        messagePrinter.println(SELF_CONVERSION_CLI_ERROR_MESSAGE);
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setMessagesWriter(ByteArrayOutputStream messagesWriter) {
        this.messagesWriter = messagesWriter;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }
}

