/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.conversion_updater;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.conversion_updater.DownloadUpdateWorker;
import com.bmc.ctmconvert.conversion_updater.InstallUpdateWorker;
import java.util.concurrent.ExecutionException;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class UpdateStepsPublisher {
    public boolean downloadUpdatePackage(JProgressBar downloadProgressBar) {
        DownloadUpdateWorker downloadWorker = new DownloadUpdateWorker(downloadProgressBar);
        return this.execute(downloadWorker);
    }

    public boolean installUpdatePackage(JProgressBar installProgressBar) {
        InstallUpdateWorker installWorker = new InstallUpdateWorker();
        installWorker.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("progress")) {
                int progress = (Integer)evt.getNewValue();
                installProgressBar.setValue(progress);
            }
        });
        return this.execute(installWorker);
    }

    private boolean execute(SwingWorker<Boolean, String> downloadWorker) {
        downloadWorker.execute();
        try {
            return downloadWorker.get();
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionHandler.writeToExceptionFile(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

