/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.conversion_updater;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.VersionNameExtractor;
import com.bmc.ctmconvert.common.WhichAppRunning;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.configuration.themes.ProgressBarTheme;
import com.bmc.ctmconvert.conversion_updater.ConversionToolProcessor;
import com.bmc.ctmconvert.conversion_updater.UpdateStepsPublisher;
import com.bmc.ctmconvert.conversion_updater.UpdaterGlobals;
import com.bmc.ctmconvert.services.FilesManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;

public class UpdateIndicatorWindow {
    private final ProgressBarTheme theme = ThemeConfiguration.get().getProgressBarTheme();
    private boolean isUpdateFinish = false;
    private boolean isUpdateFail = false;
    private JFrame mainFrame;
    private JPanel footerPanel;
    private BaseButton runToolButton;
    private JProgressBar downloadProgressBar;
    private JProgressBar installProgressBar;
    private JLabel downloadTitle;
    private JLabel installTitle;
    private final Dimension panelsMaxSize = new Dimension(400, 100);

    public UpdateIndicatorWindow() {
        ExceptionHandler.initExceptionFile();
        this.initializeTextManager();
        this.initializeComponents();
    }

    private void initializeTextManager() {
        try {
            TextManager.initiateInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    private void initializeComponents() {
        this.setMainFrameSettings();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBackground(Color.WHITE);
        String titleText = String.format("%s%s %s%s", "<h2>", UpdaterGlobals.TITLE_TEXT, this.getLatestVersion(), "</h2>");
        JPanel titlePanel = this.insertTextToPanel(titleText, 1);
        JPanel downloadPanel = new JPanel(new GridLayout(2, 1));
        downloadPanel.setMaximumSize(this.panelsMaxSize);
        downloadPanel.setBackground(FlowGlobals.ConversionWhite);
        this.downloadTitle = new JLabel("Downloading latest version:");
        downloadPanel.add(this.downloadTitle);
        this.downloadProgressBar = this.createProgressBar();
        downloadPanel.add(this.downloadProgressBar);
        JPanel installPanel = new JPanel(new GridLayout(2, 1));
        installPanel.setMaximumSize(this.panelsMaxSize);
        installPanel.setBackground(FlowGlobals.ConversionWhite);
        this.installTitle = new JLabel("Installing new version:");
        installPanel.add(this.installTitle);
        this.installProgressBar = this.createProgressBar();
        installPanel.add(this.installProgressBar);
        JPanel phasesHolder = new JPanel();
        phasesHolder.setLayout(new BoxLayout(phasesHolder, 1));
        phasesHolder.setBackground(FlowGlobals.ConversionWhite);
        phasesHolder.add(downloadPanel);
        phasesHolder.add(installPanel);
        this.footerPanel = new JPanel(new FlowLayout(0));
        this.runToolButton = new BaseButton("Run current tool");
        this.footerPanel.setBackground(FlowGlobals.ConversionWhite);
        mainPanel.add((Component)titlePanel, "North");
        mainPanel.add((Component)phasesHolder, "Center");
        mainPanel.add((Component)this.footerPanel, "South");
        mainPanel.setSize(new Dimension(450, 350));
        this.mainFrame.setContentPane(mainPanel);
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.setSize(470, 350);
        this.mainFrame.setLocationRelativeTo(null);
    }

    private JProgressBar createProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setMinimum(0);
        progressBar.setMaximum(100);
        progressBar.setBackground(this.theme.backgroundColor);
        progressBar.setForeground(this.theme.foregroundColor);
        progressBar.setStringPainted(true);
        return progressBar;
    }

    private void setMainFrameSettings() {
        this.mainFrame = new JFrame(UpdaterGlobals.WINDOW_TITLE);
        this.mainFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(FlowGlobals.BMC_ICON_PATH)));
        this.mainFrame.setBackground(Color.WHITE);
        this.mainFrame.setResizable(false);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                boolean isChooseToExit;
                if (UpdateIndicatorWindow.this.isUpdateFinish || UpdateIndicatorWindow.this.isUpdateFail) {
                    UpdateIndicatorWindow.this.mainFrame.dispatchEvent(new WindowEvent(UpdateIndicatorWindow.this.mainFrame, 202));
                }
                if (!(isChooseToExit = BaseMessageDialog.showMessageDialog(UpdaterGlobals.CANCEL_UPDATE_TITLE, "Are you sure you want to cancel?", BaseMessageDialog.TYPE.CONFIRM_MESSAGE))) {
                    return;
                }
                FilesManager filesManager = new FilesManager();
                Path homeDir = Paths.get(UpdaterGlobals.HOME_DIR, new String[0]);
                Path updatePackage = Paths.get(UpdaterGlobals.UPDATE_PACKAGE_LOCAL_LOCATION, new String[0]);
                Path backUpDir = UpdaterGlobals.BACK_UP_DIRECTORY;
                try {
                    if (Files.exists(updatePackage, new LinkOption[0])) {
                        filesManager.deleteDirectory(updatePackage);
                    }
                    if (Files.exists(backUpDir, new LinkOption[0])) {
                        filesManager.extractDirIntoDir(backUpDir, homeDir);
                        filesManager.deleteDirectory(backUpDir);
                    }
                }
                catch (IOException e1) {
                    ExceptionHandler.writeToExceptionFile(e1);
                }
                UpdateIndicatorWindow.this.mainFrame.dispatchEvent(new WindowEvent(UpdateIndicatorWindow.this.mainFrame, 202));
            }

            @Override
            public void windowClosed(WindowEvent e) {
                UpdateIndicatorWindow.this.mainFrame.dispose();
                System.exit(0);
            }
        });
    }

    private JTextPane getHtmlJTextPane() {
        JTextPane htmlTextPane = new JTextPane();
        htmlTextPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        return htmlTextPane;
    }

    private JPanel insertTextToPanel(String text, int orientation) {
        JPanel panel = new JPanel(new FlowLayout(orientation));
        panel.setMaximumSize(this.panelsMaxSize);
        panel.setBackground(Color.WHITE);
        JTextPane textHolder = this.getHtmlJTextPane();
        textHolder.setText(text);
        panel.add(textHolder);
        return panel;
    }

    public void show() {
        this.mainFrame.setVisible(true);
    }

    private String getLatestVersion() {
        String versionContentPath = Globs.TEMP_DIR + Globs.DIRSEP + "VersionsContent.txt";
        FileInputStream versionContentStream = null;
        try {
            versionContentStream = new FileInputStream(versionContentPath);
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        String fullVersionName = VersionNameExtractor.extractLatestVersion(versionContentStream);
        return fullVersionName.substring(fullVersionName.indexOf(46) + 1);
    }

    public void startUpdate() {
        UpdateStepsPublisher updatePublisher = new UpdateStepsPublisher();
        boolean downloadResult = updatePublisher.downloadUpdatePackage(this.downloadProgressBar);
        if (downloadResult) {
            this.changePhaseStatus(this.downloadTitle, "Package successfully downloaded");
            boolean installResult = updatePublisher.installUpdatePackage(this.installProgressBar);
            if (installResult) {
                try {
                    this.waitUntilInstallFullyCompleted();
                    this.isUpdateFinish = true;
                }
                catch (InterruptedException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                    Thread.currentThread().interrupt();
                }
                this.changePhaseStatus(this.installTitle, "Package successfully Installed");
                this.runConversion();
            } else {
                this.isUpdateFail = true;
                this.changePhaseStatus(this.installTitle, "Failed to install package");
                this.showRunToolOption();
            }
        } else {
            this.isUpdateFail = true;
            this.changePhaseStatus(this.downloadTitle, "Failed to download package");
            this.showRunToolOption();
        }
    }

    private void waitUntilInstallFullyCompleted() throws InterruptedException {
        while (this.installProgressBar.getValue() != 100) {
            Thread.sleep(100L);
        }
    }

    private void showRunToolOption() {
        this.footerPanel.add(Box.createHorizontalStrut(300));
        this.footerPanel.add(this.runToolButton);
        this.runToolButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                UpdateIndicatorWindow.this.runConversion();
            }
        });
        this.footerPanel.revalidate();
        this.footerPanel.repaint();
    }

    private void changePhaseStatus(JLabel titleLabel, String text) {
        titleLabel.setText(text);
        titleLabel.revalidate();
        titleLabel.repaint();
    }

    private void runConversion() {
        ConversionToolProcessor conversionProcessor = new ConversionToolProcessor();
        WhichAppRunning whichAppRunning = new WhichAppRunning();
        try {
            String currentApp = whichAppRunning.getCurrentApp();
            if (currentApp.equals("Conversion")) {
                conversionProcessor.executeConversion();
            } else {
                conversionProcessor.executeSelfConversion();
            }
            this.mainFrame.dispatchEvent(new WindowEvent(this.mainFrame, 202));
        }
        catch (IOException e1) {
            ExceptionHandler.writeToExceptionFile(e1);
            BaseMessageDialog.showMessageDialog("Launch Failed", "Error occurred when running the current tool", BaseMessageDialog.TYPE.ERROR_MESSAGE);
        }
    }
}

